package com.roke.huayangproject.utils;

import android.content.Context;
import android.util.Log;
import android.widget.TextView;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/**
 * 系统工具类
 * Created by zhaoxinlong on 16/8/18.
 */
public class SystemUtil {
    /**
     * 获取版本名称
     *
     * @param mContext 数据上下文
     * @return 版本号：v1.0
     */
    public static String getVersionName(Context mContext) {
        String verName = "1.0";
        try {
            verName = mContext.getPackageManager().getPackageInfo(mContext.getPackageName(), 0).versionName;
        } catch (Exception e) {
        }
        verName = "版本号：v" + verName;
        return verName;
    }

    /**
     * 获取版本号
     * @return
     */
    public static int getAppVersionCode(Context context) {
        String packName = getPackageName(context);
        int verCode = -1;
        try {
            verCode = context.getPackageManager().getPackageInfo(packName, 0).versionCode;
        } catch (Exception e) {
            Log.e("版本号获取异常", e.getMessage());
        }
        return verCode;
    }

    /**
     * 获取版权信息
     *
     * @param copyright
     */
    public static void getCopyright(TextView copyright) {
        int birthdayYear = 2017;
        // 获取当前年份，如果和birthday相等不做处理 不等则 birthday year-current year
        Calendar calendar = Calendar.getInstance();
        int currentYear = calendar.get(Calendar.YEAR);

        if (currentYear == birthdayYear) {
            copyright.setText("Copyright © " + birthdayYear + " 佳怡物流.");
        } else {
            copyright.setText("Copyright © " + birthdayYear + "-" + currentYear + " 佳怡物流.");
        }
    }

    /**
     * 获取包名
     *
     * @param context
     * @return
     */
    public static String getPackageName(Context context) {
        return context.getPackageName();
    }

    // 获取当前系统时间
    public static String getCurTime() {
        SimpleDateFormat dateFormate = new SimpleDateFormat("yyyyMMdd");
        Date date = new Date(System.currentTimeMillis());
        return dateFormate.format(date);
    }
    // 获取当前系统时间
    public static String getCurTimeByLine() {
        SimpleDateFormat dateFormate = new SimpleDateFormat("yyyy-MM-dd");
        Date date = new Date(System.currentTimeMillis());
        return dateFormate.format(date);
    }
    // 获取当前系统时间
    public static String getCurTimeDetail() {
        SimpleDateFormat dateFormate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = new Date(System.currentTimeMillis());
        return dateFormate.format(date);
    }
}
