package com.roke.huayangproject.ui.unloading;


import android.content.Intent;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.View;
import android.widget.EditText;

import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.roke.huayangproject.R;
import com.roke.huayangproject.adapter.LoadingListAdapter;
import com.roke.huayangproject.base.BaseActivity;
import com.roke.huayangproject.bean.LoadingListBean;
import com.roke.huayangproject.http.ShipHttpClient;
import com.roke.huayangproject.ui.loading.LoadingActivity;
import com.roke.huayangproject.utils.CommonUtils;
import com.roke.huayangproject.utils.JsonUtil;
import com.roke.huayangproject.utils.ShowMsgUtils;

import java.util.ArrayList;
import java.util.List;

import butterknife.Bind;

//create :  3C
//时间2021/11/3 13:19
public class UnLoadingListActivity extends BaseActivity {
    @Bind(R.id.rv_menu)
    RecyclerView rvMenu;
    @Bind(R.id.et_search)
    EditText etSearch;
    private LoadingListBean info;
    private LoadingListAdapter adapter;
    @Override
    protected void init() {
        rvMenu.setLayoutManager(new LinearLayoutManager(mContext));
        etSearch.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }
            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }
            @Override
            public void afterTextChanged(Editable s) {
                String data = etSearch.getText().toString().trim();
                if (!CommonUtils.isNull(data)){
                    List<LoadingListBean.ResultBean> beans = new ArrayList<>();
                    for (LoadingListBean.ResultBean resultBean : info.getResult()) {
                        if (resultBean.getCar_no().contains(data) || resultBean.getOrder_code().contains(data)){
                            beans.add(resultBean);
                        }
                    }
                    setRecycleView(beans);
                }else{
                    if (null !=info){
                        setRecycleView(info.getResult());
                    }
                }

            }
        });
    }

    @Override
    protected int getLayoutId() {
        return R.layout.activity_transport;
    }

    @Override
    protected String getActionBarTitle() {
        return "卸货列表";
    }

    @Override
    protected boolean getHasMenu() {
        return false;
    }

    @Override
    protected void submitClick() {

    }

    @Override
    public void initView() {

    }

    @Override
    public void initData() {
        showD();
        ShipHttpClient.getInstance().get_transport_order_xc(mContext,  new ShipHttpClient.CrabHttpCallback<String>() {
            @Override
            public void onSuccess(String json) {
                closeD();
                info = JsonUtil.parseJsonToBean(json, LoadingListBean.class);
                if (null != info && null != info.getResult() && info.getResult().size() > 0) {
                    setRecycleView(info.getResult());
                } else {
                    ShowMsgUtils.ShowMessage(mContext, "当前没有任务!");
                }
            }

            @Override
            public void onError(String msg) {
                closeD();
                ShowMsgUtils.ShowMessage(mContext, msg);
            }
        });
    }
    public void setRecycleView(List<LoadingListBean.ResultBean> beans){
        adapter = new LoadingListAdapter(beans);
        rvMenu.setAdapter(adapter);
        adapter.setOnItemClickListener(new BaseQuickAdapter.OnItemClickListener() {
            @Override
            public void onItemClick(BaseQuickAdapter adapter, View view, final int position) {
                List<LoadingListBean.ResultBean> beans =  adapter.getData();
               //进入详情
                Intent intent = new Intent(mContext, UnLoadingActivity.class);
                intent.putExtra("code",beans.get(position).getOrder_code());
                intent.putExtra("codeid",beans.get(position).getOrder_id());
                startActivityForResult(intent,0);
            }
        });
    }

}
