package com.roke.huayangproject.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;


import com.roke.huayangproject.R;
import com.roke.huayangproject.bean.MenuInfo;

import java.util.List;

/**
 * Created by 赵新龙 on 2019/7/8.
 */

public class MenuAdapter extends RecyclerView.Adapter<MenuAdapter.ViewHolder> {

    private  Context context;
    private  List<MenuInfo.ResultBean> menuInfos;
    private OnItemClickListener listener;
    private LayoutInflater mInflater;

    public MenuAdapter(Context context , List<MenuInfo.ResultBean> mData, OnItemClickListener listener) {
        this.context =context;
        menuInfos = mData;
        this.listener = listener;
    }
    @Override
    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        ViewHolder  vh = null;
        mInflater = LayoutInflater.from(context);
        //判断viewtype类型返回不同Viewholder
        switch (viewType) {
            case 0:
                vh = new HolderOne(mInflater.inflate(R.layout.recycler_menu_line, parent, false));
                break;
            case 1:
                vh = new HolderTwo(mInflater.inflate(R.layout.recycler_menu_item, parent,false));
                break;
        }
        return vh;
    }

    @Override
    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        final RecyclerView.LayoutManager manager = recyclerView.getLayoutManager();
        if (manager instanceof GridLayoutManager) {
            final GridLayoutManager gridManager = (GridLayoutManager) manager;
            gridManager.setSpanSizeLookup(new GridLayoutManager.SpanSizeLookup() {

                @Override
                public int getSpanSize(int position) {

                    int type = getItemViewType(position);
                    switch (type) {
                        case 0:
                            return 5;
                        case 1:
                            return 1;

                    }
                    return 1;
                }
            });
        }
    }

    @Override
    public void onBindViewHolder(@NonNull final ViewHolder holder, int position) {
        if(menuInfos.get(position).getItemType() == 0){
            holder.mTitle.setText(menuInfos.get(position).getMenu_name());
        }else {
            holder.mItem.setText(menuInfos.get(position).getMenu_name());
            int drawable = context.getResources().getIdentifier( menuInfos.get(position).getMenu_icon_name(), "drawable", context.getApplicationInfo().packageName);
            if (drawable == 0 || drawable == -1){
                drawable = context.getResources().getIdentifier( "jianhuo", "drawable", context.getApplicationInfo().packageName);
            }
            holder.mImageView.setImageResource(drawable);
            holder.itemView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    if (null!=listener){
                        listener.onItemClick(holder.getAbsoluteAdapterPosition());
                    }
                }
            });
        }
    }



    @Override
    public int getItemCount() {
        return menuInfos.size();
    }


    @Override
    public int getItemViewType(int position) {
        int itemType = menuInfos.get(position).getItemType();

        return itemType;
    }



    public class ViewHolder extends RecyclerView.ViewHolder {
        public TextView mTitle;
        public TextView mItem;
        public ImageView mImageView;
        public ViewHolder(View itemView) {
            super(itemView);
        }
    }
    public class HolderOne extends ViewHolder {

        public HolderOne(View viewHolder) {
            super(viewHolder);
            mTitle= (TextView) viewHolder.findViewById(R.id.tv_title);
        }
    }

    public class HolderTwo extends ViewHolder {

        public HolderTwo(final View viewHolder) {
            super(viewHolder);
            mItem =(TextView)viewHolder.findViewById(R.id.tv_title);
            mImageView =(ImageView) viewHolder.findViewById(R.id.iv_img);
        }
    }

    public interface OnItemClickListener{
        void onItemClick(int position);
    }
}
