package com.roke.huayangproject.utils;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.DialogInterface.OnClickListener;

/**
 * toast和dialog工具类
 * Created by 赵新龙 on 16/7/28.
 */
public class ShowMsgUtils {

    public static void ShowMessage(Context mContext, String msg) {
        //可以使用自定义 R.style.MyDialogTheme
        AlertDialog.Builder alertBuilder = new AlertDialog.Builder(mContext);
        alertBuilder.setTitle("提示");
        alertBuilder.setMessage(msg);
        alertBuilder.setCancelable(false);
        alertBuilder.setPositiveButton("确定", new OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        });
        alertBuilder.show();
    }
    public static void ShowMessage(Context mContext,String title, String msg) {
        //可以使用自定义 R.style.MyDialogTheme
        AlertDialog.Builder alertBuilder = new AlertDialog.Builder(mContext);
        alertBuilder.setTitle(title);
        alertBuilder.setMessage(msg);
        alertBuilder.setCancelable(false);
        alertBuilder.setPositiveButton("确定", new OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        });
        alertBuilder.show();
    }

    public static void ShowMessage(Context mContext, String msg, OnClickListener listener) {
        AlertDialog.Builder alertBuilder = new AlertDialog.Builder(mContext);
        alertBuilder.setTitle("提示");
        alertBuilder.setMessage(msg);
        alertBuilder.setCancelable(false);
        alertBuilder.setPositiveButton("确定", listener);
        alertBuilder.show();
    }

    public static void ShowMessageWithCancelBtn(Context mContext, String msg,
                                                OnClickListener listener) {
        AlertDialog.Builder alertBuilder = new AlertDialog.Builder(mContext);
        alertBuilder.setTitle("提示");
        alertBuilder.setMessage(msg);
        alertBuilder.setCancelable(false);
        alertBuilder.setPositiveButton("确定", listener);
        alertBuilder.setNegativeButton("取消", new OnClickListener() {

            @Override
            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        });
        alertBuilder.show();
    }

    public static void ShowMessageWithCancelBtn(Context mContext, String msg,
                                                final OnClickListener confirmListener, OnClickListener cancleListener) {
        AlertDialog.Builder alertBuilder = new AlertDialog.Builder(mContext);
        alertBuilder.setTitle("提示");
        alertBuilder.setMessage(msg);
        alertBuilder.setCancelable(false);
        alertBuilder.setPositiveButton("确定", confirmListener);
        alertBuilder.setNegativeButton("取消", cancleListener);
        alertBuilder.show();
    }


}
