package com.roke.huayangproject.ui.setting;

import android.content.Context;
import android.content.SharedPreferences;
import android.graphics.PixelFormat;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;

import androidx.appcompat.app.AppCompatActivity;


import com.roke.huayangproject.MainActivity;
import com.roke.huayangproject.R;
import com.roke.huayangproject.utils.CommonUtils;
import com.roke.huayangproject.utils.SimplexToast;

import butterknife.Bind;
import butterknife.ButterKnife;
import butterknife.OnClick;
import me.jessyan.autosize.internal.CustomAdapt;

public class SettingActivity extends AppCompatActivity implements CustomAdapt {


    private Context mContext;
    private String TAG = MainActivity.class.getCanonicalName();

    @Bind(R.id.iv_back_left)
    ImageView iv_back_left;
    @Bind(R.id.et_ip)
    EditText et_ip;
    @Bind(R.id.et_zt)
    EditText et_zt;
    @Bind(R.id.btn_setip)
    Button btn_setip;
    private SharedPreferences pref;
    private SharedPreferences.Editor editor;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_setting);
        mContext = this;
        ButterKnife.bind(this);
        getWindow().setFormat(PixelFormat.TRANSLUCENT);
        if (null != getSupportActionBar()) {
            getSupportActionBar().hide();
        }
        pref = getSharedPreferences("IpInfo",MODE_PRIVATE);
        editor = pref.edit();
        if (pref.getString("ip",null)!=null){
            et_ip.setText(pref.getString("ip",null));
            et_zt.setText(pref.getString("zt",null));
        }
    }
    @OnClick({R.id.iv_back_left, R.id.btn_setip})
    public void onViewClicked(View view) {
        switch (view.getId()) {
            case R.id.iv_back_left:
                //返回上一页
                finish();
                break;
            case R.id.btn_setip:
                if (CommonUtils.isNull(et_ip)) {
                    SimplexToast.show(mContext, "IP及端口不能为空!");
                    return;
                }
                if (CommonUtils.isNull(et_zt)) {
                    SimplexToast.show(mContext, "账套不能为空!");
                    return;
                }
                String ip = et_ip.getText().toString();
                if (ip.contains("http://")){
                    ip = ip.replace("http://","");
                }
                if (ip.contains("https://")){
                    ip = ip.replace("https://","");
                }
                int len = ip.length()-2;
                String last = ip.substring(len,ip.length()-1);
                if (last.equals("/")){
                    ip = ip.substring(0,ip.length()-1);
                }
                editor.putString("ip",ip);
                editor.putString("zt",et_zt.getText().toString());
                editor.commit();
                SimplexToast.show(mContext,"设置成功");
                finish();
                break;
        }
    }

    //是否按照宽度进行适配,true为是,false用高度进行适配
    @Override
    public boolean isBaseOnWidth() {
        return false;
    }

    //设置当前屏幕大小,根据上边true或者false设置宽高,是用系统的用的是0
    @Override
    public float getSizeInDp() {
        return 0;
    }


    @Override
    protected void onDestroy() {
        super.onDestroy();
        ButterKnife.unbind(this);

    }
}
