package com.roke.huayangproject.http;

import android.content.Context;
import android.util.Log;

import com.lzy.okgo.OkGo;
import com.lzy.okgo.request.GetRequest;
import com.lzy.okgo.request.PostRequest;
import com.roke.huayangproject.HuaYangApp;
import com.roke.huayangproject.utils.CommonUtils;
import com.roke.huayangproject.utils.JsonUtil;

import org.json.JSONException;
import org.json.JSONObject;

import okhttp3.Call;
import okhttp3.Response;

/**
 * Created by Administrator on 2018/6/4.
 */

public class ShipHttpClient {
    static String ERROR_MSG = "连接服务器失败,请检查网络";
    public static final int RESULT_CODE_SUCCESS = 0;
    public static final int RESULT_CODE_ERROR = 1;
    public static final int RESULT_CODE_PASW = 100003;

    public interface CrabHttpCallback<String> {
        void onSuccess(String json);

        void onError(String msg);
    }

    private static ShipHttpClient instance;

    public static synchronized ShipHttpClient getInstance() {
        if (instance == null) {
            instance = new ShipHttpClient();
        }
        return instance;
    }


    /**
     * 登录--通过--内网
     *
     * @param crabHttpCallback`
     */
    public void login(String ip,String zt,Context context, String username, String password, CrabHttpCallback<String> crabHttpCallback) {
        String[] key = new String[]{"login", "password", "db_name"};

        getRequestParams(context, ip + Constant.login, crabHttpCallback, key, username, password,zt);
    }




    /**
     * 扫码获取产品详情
     *
     * @param crabHttpCallback`
     */
    public void get_order_info( Context context, String order_code, CrabHttpCallback<String> crabHttpCallback) {
        String[] key = new String[]{"order_code", "sign"};
        getRequestParams(context, HuaYangApp.ip + Constant.get_order_info, crabHttpCallback, key, order_code, "app");
    }

    /**
     * 确认装车,取消确认
     *
     * @param crabHttpCallback`
     */
    public void detail_button( Context context, String line_id,String sign,String user_id, CrabHttpCallback<String> crabHttpCallback) {
        String[] key = new String[]{"line_id", "sign", "user_id"};
        getRequestParams(context, HuaYangApp.ip + Constant.detail_button, crabHttpCallback, key, line_id,sign,user_id);
    }


    /**
     * 拣货确认
     *
     * @param crabHttpCallback`
     */
    public void button_line_done( Context context, String order_id,String user_id, CrabHttpCallback<String> crabHttpCallback) {
        String[] key = new String[]{"order_id", "user_id"};
        getRequestParams(context, HuaYangApp.ip + Constant.button_line_done, crabHttpCallback, key, order_id,user_id);
    }


//    /**
//     * 图片上传
//     *
//     * @param context
//     * @param staffId
//     * @param token
//     * @param type
//     * @param crabHttpCallback
//     */
//    public void uploadFile(Context context, String staffId, String token, String type, File file, final CrabHttpCallback crabHttpCallback) {
//
//        OkGo.post(HttpURLInterface.UPLOADALL + "?staffId=" + staffId + "&token=" + token)
//                .tag(this)
//                .params("staffId", staffId)
//                .params("token", token)
//                .params("type", type)
//                .params(file.getName(), file)
//                .execute(new BaseCallback(context) {
//                    @Override
//                    public void onSuccessInfo(String json) {
//                        crabHttpCallback.onSuccess(json);
//                    }
//
//                    @Override
//                    public void onError(Call call, Response response, Exception e) {
//                        super.onError(call, response, e);
//                        crabHttpCallback.onFailed(e.toString());
//                    }
//
//                    @Override
//                    public void onSuccessError(String json) {
//                        super.onSuccessError(json);
//                        crabHttpCallback.onSuccessError(json);
//                    }
//                });
//    }


    private static void getRequestParams(final Context context, String url, final CrabHttpCallback<String> callback,
                                         String[] key, String... values) {

        PostRequest request = OkGo.post(url);
        request.tag(context);

        if (key != null) {
            for (int i = 0; i < key.length; i++) {
                request.params(key[i], values[i]);
            }
        }

        request.execute(new BaseCallback(context) {
            @Override
            public void onSuccessInfo(String json) {
                callback.onSuccess(json);
            }

            @Override
            public void onError(Call call, Response response, Exception e) {
                super.onError(call, response, e);
                if (call.isCanceled()) {
                    Log.e("request", "用户取消了这次请求");
                } else {
                    callback.onError("系统开了会小差,请重试...");
                }
            }

            @Override
            public void onSuccessError(String json) {
                super.onSuccessError(json);
                if (!CommonUtils.isNull(JsonUtil.getFieldValue(json, "message"))) {
                    callback.onError(JsonUtil.getFieldValue(json, "message"));
                } else {
                    if (!CommonUtils.isNull(JsonUtil.getFieldValue(json, "msg"))) {
                        callback.onError(JsonUtil.getFieldValue(json, "msg"));
                    } else {
                        callback.onError("系统开了会小差,请重试...");
                    }
                }
            }
        });
    }
    private static void getRequestParamsBySession(final Context context, String url, final CrabHttpCallback<String> callback,
                                         String[] key, String... values) {

        PostRequest request = OkGo.post(url);

        try {
            JSONObject params = new JSONObject();
            if (key != null) {
                for (int i = 0; i < key.length; i++) {
                    params.put(key[i], values[i]);
                }
            }
            request.tag(context)
                    .upJson(params)
                    .execute(new BaseCallback(context) {
                        @Override
                        public void onSuccessInfo(String json) {
                            callback.onSuccess(json);
                        }

                        @Override
                        public void onError(Call call, Response response, Exception e) {
                            super.onError(call, response, e);
                            if (call.isCanceled()) {
                                Log.e("request", "用户取消了这次请求");
                            } else {
                                callback.onError("系统开了会小差,请重试...");
                            }
                        }

                        @Override
                        public void onSuccessError(String json) {
                            super.onSuccessError(json);
                            if (JsonUtil.isContains(json, "error")) {
                                callback.onError(JsonUtil.getFieldValue(json, "error"));
                            } else {
                                if (JsonUtil.isContains(json, "msg")){
                                    callback.onError(JsonUtil.getFieldValue(json, "msg"));
                                }else if (JsonUtil.isContains(json,"result")){
                                    callback.onError(JsonUtil.getFieldValue(JsonUtil.getFieldValue(json,"result"), "msg"));
                                }else{
                                    callback.onError("系统开了会小差,请重试...");
                                }

                            }
                        }
                    });
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private static void getRequestParamsBySessionByJson(final Context context, String url, final CrabHttpCallback<String> callback,
                                                  String[] key, String... values) {

        PostRequest request = OkGo.post(url);

        try {
            JSONObject params = new JSONObject();
            if (key != null) {
                for (int i = 0; i < key.length; i++) {
                    params.put(key[i], values[i]);
                }
            }
            String data = params.toString();
            String data1=   data.replace(":\"[",":[");
            String data2=  data1.replace("]\"","]");
            String data3=  data2.replaceAll("\\\\","");
            request.tag(context)
                    .upJson(data3)
                    .execute(new BaseCallback(context) {
                        @Override
                        public void onSuccessInfo(String json) {
                            callback.onSuccess(json);
                        }

                        @Override
                        public void onError(Call call, Response response, Exception e) {
                            super.onError(call, response, e);
                            if (call.isCanceled()) {
                                Log.e("request", "用户取消了这次请求");
                            } else {
                                callback.onError("系统开了会小差,请重试...");
                            }
                        }

                        @Override
                        public void onSuccessError(String json) {
                            super.onSuccessError(json);
                            if (null != JsonUtil.getFieldValue(json, "error")) {
                                callback.onError(JsonUtil.getFieldValue(json, "error"));
                            } else {
                                if (null!=JsonUtil.getFieldValue(json, "msg")){
                                    callback.onError(JsonUtil.getFieldValue(json, "msg"));
                                }else if (null!=JsonUtil.getFieldValue(json,"result")){
                                    callback.onError(JsonUtil.getFieldValue(JsonUtil.getFieldValue(json,"result"), "msg"));
                                }else{
                                    callback.onError("系统开了会小差,请重试...");
                                }

                            }
                        }
                    });
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }


    private static void getRequestParamsGET(final Context context, String url, final CrabHttpCallback<String> callback,
                                            String[] key, String... values) {

        GetRequest request = OkGo.get(url);
        request.tag(context);

        if (key != null) {
            for (int i = 0; i < key.length; i++) {
                request.params(key[i], values[i]);
            }
        }

        request.execute(new BaseCallback(context) {
            @Override
            public void onSuccessInfo(String json) {
                callback.onSuccess(json);
            }

            @Override
            public void onError(Call call, Response response, Exception e) {
                super.onError(call, response, e);
                if (call.isCanceled()) {
                    Log.e("request", "用户取消了这次请求");
                } else {
                    callback.onError("系统开了会小差,请重试...");
                }
            }

            @Override
            public void onSuccessError(String json) {
                super.onSuccessError(json);
                if (null != JsonUtil.getFieldValue(json, "message")) {
                    callback.onError(JsonUtil.getFieldValue(json, "message"));
                } else {
                    callback.onError("系统开了会小差,请重试...");
                }
            }
        });
    }

    private static void getRequestParamsGET(Context context, String url, final BaseCallback callback,
                                            String[] key, String... values) {

        GetRequest request = OkGo.get(url);
        request.tag(context);

        if (key != null) {
            for (int i = 0; i < key.length; i++) {
                request.params(key[i], values[i]);
            }
        }

        request.execute(callback);
    }

    private static void getRequestParamsPOST(Context context, String url, final BaseCallback callback,
                                             String[] key, String... values) {

        PostRequest request = OkGo.post(url);
        request.tag(context);

        if (key != null) {
            for (int i = 0; i < key.length; i++) {
                request.params(key[i], values[i]);
            }
        }

        request.execute(callback);
    }
}
