package com.roke.huayangproject.base;

import android.app.DatePickerDialog;
import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputMethodManager;
import android.widget.DatePicker;
import android.widget.EditText;
import android.widget.TextView;

import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AppCompatActivity;

import com.lzy.okgo.OkGo;
import com.roke.huayangproject.R;
import com.roke.huayangproject.utils.CommonUtils;
import com.roke.huayangproject.utils.DialogUtils;

import java.util.Calendar;

import butterknife.ButterKnife;
import me.jessyan.autosize.internal.CustomAdapt;


/**
 * baseActionBar Activity
 *
 */
public abstract class BaseActivity extends AppCompatActivity implements  BaseViewInterface, CustomAdapt {
    private boolean hasMenu = true;    //是否有右边的按钮
    public Context mContext;
    protected LayoutInflater mInflater;
    protected ActionBar mActionBar;
    protected TextView dateView;        //时间显示控件
    private final String packageName4Umeng = this.getClass().getName();

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setTheme(R.style.My_App_Theme_Light);
        onBeforeSetContentLayout();
        if (getLayoutId() != 0) {
            setContentView(getLayoutId());
        }
        mContext = this;
        hasMenu = getHasMenu();
        mActionBar = getSupportActionBar();
        mInflater = getLayoutInflater();
        if (hasActionBar()) {
            initActionBar(mActionBar);
        }else{
            mActionBar.hide();
        }
        // 通过注解绑定控件
        ButterKnife.bind(this);
        Calendar ca = Calendar.getInstance();
        mYear = ca.get(Calendar.YEAR);
        mMonth = ca.get(Calendar.MONTH);
        mDay = ca.get(Calendar.DAY_OF_MONTH);
        init(savedInstanceState);
        init();
        initData();
        initView();
        Log.i(packageName4Umeng, "onCreate: 当前oncreate方法执行完毕了");
    }
    //默认有菜单
    protected boolean getHasMenu() {
        return true;
    }

    protected abstract void init();

    @Override
    protected void onPause() {
        super.onPause();
    }

    @Override
    protected void onResume() {
        super.onResume();
    }

    protected void onBeforeSetContentLayout() {
    }

    protected boolean hasActionBar() {
        return getSupportActionBar() != null;
    }

    protected abstract int getLayoutId();

    protected View inflateView(int resId) {
        return mInflater.inflate(resId, null);
    }

    protected abstract String getActionBarTitle();

    protected boolean hasBackButton() {
        return true;
    }

    protected void init(Bundle savedInstanceState) {
    }

    protected void initActionBar(ActionBar actionBar) {
        if (actionBar == null)
            return;
        if (hasBackButton()) {
            mActionBar.setDisplayHomeAsUpEnabled(true);
            mActionBar.setHomeButtonEnabled(true);
        } else {
            mActionBar.setDisplayOptions(ActionBar.DISPLAY_SHOW_TITLE);
            mActionBar.setDisplayShowHomeEnabled(false);
            mActionBar.setDisplayUseLogoEnabled(false);
            mActionBar.setDisplayHomeAsUpEnabled(false);
            mActionBar.setHomeButtonEnabled(false);

        }
        if (!CommonUtils.isNull(getActionBarTitle())){
                actionBar.setTitle(getActionBarTitle());
        }
    }



    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case android.R.id.home:
                onBackPressed();
                break;
            case R.id.action_submit:
                submitClick();
                break;
            default:
                break;
        }
        return super.onOptionsItemSelected(item);
    }

    protected abstract void submitClick();
    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        if (hasMenu){
            getMenuInflater().inflate(R.menu.inspection_menu, menu);
        }
        return super.onCreateOptionsMenu(menu);
    }

    @Override
    public boolean isBaseOnWidth() {
        return false;
    }

    @Override
    public float getSizeInDp() {
        return 0;
    }

    public void showD(){
        DialogUtils.getInstance().createLoadingDialog(mContext, "请求中...").showDialog();
    }
    public void closeD(){
        DialogUtils.getInstance().closeDialog();
        OkGo.getInstance().cancelTag(mContext);
    }



    protected int mYear;
    protected int mMonth;
    protected int mDay;
    /**
     * 日期选择器对话框监听
     */
    protected DatePickerDialog.OnDateSetListener onDateSetListener = new DatePickerDialog.OnDateSetListener() {

        @Override
        public void onDateSet(DatePicker view, int year, int monthOfYear, int dayOfMonth) {
            mYear = year;
            mMonth = monthOfYear;
            mDay = dayOfMonth;
            String days;
            if (mMonth + 1 < 10) {
                if (mDay < 10) {
                    days = mYear + "0" +
                            (mMonth + 1) + "0" + mDay;
                } else {
                    days = mYear + "0" +
                            (mMonth + 1) + "" + mDay;
                }

            } else {
                if (mDay < 10) {
                    days = mYear + "" +
                            (mMonth + 1) + "0" + mDay;
                } else {
                    days = mYear +"" +
                            (mMonth + 1) +  "" +mDay;
                }

            }
            if (dateView!=null){
                setDataToMainInfo(days);
                dateView.setText(days);
            }

        }
    };
    protected void setDataToMainInfo(String days){

    }

    public class MyEditGoodsListener implements TextView.OnEditorActionListener {
        @Override
        public boolean onEditorAction(TextView textView, int i, KeyEvent keyEvent) {
            if (i == EditorInfo.IME_ACTION_UNSPECIFIED) {
                //隐藏软键盘
                InputMethodManager imm = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
                imm.hideSoftInputFromWindow(getWindow().getDecorView().getWindowToken(), 0);
                requestByScan(textView.getText().toString());
            }
            return false;
        }
    }

    public void requestByScan(String scan) {

    }

    public void getFocusableByEdittext(EditText editText){
        editText.setText("");
        editText .setFocusable(true);
        editText .setFocusableInTouchMode(true);
        editText .requestFocus();
    }

}
