package com.roke.huayangproject.ui.pick;

import android.content.DialogInterface;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;

import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.roke.huayangproject.HuaYangApp;
import com.roke.huayangproject.R;
import com.roke.huayangproject.adapter.LoadingAdapter;
import com.roke.huayangproject.adapter.UnLoadingAdapter;
import com.roke.huayangproject.base.BaseActivity;
import com.roke.huayangproject.bean.LoadingInfo;
import com.roke.huayangproject.http.ShipHttpClient;
import com.roke.huayangproject.utils.CommonUtils;
import com.roke.huayangproject.utils.JsonUtil;
import com.roke.huayangproject.utils.ShowMsgUtils;

import java.util.ArrayList;

import butterknife.Bind;
import butterknife.ButterKnife;
import butterknife.OnClick;

//create :  3C
//时间2021/8/4 14:32
public class PickingActivity extends BaseActivity {
    @Bind(R.id.tv_ydh)
    EditText tvYdh;
    @Bind(R.id.tv_cph)
    TextView tvCph;
    @Bind(R.id.tv_czy)
    TextView tvCzy;
    @Bind(R.id.rv_menu)
    RecyclerView rvMenu;
    @Bind(R.id.btn_submit)
    Button btnSubmit;
    private LoadingInfo info;
    private LoadingAdapter loadingAdapter;
    private String scan;

    @Override
    protected void init() {
        tvYdh.setOnEditorActionListener(new MyEditGoodsListener());
        rvMenu.setLayoutManager(new LinearLayoutManager(mContext));
        tvCzy.setText(HuaYangApp.getUser());
    }

    @Override
    protected int getLayoutId() {
        return R.layout.activity_picking;
    }

    @Override
    protected String getActionBarTitle() {
        return "拣货确认";
    }

    @Override
    protected boolean hasActionBar() {
        return false;
    }

    @Override
    protected boolean getHasMenu() {
        return false;
    }

    @Override
    protected void submitClick() {

    }

    @Override
    public void initView() {

    }

    @Override
    public void initData() {

    }

    @Override
    public void requestByScan(String scan) {
        this.scan = scan;
        showD();
        ShipHttpClient.getInstance().get_order_info(mContext, scan, new ShipHttpClient.CrabHttpCallback<String>() {
            @Override
            public void onSuccess(String json) {
                closeD();
                info = JsonUtil.parseJsonToBean(json, LoadingInfo.class);
                if (null != info && null != info.getResult() && null != info.getResult().getDetail_list() && info.getResult().getDetail_list().size() > 0) {
                    tvCph.setText(info.getResult().getCar());

                    setRecycleView();
                } else {
                    ShowMsgUtils.ShowMessage(mContext, "数据解析有误,请联系管理员!");
                }
            }

            @Override
            public void onError(String msg) {
                closeD();
                ShowMsgUtils.ShowMessage(mContext,msg);
            }
        });
    }

    private void setRecycleView() {
            loadingAdapter = new LoadingAdapter(info.getResult().getRecord_list());
            rvMenu.setAdapter(loadingAdapter);
    }

    @OnClick(R.id.btn_submit)
    public void onViewClicked() {
        if (CommonUtils.isNull(scan) || null == info || null == info.getResult() || null == info.getResult().getRecord_list() || info.getResult().getRecord_list().size() <=0){
            ShowMsgUtils.ShowMessage(mContext,"请先扫描正确的运单码,然后再点击确认.");
        }else{
            requestSubmit();
        }
    }

    private void requestSubmit() {
        showD();
        ShipHttpClient.getInstance().button_line_done(mContext, info.getResult().getOrder_id(), HuaYangApp.getUser_id(), new ShipHttpClient.CrabHttpCallback<String>() {
            @Override
            public void onSuccess(String json) {
                closeD();
                ShowMsgUtils.ShowMessage(mContext, JsonUtil.getFieldValue(json, "msg"), new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        tvYdh.setText("");
                        tvCph.setText("");
                        scan = "";
                        info = null;
                        loadingAdapter = new LoadingAdapter(new ArrayList<LoadingInfo.ResultBean.RecordListBean>());
                        rvMenu.setAdapter(loadingAdapter);
                    }
                });
            }

            @Override
            public void onError(String msg) {
                closeD();
                ShowMsgUtils.ShowMessage(mContext,msg);
            }
        });
    }
}
