package com.roke.huayangproject.ui.login;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.PixelFormat;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;

import androidx.appcompat.app.AppCompatActivity;

import com.google.android.material.textfield.TextInputEditText;
import com.google.android.material.textfield.TextInputLayout;
import com.lzy.okgo.OkGo;
import com.roke.huayangproject.MainActivity;
import com.roke.huayangproject.R;
import com.roke.huayangproject.HuaYangApp;
import com.roke.huayangproject.bean.LoginInfo;
import com.roke.huayangproject.http.ShipHttpClient;
import com.roke.huayangproject.ui.loading.LoadingActivity;
import com.roke.huayangproject.ui.pick.PickingActivity;
import com.roke.huayangproject.ui.setting.SettingActivity;
import com.roke.huayangproject.utils.CommonUtils;
import com.roke.huayangproject.utils.DialogUtils;
import com.roke.huayangproject.utils.JsonUtil;
import com.roke.huayangproject.utils.SimplexToast;

import butterknife.Bind;
import butterknife.ButterKnife;
import butterknife.OnClick;
import butterknife.OnTextChanged;
import me.jessyan.autosize.internal.CustomAdapt;

public class LoginActivity extends AppCompatActivity implements CustomAdapt {

    @Bind(R.id.iv_setting)
    ImageView ivSetting;
    @Bind(R.id.tv_input_user)
    TextInputLayout tvInputUser;
    @Bind(R.id.tv_input_pwd)
    TextInputLayout tvInputPwd;
    @Bind(R.id.et_user)
    TextInputEditText etUser;
    @Bind(R.id.et_pwd)
    TextInputEditText etPwd;
    @Bind(R.id.btn_login)
    Button btnLogin;
    private SharedPreferences pref;
    private SharedPreferences.Editor editor;

    private Context mContext;
    private String TAG = MainActivity.class.getCanonicalName();

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_login);
        mContext = this;
        ButterKnife.bind(this);
        getWindow().setFormat(PixelFormat.TRANSLUCENT);
        if (null != getSupportActionBar()) {
            getSupportActionBar().hide();
        }
        String username = (String) HuaYangApp.getData("username","");
        String password = (String) HuaYangApp.getData("password","");
        if (!CommonUtils.isNull(username) && !CommonUtils.isNull(password)) {
            etUser.setText(username);
            etPwd.setText(password);
        }
    }


    @OnClick({R.id.iv_setting, R.id.btn_login})
    public void onViewClicked(View view) {
        switch (view.getId()) {
            case R.id.iv_setting:
                //进入设置页面
                Intent intent = new Intent(mContext, SettingActivity.class);
                startActivity(intent);
//                finish();
                break;
            case R.id.btn_login:
                login();
                break;
        }
    }



    //登录逻辑
    private void login() {
        if (validate()){
            showD();
            requestLogin();
        }
    }

    private boolean validate() {
        if (CommonUtils.isNull(etUser)) {
            tvInputUser.setError("账号不能为空!");
            return false;
        }else{
            tvInputUser.setError(null);
        }
        if (CommonUtils.isNull(etPwd)) {
            tvInputPwd.setError("密码不能为空!");
            return false;
        }else{
            tvInputPwd.setError(null);
        }
        return true;
    }

    private void requestLogin() {
        pref = getSharedPreferences("IpInfo",MODE_PRIVATE);
        editor = pref.edit();
        final String ip = "http://"+pref.getString("ip",null)+"/";
        String zt = pref.getString("zt",null);
        System.out.print(ip);
        ShipHttpClient.getInstance().login(ip,zt,mContext, etUser.getText().toString().trim(), etPwd.getText().toString().trim(), new ShipHttpClient.CrabHttpCallback<String>() {
            @Override
            public void onSuccess(String json) {
                closeD();
                LoginInfo info = JsonUtil.parseJsonToBean(json,LoginInfo.class);
                if (null!=info){
                    HuaYangApp.setData("user",info.getResult().getUser_name());
                    HuaYangApp.setData("user_id",info.getResult().getUser_id());
                    HuaYangApp.setData("cookie",info.getResult().getSession_id());
                    HuaYangApp.setData("username",etUser.getText().toString().trim());
                    HuaYangApp.setData("password",etPwd.getText().toString().trim());
                    HuaYangApp.ip = ip;
                    Intent intent;
                    if (HuaYangApp.PAGE.equals("装车")){
                        intent = new Intent(mContext, LoadingActivity.class);
                    }else{
                        intent = new Intent(mContext, PickingActivity.class);
                    }
                    startActivity(intent);
                    finish();
                }else{
                    btnLogin.setEnabled(true);
                    SimplexToast.show(mContext,"解析数据失败,请联系管理员");
                }

            }

            @Override
            public void onError(String msg) {
                btnLogin.setEnabled(true);
                closeD();
                SimplexToast.show(mContext,msg);
            }
        });

    }

    //是否按照宽度进行适配,true为是,false用高度进行适配
    @Override
    public boolean isBaseOnWidth() {
        return false;
    }

    //设置当前屏幕大小,根据上边true或者false设置宽高,是用系统的用的是0
    @Override
    public float getSizeInDp() {
        return 0;
    }


    @Override
    protected void onDestroy() {
        super.onDestroy();
        ButterKnife.unbind(this);
    }

    public void showD() {
        DialogUtils.getInstance().createLoadingDialog(mContext, "发送中...").showDialog();
    }

    public void closeD() {
        DialogUtils.getInstance().closeDialog();
        OkGo.getInstance().cancelTag(mContext);
    }


}
