package com.roke.huayangproject.utils;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;

import androidx.core.content.FileProvider;


import com.roke.huayangproject.http.Constant;

import org.json.JSONObject;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;

/**
 * Created by zhaohui on 16/12/7.
 */

public class UpdateManager {
    private UpdateTipDialog tipDialog;
    private UpdateDialog updateDialog;
    private int progress;
    private Context mContext;
    private UpdateListener updateListener;
    private static final int DOWNLOAD = 1;
    private static final int DOWNLOAD_FINISH = 2;
    private static final int NOTICE = 3;
    private static final int ERROR = 4;
    private static final String savePath = Constant.CACHE_DIR;
    private static final String saveFileName = savePath + "/roke.apk";
    private String apkUrl;
    private String updateContent;
    private String forceInstall;
    private String mMemory;
    private int verCode = -1;
    private String verUrl;
    private boolean cancelUpdate = false;

    public interface UpdateListener{
        void hasUpdate(boolean hasUpdate);
    }

    private Handler mHandler = new Handler() {
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case DOWNLOAD:
                    updateDialog.tv_memory.setText(mMemory);
                    updateDialog.tv_jdValue.setText("当前进度:" + (1 + progress) + "%");
                    updateDialog.progress.setProgress(progress);
                    break;
                case DOWNLOAD_FINISH:
                    updateDialog.dismiss();
                    installApk();
                    break;
                case NOTICE:
                    CompareVersion((boolean) msg.obj);
                    break;
                case ERROR:
                    SimplexToast.show(mContext,"更新版本失败!");
                    updateDialog.dismiss();
                    break;
            }
        }
    };

    public UpdateManager(Context context, UpdateListener updateListener) {
        this.mContext = context;
        this.updateListener = updateListener;
        verUrl = Constant.baseUrl;
    }

    public void CheckUpdate(final boolean type) {
        new Thread(new Runnable() {
            @Override
            public void run() {
                HttpURLConnection httpConn = null;
                try {
                    URL realUrl = new URL(verUrl);
                    httpConn = (HttpURLConnection) realUrl
                            .openConnection();
                    httpConn.setDoInput(true);
                    httpConn.setDoOutput(true);
                    httpConn.setConnectTimeout(3000);
                    httpConn.setReadTimeout(3000);
                    httpConn.connect();
                    if (httpConn.getResponseCode() == 200) {
                        InputStream is = httpConn.getInputStream();
                        InputStreamReader isr = new InputStreamReader(is, "GBK");
                        BufferedReader br = new BufferedReader(isr);
                        String result = "";
                        String line = "";
                        while ((line = br.readLine()) != null) {
                            result += line;
                        }

                        br.close();
                        JSONObject json = new JSONObject(result);
                        apkUrl = json.getString("updateUrl");
                        verCode = json.getInt("verCode");
                        updateContent =json.getString("updateContent");//  new String(json.getString("updateContent").getBytes("GBK"),"UTF-8");
                        String[] strings = updateContent.split(" ");
                        StringBuilder builder = new StringBuilder();
                        for (int i = 0; i < strings.length; i++) {
                            builder.append(strings[i]).append("\n");
                        }
                        updateContent = builder.toString();
                        forceInstall = json.getString("forceInstall");
                        Message message = new Message();
                        message.what = NOTICE;
                        message.obj = type;
                        mHandler.sendMessage(message);
                    }else{
                        if (null!=updateListener){
                            updateListener.hasUpdate(false);
                        }
                        Log.i("dsdasadsad", "网络连接有误,请检查网络"+httpConn.getResponseCode());
                    }
                } catch (Exception e) {
                    if (null!=updateListener){
                        updateListener.hasUpdate(false);
                    }
                    Log.d("re",e.getMessage());
                } finally {
                    if (httpConn != null) {
                        httpConn.disconnect();
                    }
                }
            }
        }).start();
    }

    public void CompareVersion(boolean isShowToast) {
        int localVerCode = SystemUtil.getAppVersionCode(mContext);
        if (verCode > localVerCode) {
            if (null!=updateListener){
                updateListener.hasUpdate(true);
            }
            ShowUpdateTipDialog();
        } else if (isShowToast) {
            if (null!=updateListener){
                updateListener.hasUpdate(false);
            }

        }
    }
    public void ShowUpdateTipDialog() {
        try {
            this.tipDialog = new UpdateTipDialog(mContext);
            this.tipDialog.tvContent.setText(updateContent);
            this.tipDialog.setCancelable(false);
            this.tipDialog.setCanceledOnTouchOutside(false);
            this.tipDialog.show();
            this.tipDialog.btn_on.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    if (Environment.MEDIA_MOUNTED.equals(Environment.getExternalStorageState())) {
                        tipDialog.dismiss();
                        ShowDownloadDialog();
                    } else {
                        ShowMsgUtils.ShowMessage(mContext, "SD卡不在了");
                        return;
                    }
                }
            });
            if (forceInstall.equals("1")) {
                this.tipDialog.btn_off.setVisibility(View.VISIBLE);
                this.tipDialog.btn_off.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View view) {
                        tipDialog.dismiss();
                    }
                });
            }
            this.tipDialog.setOnKeyListener(new DialogInterface.OnKeyListener() {
                @Override
                public boolean onKey(DialogInterface dialogInterface, int i, KeyEvent keyEvent) {
                    if (i == 84) ;
                    for (boolean bool = true; ; bool = false)
                        return bool;
                }
            });

        } catch (Exception e) {
            Log.i("UpdateManager", e.getMessage());
        }
    }

    public void ShowDownloadDialog() {
        this.updateDialog = new UpdateDialog(mContext);
        this.updateDialog.setCancelable(false);
        this.updateDialog.setCanceledOnTouchOutside(false);
        this.updateDialog.setOnKeyListener(new DialogInterface.OnKeyListener() {
            @Override
            public boolean onKey(DialogInterface dialogInterface, int i, KeyEvent keyEvent) {
                if (i == 84) ;
                for (boolean bool = true; ; bool = false)
                    return bool;
            }
        });
        this.updateDialog.show();
        down();
    }

    public void down() {
        new Thread(new Runnable() {
            @Override
            public void run() {
                try {
                    HttpURLConnection httpConn = (HttpURLConnection) new URL(apkUrl).openConnection();
                    httpConn.connect();
                    if (httpConn.getResponseCode() == HttpURLConnection.HTTP_OK) {
                        int i = httpConn.getContentLength();
                        InputStream inputStream = httpConn.getInputStream();
                        File localFile = new File(savePath);
                        if (!localFile.exists()) {
                            localFile.mkdir();
                        }
                        FileOutputStream fileOutputStream = new FileOutputStream(new File(saveFileName));
                        byte[] b = new byte[1024];
                        int j = 0;
                        do {
                            int k = inputStream.read(b);
                            j += k;
                            mMemory = FileSizeUtil.convertFileSize(j) + "/" + FileSizeUtil.convertFileSize(i);
                            progress = (int) (((float) j / i) * 100);
                            mHandler.sendEmptyMessage(DOWNLOAD);
                            if (k <= 0) {
                                mHandler.sendEmptyMessage(DOWNLOAD_FINISH);
                                break;
                            }
                            fileOutputStream.write(b, 0, k);
                        } while (!cancelUpdate);
                        fileOutputStream.close();
                        inputStream.close();
                    }else{
                        Log.e("responseCode", "run: "+ httpConn.getResponseCode());
                        mHandler.sendEmptyMessage(ERROR);
                    }
                } catch (Exception e) {
                    Log.e("UpdateManager", e.getMessage());
                    mHandler.sendEmptyMessage(ERROR);
                }
            }
        }).start();
    }

    private void installApk() {

        try {
            File localFile = new File(saveFileName);
            if (localFile.exists()) {
                Intent intent = new Intent(Intent.ACTION_VIEW);
                if(Build.VERSION.SDK_INT>= Build.VERSION_CODES.N){
                    Uri contentUri = FileProvider.getUriForFile(mContext.getApplicationContext(),"com.example.messystem.fileprovider",localFile);

                    intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);

                    intent.addFlags(Intent.FLAG_GRANT_READ_URI_PERMISSION);

                    intent.setDataAndType(contentUri,"application/vnd.android.package-archive");

                }else{

                    intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);

                intent.setDataAndType(Uri.fromFile(localFile),"application/vnd.android.package-archive");

            }
                mContext.startActivity(intent);
                android.os.Process.killProcess(android.os.Process.myPid());
            }
        } catch (Exception e) {
            Log.e("版本升级", "installApk: "+e.toString());
            e.printStackTrace();
        }

    }


}
