package com.roke.huayangproject.utils;

import android.Manifest;
import android.app.Activity;
import android.os.Build;


import com.roke.huayangproject.http.Constant;

import pub.devrel.easypermissions.EasyPermissions;

/**
 * Created by zhaohui on 16/12/15.
 * android 6.0 动态获取权限工具
 */

public class PermissionUtil {
    private static final String TAG = PermissionUtil.class.getSimpleName();
    public static final int CODE_RECORD_AUDIO = 0;
    public static final int CODE_GET_ACCOUNTS = 1;
    public static final int CODE_READ_PHONE_STATE = 2;
    public static final int CODE_ACCESS_FINE_LOCATION = 3;
    public static final int CODE_ACCESS_COARSE_LOCATION = 4;
    public static final int CODE_READ_EXTERNAL_STORAGE = 5;
    public static final int CODE_WRITE_EXTERNAL_STORAGE = 6;
    public static final int CODE_MULTI_PERMISSION = 100;

    public static final int CODE_CALL_PHONE = 8;
    public static final int CODE_CAMERA = 7;

    // 允许程序录制音频
    public static final String PERMISSION_RECORD_AUDIO = Manifest.permission.RECORD_AUDIO;
    // 允许程序访问Accounts Service帐户列表
    public static final String PERMISSION_GET_ACCOUNTS = Manifest.permission.GET_ACCOUNTS;
    // 允许程序访问手机状态信息
    public static final String PERMISSION_READ_PHONE_STATE = Manifest.permission.READ_PHONE_STATE;
    public static final String PERMISSION_CALL_PHONE = Manifest.permission.CALL_PHONE;
    // 允许程序使用照相设备
    public static final String PERMISSION_CAMERA = Manifest.permission.CAMERA;
    // 允许程序访问位置信息
    public static final String PERMISSION_ACCESS_FINE_LOCATION = Manifest.permission.ACCESS_FINE_LOCATION;
//    允许程序访问CellID或WiFi热点来获取位置信息
    public static final String PERMISSION_ACCESS_COARSE_LOCATION = Manifest.permission.ACCESS_COARSE_LOCATION;
    // 允许程序读扩展存储卡
    public static final String PERMISSION_READ_EXTERNAL_STORAGE = Manifest.permission.READ_EXTERNAL_STORAGE;
    // 允许程序写扩展存储卡
    public static final String PERMISSION_WRITE_EXTERNAL_STORAGE = Manifest.permission.WRITE_EXTERNAL_STORAGE;

    public static final String[] requestPermissions = {
            PERMISSION_RECORD_AUDIO,
            PERMISSION_GET_ACCOUNTS,
            PERMISSION_READ_PHONE_STATE,
            PERMISSION_CALL_PHONE,
            PERMISSION_ACCESS_FINE_LOCATION,
            PERMISSION_ACCESS_COARSE_LOCATION,
            PERMISSION_READ_EXTERNAL_STORAGE,
            PERMISSION_WRITE_EXTERNAL_STORAGE,
            PERMISSION_CAMERA
    };

//    PERMISSION_CALL_PHONE,
//    PERMISSION_ACCESS_FINE_LOCATION,
//    PERMISSION_ACCESS_COARSE_LOCATION,

    private   static  void requestPermissions(Activity activity, int requestCode, String rationale, String params1, PermissionsCallBackListener listener, String...params2){
        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.O) {
            if (!EasyPermissions.hasPermissions(activity, params1)) {
                EasyPermissions.requestPermissions(activity, rationale, requestCode, params1);
            } else {
                if (null!=listener){
                    listener.hasPermissions();
                }
            }
        } else {
            if (EasyPermissions.hasPermissions(activity, params2)) {
                if (null!=listener){
                    listener.hasPermissions();
                }
            } else {
                EasyPermissions.requestPermissions(activity, rationale, requestCode,params2);
            }
        }
    }


    public  static  boolean hasPermissions(Activity activity, String params1, String...params2){
        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.O) {
            return EasyPermissions.hasPermissions(activity, params1);

        } else {
            return EasyPermissions.hasPermissions(activity, params2);

        }
    }
    /**
     * 请求定位
     */
    public  static  void  requestLocationPermissions(Activity activity, PermissionsCallBackListener listener){
        PermissionUtil.requestPermissions(activity, 1,"当前APP请求使用定位权限", Constant.PERMISSION_ACCESS_COARSE_LOCATION,listener, Permission.LOCATION);
    }
    /**
     * 请求相机
     */
    public  static  void  requestScanPermissions(Activity activity, PermissionsCallBackListener listener){
        PermissionUtil.requestPermissions(activity, 0,"当前APP请求使用相机权限", Constant.PERMISSION_CAMERA, listener,Permission.CAMERA);
    }
    /**
     * 请求联系人
     */
    public  static  void requestContactsPermissions(Activity activity, PermissionsCallBackListener listener) {
        PermissionUtil.requestPermissions(activity, 2, "当前APP申请联系人权限.", Constant.PERMISSION_GET_ACCOUNTS,listener,Permission.CONTACTS);
    }

    /**
     * 申请读写sd卡
     */
    public  static  void requestStoragePermissions(Activity activity, PermissionsCallBackListener listener) {
        PermissionUtil.requestPermissions(activity, 3, "当前APP申请读写SD卡权限.", Constant.PERMISSION_WRITE_EXTERNAL_STORAGE,listener,Permission.STORAGE);
    }

    /**
     * 请求安装app权限
     */
    public  static  void requestInstallPermissions(Activity activity, PermissionsCallBackListener listener) {
        PermissionUtil.requestPermissions(activity, 4, "当前APP请求安装app权限.", Constant.REQUEST_INSTALL_PACKAGES,listener,Constant.REQUEST_INSTALL_PACKAGES);
    }




    public interface  PermissionsCallBackListener{
        void hasPermissions();
    }
}
