package com.roke.huayangproject.utils;

import android.text.TextUtils;
import android.util.Log;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.reflect.TypeToken;

import org.json.JSONException;
import org.json.JSONObject;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/**
 * 封装的是使用Gson解析json的方法
 * @author Administrator
 *
 */
public class JsonUtil {

	/**
	 * 把一个map变成json字符串
	 * @param map
	 * @return
	 */
	public static String parseMapToJson(Map<?, ?> map) {
		try {
			Gson gson = new Gson();
			return gson.toJson(map);
		} catch (Exception e) {
		}
		return null;
	}

	/**
	 * 把一个list<map<string,object>>变成json字符串
	 * @return
	 */
	public static String parseListToJson(List<Map<String,Object>> list) {
		try {
			JsonArray jsonArray = new JsonArray();

			Gson gson = new Gson();
			for (Map<String, Object> stringObjectMap : list) {
				jsonArray.add(gson.toJson(stringObjectMap));
			}
			return jsonArray.toString();
		} catch (Exception e) {
		}
		return null;
	}

	/**
	 * 把一个json字符串变成对象
	 * @param json
	 * @param cls
	 * @return
	 */
	public static <T> T parseJsonToBean(String json, Class<T> cls) {
		Gson gson = new Gson();
		T t = null;
		try {
			t = gson.fromJson(json, cls);
		} catch (Exception e) {
			Log.e("error",e.toString());
		}
		return t;
	}

	/**
	 * 把json字符串变成map
	 * @param json
	 * @return
	 */
	public static HashMap<String, Object> parseJsonToMap(String json) {
		Gson gson = new Gson();
		Type type = new TypeToken<HashMap<String, Object>>() {
		}.getType();
		HashMap<String, Object> map = null;
		try {
			map = gson.fromJson(json, type);
		} catch (Exception e) {
		}
		return map;
	}

	/**
	 * 把json字符串变成集合
	 * params: new TypeToken<List<yourbean>>(){}.getType(),
	 * 
	 * @param json
	 * @param type  new TypeToken<List<yourbean>>(){}.getType()
	 * @return
	 */
	public static List<?> parseJsonToList(String json, Type type) {
		Gson gson = new Gson();
		List<?> list = gson.fromJson(json, type);
		return list;
	}

	/**
	 * 
	 * 获取json串中某个字段的值，注意，只能获取同一层级的value
	 * 
	 * @param json
	 * @param key
	 * @return
	 */
	public static String getFieldValue(String json, String key) {
		JSONObject jsonObject = null;
		String value = "";
		try {
			jsonObject = new JSONObject(json);
		if (TextUtils.isEmpty(json))
			return "";
		if (!isContains(json,key))
			return "";
			value = jsonObject.getString(key);
		} catch (JSONException e) {
			e.printStackTrace();
		}
		return value;
	}


	/**
	 *
	 * 获取json串中某个字段的值，注意，只能获取同一层级的value
	 *
	 * @param json
	 * @param key
	 * @return
	 */
	public static boolean isContains(String json, String key) {
		if (TextUtils.isEmpty(json))
			return false;
		if (json.contains(key)){
			try {
			JSONObject jsonObject = null;
			String value = null;

				jsonObject = new JSONObject(json);
				Iterator it = jsonObject.keys();
				while(it.hasNext()){
					String nextKey = (String) it.next();
					if (nextKey.equals(key)){
						return true;
					}
				}
			} catch (JSONException e) {
				return false;
			}

		}else{
			return false;
		}
		return false;
	}



}
