package com.roke.huayangproject.ui.transport;

import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import android.content.DialogInterface;
import android.os.Bundle;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;

import com.roke.huayangproject.HuaYangApp;
import com.roke.huayangproject.R;
import com.roke.huayangproject.adapter.LoadingAdapter;
import com.roke.huayangproject.adapter.TreansportDetailAdapter;
import com.roke.huayangproject.base.BaseActivity;
import com.roke.huayangproject.bean.LoadingInfo;
import com.roke.huayangproject.bean.TransportBean;
import com.roke.huayangproject.http.ShipHttpClient;
import com.roke.huayangproject.utils.CommonUtils;
import com.roke.huayangproject.utils.JsonUtil;
import com.roke.huayangproject.utils.ShowMsgUtils;

import java.util.ArrayList;
import java.util.List;

import butterknife.Bind;
import butterknife.OnClick;

public class TransportDetailActivity extends BaseActivity {

    @Bind(R.id.tv_cph)
    TextView tvCph;
    @Bind(R.id.tv_czy)
    TextView tvCzy;
    @Bind(R.id.rv_menu)
    RecyclerView rvMenu;
    @Bind(R.id.btn_submit)
    Button btnSubmit;
    private String car,user,scan;
    private TreansportDetailAdapter treansportDetailAdapter;
    private List<TransportBean.ResultBean.OrderDetailsBean> bean;
    private String carId;

    @Override
    protected void init() {
        car = getIntent().getStringExtra("car");
        carId = getIntent().getStringExtra("carid");
        tvCph.setText(car);
        bean = (List<TransportBean.ResultBean.OrderDetailsBean>) getIntent().getSerializableExtra("data");
        rvMenu.setLayoutManager(new LinearLayoutManager(mContext));
        tvCzy.setText(HuaYangApp.getUser());
        if (null!= bean && bean.size()>0){
            setRecycleView();
        }
    }

    @Override
    protected int getLayoutId() {
        return R.layout.activity_transport_detail;
    }

    @Override
    protected String getActionBarTitle() {
        return "出厂详情";
    }

    @Override
    protected boolean getHasMenu() {
        return false;
    }

    @Override
    protected void submitClick() {

    }

    private void setRecycleView() {
        treansportDetailAdapter = new TreansportDetailAdapter(bean);
        rvMenu.setAdapter(treansportDetailAdapter);
    }
    @OnClick(R.id.btn_submit)
    public void onViewClicked() {
//        if (null == bean || bean.size() <=0){
//            ShowMsgUtils.ShowMessage(mContext,"请先扫描正确的运单码,然后再点击确认.");
//        }else{
            requestSubmit();
//        }
    }

    private void requestSubmit() {
        showD();
        ShipHttpClient.getInstance().set_out(mContext, carId, new ShipHttpClient.CrabHttpCallback<String>() {
            @Override
            public void onSuccess(String json) {
                closeD();
                String result = "";
                if (CommonUtils.isNull(JsonUtil.getFieldValue(json,"msg"))){
                    result = JsonUtil.getFieldValue(JsonUtil.getFieldValue(json,"result"),"msg");
                }else{
                    result = JsonUtil.getFieldValue(json,"msg");
                }
                ShowMsgUtils.ShowMessage(mContext,result, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        setResult(0);
                        finish();
                    }
                });
            }


            @Override
            public void onError(String msg) {
                closeD();
                ShowMsgUtils.ShowMessage(mContext,msg);
            }
        });
    }
    @Override
    public void initView() {

    }

    @Override
    public void initData() {

    }
}