package com.roke.huayangproject.ui;

import android.Manifest;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.provider.Settings;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.app.ActivityCompat;


import com.roke.huayangproject.R;
import com.roke.huayangproject.http.Constant;
import com.roke.huayangproject.ui.login.LoginActivity;
import com.roke.huayangproject.utils.Permission;
import com.roke.huayangproject.utils.PermissionUtil;
import com.roke.huayangproject.utils.ShowMsgUtils;
import com.roke.huayangproject.utils.SimplexToast;
import com.roke.huayangproject.utils.UpdateManager;

import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

import me.jessyan.autosize.AutoSize;
import me.jessyan.autosize.AutoSizeCompat;
import me.jessyan.autosize.internal.CustomAdapt;
import pub.devrel.easypermissions.AppSettingsDialog;
import pub.devrel.easypermissions.EasyPermissions;

/**
 *  欢迎页面
 * Created by 赵新龙 on 2019/6/10.
 */

public class SplashActivity extends AppCompatActivity implements EasyPermissions.PermissionCallbacks {
    private int GET_UNKNOWN_APP_SOURCES = 5;
    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_splash);
        initWindow();

        requestSavePermissions();
        //测试的时候需要添加,如果是真实的情况还需要根据具体情况设定
    }



    private void requestSavePermissions() {
        PermissionUtil.requestStoragePermissions(this, new PermissionUtil.PermissionsCallBackListener() {
            @Override
            public void hasPermissions() {
                requestScanPermissions();
            }
        });
    }
    private void requestScanPermissions() {
        PermissionUtil.requestScanPermissions(this, new PermissionUtil.PermissionsCallBackListener() {
            @Override
            public void hasPermissions() {
                isAndroidO();
            }
        });
    }

    private void isAndroidO() {
        //来判断应用是否有权限安装apk
        if (Build.VERSION.SDK_INT >= 26) {
            //来判断应用是否有权限安装apk
            PackageManager packageManager = getPackageManager();
            boolean installAllowed= packageManager.canRequestPackageInstalls();
            //有权限
            if (installAllowed) {
                //安装apk
                checkUpdate();
            } else {
                ShowMsgUtils.ShowMessageWithCancelBtn(SplashActivity.this, "手机需要开启允许安装应用权限,是否切换到设置页面?", new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                        //请求安装未知应用来源的权限
                        ActivityCompat.requestPermissions(SplashActivity.this, new String[]{Manifest.permission.REQUEST_INSTALL_PACKAGES}, 4);
                    }
                }, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                        finish();
                    }
                });

            }
        } else {
            checkUpdate();
        }
    }

    private void checkUpdate() {
        UpdateManager updateManager = new UpdateManager(SplashActivity.this, new UpdateManager.UpdateListener() {
            @Override
            public void hasUpdate(boolean hasUpdate) {
                //只有不需要更新的时候执行跳转
                if (!hasUpdate) {
                    initTimer();
                }
            }
        });
        updateManager.CheckUpdate(false);
    }
    private void initTimer() {
        Timer timer = new Timer();
        TimerTask task = new TimerTask() {
            @Override
            public void run() {

               Intent intent = new Intent( SplashActivity.this, LoginActivity.class);
               startActivity(intent);
               finish();
            }
        };
        timer.schedule(task, 500);
    }
    protected void initWindow() {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            Window window = getWindow();
            window.clearFlags(WindowManager.LayoutParams.FLAG_TRANSLUCENT_STATUS);
            window.getDecorView().setSystemUiVisibility(View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN
                    | View.SYSTEM_UI_FLAG_LAYOUT_STABLE);
            window.addFlags(WindowManager.LayoutParams.FLAG_DRAWS_SYSTEM_BAR_BACKGROUNDS);
            window.setStatusBarColor(Color.TRANSPARENT);
        }
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        switch (requestCode) {
            case Constant.REQUEST_CODE_STORAGE:
                if (!PermissionUtil.hasPermissions(this, Constant.PERMISSION_WRITE_EXTERNAL_STORAGE, Permission.STORAGE)) {
                    SimplexToast.show( SplashActivity.this,"未开启存储权限,某些功能受限");
                    return;
                }
                requestScanPermissions();
                break;
            case Constant.REQUEST_CODE_SCAN:
                if (!PermissionUtil.hasPermissions(this, Constant.PERMISSION_WRITE_EXTERNAL_STORAGE, Permission.STORAGE)) {
                    SimplexToast.show( SplashActivity.this,"未开启相机和扫码权限,某些功能受限");
                    return;
                }
                requestScanPermissions();
                break;
            case 5:
                if (Build.VERSION.SDK_INT >= 26) {
                    //来判断应用是否有权限安装apk
                    boolean installAllowed= getPackageManager().canRequestPackageInstalls();
                    //有权限
                    if (installAllowed) {
                        //安装apk
                        checkUpdate();
                    } else {
                        ShowMsgUtils.ShowMessageWithCancelBtn( SplashActivity.this, "未开启允许安装应用权限,是否重新设置?", new DialogInterface.OnClickListener() {
                            @Override
                            public void onClick(DialogInterface dialog, int which) {
                                //请求安装未知应用来源的权限
                                ActivityCompat.requestPermissions( SplashActivity.this, new String[]{Manifest.permission.REQUEST_INSTALL_PACKAGES}, 4);
                                dialog.dismiss();
                            }
                        }, new DialogInterface.OnClickListener() {
                            @Override
                            public void onClick(DialogInterface dialog, int which) {
                                dialog.dismiss();
                                finish();
                            }
                        });
                    }
                }
                break;
        }
    }
    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        switch (requestCode) {
            case 4:
                if (grantResults.length > 0 && grantResults[0] == PackageManager.PERMISSION_GRANTED) {
                    checkUpdate();
                } else {
                    Intent intent = new Intent(Settings.ACTION_MANAGE_UNKNOWN_APP_SOURCES);
                    startActivityForResult(intent, GET_UNKNOWN_APP_SOURCES);
                }
                break;
            default:
                EasyPermissions.onRequestPermissionsResult(requestCode, permissions, grantResults, this);
                break;

        }

    }
    @Override //申请成功时调用权限
    public void onPermissionsGranted(int requestCode, @NonNull List<String> list) {
        switch (requestCode) {
            case 0:
                isAndroidO();
                break;
            case 3:
                requestScanPermissions();
                break;
            case 4:
                checkUpdate();
                break;
            default:
                break;
        }
    }
    @Override //申请失败时调用
    public void onPermissionsDenied(int requestCode, @NonNull List<String> list)  {
        new AppSettingsDialog
                .Builder(this)
                .setTitle("APP权限  : ")
                .setRationale("请在设置中开启对应权限,否则APP将无法使用")
             .setRequestCode(requestCode == 0?Constant.REQUEST_CODE_SCAN:Constant.REQUEST_CODE_STORAGE)
                .build().show();
    }

}
