package com.roke.huayangproject;

import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import com.lzy.okgo.OkGo;
import com.roke.huayangproject.adapter.MenuAdapter;
import com.roke.huayangproject.bean.MenuInfo;
import com.roke.huayangproject.http.ShipHttpClient;
import com.roke.huayangproject.utils.DialogUtils;
import com.roke.huayangproject.utils.JsonUtil;
import com.roke.huayangproject.utils.ShowMsgUtils;
import com.roke.huayangproject.utils.SimplexToast;

import java.util.ArrayList;
import java.util.List;

import butterknife.Bind;
import butterknife.ButterKnife;
import butterknife.OnClick;

public class MainActivity extends AppCompatActivity {

    @Bind(R.id.tv_toolbar_title)
    TextView tvToolbarTitle;
    @Bind(R.id.iv_scan)
    ImageView ivScan;
    @Bind(R.id.rv_menu)
    RecyclerView rvMenu;
    private Context mContext;
    private GridLayoutManager manager = new GridLayoutManager(this, 5);
    private List<MenuInfo.ResultBean> datas = new ArrayList<>();
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        ButterKnife.bind(this);
        if (null != getSupportActionBar()) {
            getSupportActionBar().hide();
        }
        tvToolbarTitle.setText("功能列表");
        ivScan.setVisibility(View.GONE);
        mContext = this;
        rvMenu.setLayoutManager(manager);
        DialogUtils.getInstance().createLoadingDialog(mContext, "请求中...").showDialog();
        initData();
    }

    private SharedPreferences pref;
    private SharedPreferences.Editor editor;
    private void initData() {
        pref = getSharedPreferences("IpInfo",MODE_PRIVATE);
        editor = pref.edit();
        String ip = "http://"+pref.getString("ip",null)+"/";
        ShipHttpClient.getInstance().getMenuByUser(ip, mContext, HuaYangApp.getUser(), new ShipHttpClient.CrabHttpCallback<String>() {
            @Override
            public void onSuccess(String json) {
                DialogUtils.getInstance().closeDialog();
                MenuInfo info = JsonUtil.parseJsonToBean(json,MenuInfo.class);
                if (null!=info &&null!= info.getResult() && info.getResult().size() >0){
                    for (MenuInfo.ResultBean resultBean : info.getResult()) {//遍历所有的标题
                        if (resultBean.getMenu_parentid() == 0){//如果是标题
                            resultBean.setItemType(0);
                            datas.add(resultBean);
                            for (MenuInfo.ResultBean bean : info.getResult()) {
                                if (bean.getMenu_parentid() == resultBean.getMenu_id()){
                                    bean.setItemType(1);
                                    datas.add(bean);
                                }
                            }
                        }
                    }
                    setRecycler();
                }
            }

            @Override
            public void onError(String msg) {
                DialogUtils.getInstance().closeDialog();
                SimplexToast.show(mContext,msg);
            }
        });

    }

    private void setRecycler() {
        MenuAdapter adapter = new MenuAdapter(mContext, datas, new MenuAdapter.OnItemClickListener() {
            @Override
            public void onItemClick(int position) {
                try {
                    MenuInfo.ResultBean resultBean = datas.get(position);
                    String menu_relevant_interface = resultBean.getMenu_relevant_interface();
                    //这里解析时候传入的类名,必须是包名加文件名,加类名
                    Class menu_relevant_interface1 = Class.forName(menu_relevant_interface);
                    Intent intent = new Intent(mContext,menu_relevant_interface1);
                    startActivity(intent);
                } catch (ClassNotFoundException e) {
                    SimplexToast.show(mContext,"菜单解析失败");
                }

            }
        });
        rvMenu.setAdapter(adapter);
    }

    @OnClick(R.id.iv_scan)
    public void onViewClicked() {
        SimplexToast.show(mContext,"需要扫描么?");
//        Intent intent = new Intent(mContext, ScanActivity.class);
//        startActivityForResult(intent,999);
    }


    @Override
    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode ==999 &&resultCode == 999){
            if (data!=null){
                String scanResult =data.getStringExtra("scan");
                ShowMsgUtils.ShowMessage(mContext,scanResult);
            }
        }else if (requestCode ==995 &&resultCode == 995){
            if (data!=null){
                //刷新数据
            }
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        ButterKnife.unbind(this);
        OkGo.getInstance().cancelTag(mContext);
    }
}