package com.roke.huayangproject.http;

import android.content.Context;
import android.util.Log;

import com.lzy.okgo.callback.StringCallback;
import com.lzy.okgo.request.BaseRequest;
import com.roke.huayangproject.utils.JsonUtil;

import okhttp3.Call;
import okhttp3.Response;

/**
 * Created by coder on 2017/7/16.
 * <p>
 * 封装 获取网络数据的回调基类
 */

public abstract class BaseCallback extends StringCallback {
    private Context mActivity;
    private static final String TAG = BaseCallback.class.getCanonicalName();

    public BaseCallback(Context activity) {
        this.mActivity = activity;
    }


    @Override
    public void onSuccess(String json, Call call, Response response) {
        Log.i(TAG, "onSuccess: "+ json);
        if (response.code() == 200){

            if (JsonUtil.isContains(json,"code")&&null!=JsonUtil.getFieldValue(json,"code") ) {
                if (Integer.parseInt(JsonUtil.getFieldValue(json, "code")) == ShipHttpClient.RESULT_CODE_SUCCESS) {
                    onSuccessInfo(json);
                } else {
                    onSuccessError(json);
                }
            }else if (null!= JsonUtil.getFieldValue(json,"result")&& null!= JsonUtil.getFieldValue(JsonUtil.getFieldValue(json,"result"),"code")){
                if (Integer.parseInt(JsonUtil.getFieldValue(JsonUtil.getFieldValue(json,"result"),"code")) == ShipHttpClient.RESULT_CODE_SUCCESS) {
                    onSuccessInfo(json);
                } else {
                    onSuccessError(json);
                }
            }else{
                onSuccessError(json);
            }
        }else{
            onSuccessError(json);
        }

    }

    public void onSuccessError(String json) {

    }


    @Override
    public void onBefore(BaseRequest request) {
        super.onBefore(request);

    }

    @Override
    public void onCacheSuccess(String s, Call call) {
        super.onCacheSuccess(s, call);
    }

    @Override
    public void onError(Call call, Response response, Exception e) {
        super.onError(call, response, e);
        Log.e("连接网络返回的错误信息===>", ":::::" + e.toString());
//        ShowMsgUtils.ShowToast(mActivity.getApplicationContext(), ShipHttpClient.ERROR_MSG);
    }

    @Override
    public void onCacheError(Call call, Exception e) {
        super.onCacheError(call, e);
    }

    @Override
    public void onAfter(String s, Exception e) {
        super.onAfter(s, e);
    }

    @Override
    public void upProgress(long currentSize, long totalSize, float progress, long networkSpeed) {
        super.upProgress(currentSize, totalSize, progress, networkSpeed);
    }

    @Override
    public void downloadProgress(long currentSize, long totalSize, float progress, long networkSpeed) {
        super.downloadProgress(currentSize, totalSize, progress, networkSpeed);
    }

    @Override
    public void parseError(Call call, Exception e) {
        super.parseError(call, e);
    }

    public abstract void onSuccessInfo(String json);
}
