package com.roke.huayangproject.utils;

import android.app.Dialog;
import android.content.Context;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.roke.huayangproject.R;


/**
 */

public class DialogUtils {

    private static TextView tipTextView;
    private static Dialog loadingDialog;
    private static DialogUtils dialogUtils;

    public static DialogUtils getInstance(){
        if (null == dialogUtils){
            dialogUtils = new DialogUtils();
        }
        return dialogUtils;
    }


    public DialogUtils createLoadingDialog(Context context, String msg) {
        LayoutInflater inflater = LayoutInflater.from(context);
        View v = inflater.inflate(R.layout.dialog_loading, null);// 得到加载view
        LinearLayout layout = (LinearLayout) v
                .findViewById(R.id.dialog_loading_view);// 加载布局
        // 提示文字
        tipTextView = (TextView) v.findViewById(R.id.tipTextView);
        tipTextView.setText(msg);// 设置加载信息

        // 创建自定义样式dialog
        loadingDialog = new Dialog(context, R.style.MyDialogStyle);
//        loadingDialog.setCancelable(false); // 是否可以按“返回键”消失
        loadingDialog.setCanceledOnTouchOutside(false); // 点击加载框以外的区域是否消失
        loadingDialog.setContentView(layout, new LinearLayout.LayoutParams(
                LinearLayout.LayoutParams.MATCH_PARENT,
                LinearLayout.LayoutParams.MATCH_PARENT));// 设置布局
        /**
         *将显示Dialog的方法封装在这里面
         */
        Window window = loadingDialog.getWindow();
        WindowManager.LayoutParams lp = window.getAttributes();
        lp.width = WindowManager.LayoutParams.MATCH_PARENT;
        lp.height = WindowManager.LayoutParams.WRAP_CONTENT;
        window.setGravity(Gravity.CENTER);
        window.setAttributes(lp);
        window.setWindowAnimations(R.style.PopWindowAnimStyle);

        return this;
    }

    /**
     * 关闭dialog
     *
     */
    public void closeDialog() {
        if (loadingDialog != null && loadingDialog.isShowing()) {
            loadingDialog.dismiss();
        }
        onDestroyDialog();
    }
    /**
     * 打开dialog
     *
     */
    public void showDialog() {
        if (loadingDialog != null && !loadingDialog.isShowing()) {
            loadingDialog.show();
        }
    }

    public  DialogUtils setTitle(String msg){
        if (null !=tipTextView){
            tipTextView.setText(msg);
        }
        return this;
    }
    public void onDestroyDialog(){
        if (null!=tipTextView){
            tipTextView = null;
        }
        if (null!=loadingDialog){
            loadingDialog = null;
        }

    }


}