package com.roke.huayangproject.ui.unloading;

import android.content.DialogInterface;
import android.graphics.Color;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.roke.huayangproject.HuaYangApp;
import com.roke.huayangproject.R;
import com.roke.huayangproject.adapter.LoadingAdapter;
import com.roke.huayangproject.adapter.UnLoadingAdapter;
import com.roke.huayangproject.base.BaseActivity;
import com.roke.huayangproject.bean.LoadingInfo;
import com.roke.huayangproject.http.ShipHttpClient;
import com.roke.huayangproject.utils.CommonUtils;
import com.roke.huayangproject.utils.JsonUtil;
import com.roke.huayangproject.utils.ShowMsgUtils;
import com.roke.huayangproject.utils.SimplexToast;

import java.util.ArrayList;
import java.util.List;

import butterknife.Bind;
import butterknife.OnClick;

//create :  3C
//时间2021/8/2 16:07
public class UnLoadingActivity extends BaseActivity {

    @Bind(R.id.tv_ydh)
    TextView tvYdh;
    @Bind(R.id.tv_cph)
    TextView tvCph;
    @Bind(R.id.tv_czy)
    TextView tvCzy;
    @Bind(R.id.tv_xq)
    TextView tvXq;
    @Bind(R.id.btn_xq)
    LinearLayout btnXq;
    @Bind(R.id.tv_ss)
    TextView tvSs;
    @Bind(R.id.btn_ss)
    LinearLayout btnSs;
    @Bind(R.id.rv_menu)
    RecyclerView rvMenu;
    private LoadingInfo info;
    private int currentPosition = 0;//当前显示的页面
    private UnLoadingAdapter unLoadingAdapter;
    private LoadingAdapter loadingAdapter;
    private String code,codeid;
    private String scan;
    private List<LoadingInfo.ResultBean.DetailListBean> unLoadingDatas;

    @Override
    protected void init() {
        code = getIntent().getStringExtra("code");
        codeid = getIntent().getStringExtra("codeid");
        if (!CommonUtils.isNull(code)){
            tvYdh.setText(code);
            requestByScan(code);
        }
//        tvYdh.setOnEditorActionListener(new MyEditGoodsListener());
        tvCzy.setText(HuaYangApp.getUser());
        rvMenu.setLayoutManager(new LinearLayoutManager(mContext));
    }

    @Override
    protected int getLayoutId() {
        return R.layout.activity_loading;
    }

    @Override
    protected String getActionBarTitle() {
        return "卸货确认";
    }


    @Override
    protected boolean getHasMenu() {
        return false;
    }
    @Override
    protected void submitClick() {

    }

    @Override
    public void initView() {

    }

    @Override
    public void initData() {

    }

    @Override
    public void requestByScan(String scan) {
        this.scan = scan;
        showD();
        ShipHttpClient.getInstance().get_order_info(mContext, scan, new ShipHttpClient.CrabHttpCallback<String>() {
            @Override
            public void onSuccess(String json) {
                closeD();
                info = JsonUtil.parseJsonToBean(json, LoadingInfo.class);
                if (null != info && null != info.getResult() && null != info.getResult().getDetail_list() && info.getResult().getDetail_list().size() > 0) {
                    tvCph.setText(info.getResult().getCar());
                    setRecycleView();
                } else {
                    ShowMsgUtils.ShowMessage(mContext, "数据解析有误,请联系管理员!");
                }
            }

            @Override
            public void onError(String msg) {
                closeD();
                ShowMsgUtils.ShowMessage(mContext, msg);
            }
        });
    }

    private void setRecycleView() {
        if (currentPosition == 0){
            unLoadingDatas = new ArrayList<>();
            for (LoadingInfo.ResultBean.DetailListBean detailListBean : info.getResult().getDetail_list()) {
                if (detailListBean.getState().equals("wait_confirm")){
                    unLoadingDatas.add(detailListBean);
                }
            }
            unLoadingAdapter = new UnLoadingAdapter(unLoadingDatas);
            rvMenu.setAdapter(unLoadingAdapter);
            unLoadingAdapter.setOnItemChildClickListener(new BaseQuickAdapter.OnItemChildClickListener() {
                @Override
                public boolean onItemChildClick(BaseQuickAdapter adapter, View view, int position) {
                    if (view.getId() == R.id.btn_submit){
                        submitState(unLoadingDatas.get(position).getLine_id(),"confirm");
                    }
                    return true;
                }
            });
        }else{
            loadingAdapter = new LoadingAdapter(info.getResult().getRecord_list());
            rvMenu.setAdapter(loadingAdapter);
            loadingAdapter.setOnItemClickListener(new BaseQuickAdapter.OnItemClickListener() {
                @Override
                public void onItemClick(BaseQuickAdapter adapter, View view, final int position) {
                    ShowMsgUtils.ShowMessageWithCancelBtn(mContext, "确认要清除确认状态么?", new DialogInterface.OnClickListener() {
                        @Override
                        public void onClick(DialogInterface dialog, int which) {
                            submitState(info.getResult().getRecord_list().get(position).getLine_id(),"confirm_cancel");
                        }
                    });

                }
            });
        }
    }

    private void submitState(String sale_line_id, final String confirm) {
        showD();
        ShipHttpClient.getInstance().detail_button(mContext, sale_line_id, confirm, HuaYangApp.getUser_id(), new ShipHttpClient.CrabHttpCallback<String>() {
            @Override
            public void onSuccess(String json) {
                closeD();
                SimplexToast.show(mContext,JsonUtil.getFieldValue(json,"msg"));
                requestByScan(scan);//请求数据
            }

            @Override
            public void onError(String msg) {
                closeD();
                ShowMsgUtils.ShowMessage(mContext,msg);
            }
        });
    }


    @OnClick({R.id.btn_xq, R.id.btn_ss})
    public void onViewClicked(View view) {
        switch (view.getId()) {
            case R.id.btn_xq:
                if (null != info && null != info.getResult() ) {
                    if (currentPosition != 0) {
                        setPosition(0);
                        setRecycleView();
                    }
                }else{
                    ShowMsgUtils.ShowMessage(mContext,"请先扫描运单号获取数据");
                }
                break;
            case R.id.btn_ss:
                if (null != info && null != info.getResult()) {
                    if (currentPosition != 1) {
                        setPosition(1);
                        setRecycleView();
                    }
                }else{
                    ShowMsgUtils.ShowMessage(mContext,"请先扫描运单号获取数据");
                }

                break;
        }
    }

    private void setPosition(int position) {
        currentPosition = position;
        tvXq.setTextColor(position == 0? Color.WHITE:Color.BLACK);
        tvSs.setTextColor(position == 1? Color.WHITE:Color.BLACK);
        tvXq.setBackgroundResource(position == 0 ? R.drawable.btn_left_background : R.drawable.btn_left_background_normal);
        tvSs.setBackgroundResource(position == 1 ? R.drawable.btn_right_background : R.drawable.btn_right_background_normal);
    }
}
