package com.roke.huayangproject.base;

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;

import com.lzy.okgo.OkGo;
import com.lzy.okgo.cache.CacheEntity;
import com.lzy.okgo.cache.CacheMode;
import com.lzy.okgo.cookie.store.MemoryCookieStore;
import com.lzy.okgo.model.HttpHeaders;

import java.util.Map;
import java.util.logging.Level;

import me.jessyan.autosize.AutoSizeConfig;
import me.jessyan.autosize.unit.Subunits;

/**
 * Created by 赵新龙 on 2019/6/14.
 */

public class BaseApplication extends Application {
    private static String PREF_NAME = "shared_data";
    static Context _context;
    public static String ip = "";
    @Override
    public void onCreate() {
        super.onCreate();
        _context = getApplicationContext();
        initOkgo();
        initAutoSize();
    }

    private void initAutoSize() {
        AutoSizeConfig.getInstance()
                .setBaseOnWidth(true)
                .getUnitsManager()
                .setSupportDP(false)
                .setSupportSP(false)
                .setSupportSubunits(Subunits.NONE);
    }

    public static synchronized BaseApplication context() {
        return (BaseApplication) _context;
    }

    public void initOkgo() {
//        HttpHeaders headers =new HttpHeaders();
//        headers.put("Content-Type","application/json");
//        HttpParams params = new HttpParams();
//        params.put("jtoken", Util.getUserToken()+"");     //全局请求参数
        //必须调用初始化
        OkGo.init(this);
        //以下设置的所有参数是全局参数,同样的参数可以在请求的时候再设置一遍,那么对于该请求来讲,请求中的参数会覆盖全局参数
        //好处是全局参数统一,特定请求可以特别定制参数
        try {
            //以下都不是必须的，根据需要自行选择,一般来说只需要 debug,缓存相关,cookie相关的 就可以了
            OkGo.getInstance()
                    // 打开该调试开关,打印级别INFO,并不是异常,是为了显眼,不需要就不要加入该行
                    // 最后的true表示是否打印okgo的内部异常，一般打开方便调试错误
                    .debug("OkGo", Level.INFO

                            , true)
                    //如果使用默认的 60秒,以下三行也不需要传
//                    .addCommonHeaders(headers)
//                    .addCommonParams(params)
                    .setCookieStore(new MemoryCookieStore())  //cookie使用内存缓存（app退出后，cookie消失
                    .setCertificates()
                    .setConnectTimeout(5000)  //全局的连接超时时间
                    .setReadTimeOut(OkGo.DEFAULT_MILLISECONDS)     //全局的读取超时时间
                    .setWriteTimeOut(OkGo.DEFAULT_MILLISECONDS)    //全局的写入超时时间
//                    .setCertificates(getAssets().open("2_www.myyouta.com.crt
                    .setRetryCount(0)           //设置请求失败后重复请求次数
//            ")) // 设置https证书
                    //可以全局统一设置缓存模式,默认是不使用缓存,可以不传,具体其他模式看 github 介绍 https://github.com/jeasonlzy/
                    .setCacheMode(CacheMode.NO_CACHE)
                    //可以全局统一设置缓存时间,默认永不过期,具体使用方法看 github 介绍
                    .setCacheTime(CacheEntity.CACHE_NEVER_EXPIRE);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 保存数据
     * @param key  键
     * @param object 值
     */
    public static void setData(String key, Object object) {
        SharedPreferences.Editor editor = getPreferences().edit();
        if (object instanceof String) {
            editor.putString(key, (String) object);
        } else if (object instanceof Integer) {
            editor.putInt(key, (Integer) object);
        } else if (object instanceof Boolean) {
            editor.putBoolean(key, (Boolean) object);
        } else if (object instanceof Float) {
            editor.putFloat(key, (Float) object);
        } else if (object instanceof Long) {
            editor.putLong(key, (Long) object);
        } else {
            editor.putString(key, object.toString());
        }

        editor.apply();
    }

    /**
     * 获取保存的数据
     * @param key   对应的键
     * @param defaultObject  默认值
     * @return 返回值
     */
    public static Object getData(String key, Object defaultObject) {
        SharedPreferences sp = getPreferences();
        if (defaultObject instanceof String) {
            return sp.getString(key, (String) defaultObject);
        } else if (defaultObject instanceof Integer) {
            return sp.getInt(key, (Integer) defaultObject);
        } else if (defaultObject instanceof Boolean) {
            return sp.getBoolean(key, (Boolean) defaultObject);
        } else if (defaultObject instanceof Float) {
            return sp.getFloat(key, (Float) defaultObject);
        } else if (defaultObject instanceof Long) {
            return sp.getLong(key, (Long) defaultObject);
        }
        return "";
    }


    public static String getUser(){
        String user = "";
        user = getData("user","").toString();
        return user;
    }


    public static String getUser_id(){
        String user_id = "";
        user_id = getData("user_id","").toString();
        return user_id;
    }


    /**
     * 移除某个key值已经对应的值
     *
     * @param context
     * @param key
     */
    public static void remove(Context context, String key) {
        SharedPreferences sp =getPreferences();
        SharedPreferences.Editor editor = sp.edit();
        editor.remove(key);
        editor.apply();
    }

    /**
     * 查询某个key是否已经存在
     *
     * @param context
     * @param key
     * @return
     */
    public static boolean contains(Context context, String key) {
        SharedPreferences sp = getPreferences();
        return sp.contains(key);
    }
    /**
     * 返回所有的键值对
     *
     * @param context
     * @return
     */
    public static Map<String, ?> getAll(Context context) {
        SharedPreferences sp =getPreferences();
        return sp.getAll();
    }


    public static SharedPreferences getPreferences() {
        return context().getSharedPreferences(PREF_NAME, Context.MODE_PRIVATE);
    }


}
