import Bus from '@/rokeTools/bus/bus.js'

const state = {
	calendarShow: false, //日历展示
	datetimePickerShow: false, //带时间的轮式日期显示
	tag: '', //
	minDate: 0,
	maxDate: 0,
	valueStart: '',
	valueEnd: '',
	mode: 'single',
	title: '',
}

const getters = {
	calendarShow: state => {
		return state.calendarShow;
	},
	datetimePickerShow: state => {
		return state.datetimePickerShow;
	},
	datetimeShow: state => {
		return state.datetimeShow;
	},
	tag: state => {
		return state.tag;
	},
	minDate: state => {
		return state.minDate;
	},
	maxDate: state => {
		return state.maxDate;
	},
	valueStart: state => {
		return state.valueStart;
	},
	valueEnd: state => {
		return state.valueEnd;
	},
	mode: state => {
		return state.mode;
	},
	title: state => {
		return state.title;
	}
}

const actions = {

	//检测是否是引流版并保存数据
	showCalendar({
		commit,
		dispatch,
		getters,
		state
	}, option = null) {
		commit('SHOW_CALENDAR', option)
	},
	showDatetimePicker({
		commit,
		dispatch,
		getters,
		state
	}, option = null) {
		commit('SHOW_PICKER', option)
	},
	dateSelect({
		commit,
		dispatch,
		getters,
		state
	}, option = null) {
		commit('DATE_SELECT', option)
	},
	closeCalendar({
		commit,
		dispatch,
		getters,
		state
	}) {
		commit('CLOSE_CALENDAR', false)
	}


}

const mutations = {
	// let option = {
	// 	minDate: this.props.minDate,
	// 	maxDate:this.props.maxDate,
	// 	value: this.props.value,
	// tag:this.props.tag,
	// }
	SHOW_CALENDAR(state, option) {
		state.minDate = 0;
		state.maxDate = 0;
		state.valueStart = '';
		state.valueEnd = '';
		state.title = '';
		if (option) {
			state.minDate = option.minDate;
			state.maxDate = option.maxDate;
			state.valueStart = option.valueStart;
			state.valueEnd = option.valueEnd;
			state.tag = option.tag;
			state.mode = option.mode;
			state.title = option.title;
		}
		if (!state.minDate) {
			//如果没有给最小值，就默认取今天以前一年的时间为最小值
			const d = new Date()
			const year = d.getFullYear()
			// year 此处手动减一年,筛选选择日期前置一年时间
			const year22 = d.getFullYear() - 1
			let month = d.getMonth() + 1
			month = month < 10 ? `0${month}` : month
			let date = d.getDate()
			date = date < 10 ? `0${date}` : date
			state.minDate = `${year22}-${month}-${date}` //当前时间 year 此处手动减一年
		}
		console.log(state.minDate + '-----option--------');
		state.datetimePickerShow = false;
		state.calendarShow = true;
	},
	SHOW_PICKER(state, option) {
		state.minDate = 0;
		state.maxDate = 0;
		state.valueStart = '';
		state.valueEnd = '';
		state.title = '';
		if (option) {
			state.minDate = option.minDate;
			state.maxDate = option.maxDate;
			state.valueStart = option.valueStart;
			state.valueEnd = option.valueEnd;
			state.tag = option.tag;
			state.mode = option.mode;
			state.title = option.title;
		}
		state.calendarShow = false;
		state.datetimePickerShow = true;
	},
	DATE_SELECT(state, option) {
		if (option) {
			Bus.$emit(state.tag, option);
		}
		state.calendarShow = false;
		state.datetimePickerShow = false;
	},

	CLOSE_CALENDAR(state, isShow) {
		state.calendarShow = false;
		state.datetimePickerShow = false;
	}
}



export default {
	state,
	mutations,
	actions,
	getters
}