

export default {

	/**
	 * 本地中文搜索
	 * @param {String} key - 姓名
	 * @param {Array} data - 搜索的原数据
	 * @param {String} value - 搜索的关键字
	 */
	searchWithChinese(data,key,value,callBack) {
		var value = value;
		var sel = [];
		// 设置防抖
		let timeout;
		if (data.length<1){
			uni.showToast({
				title: '当前没有可搜索的数据',
				icon: 'none'
			})
			callBack([],false);
			return;
		}
		uni.showLoading({
			title: '搜索中...'
		})
		timeout && clearTimeout(timeout);
		timeout = setTimeout((res) => {
			for (var i = 0; i < data.length; i++) {
				if (data[i][key].name.indexOf(value) != -1) {
					data[i]['parent_key'] = data[i]['key'];
					sel.push(data[i])
				}
			}
			callBack(sel,true);
		}, 1000)
		
	}
}
