import {
	CLIENT_URL_KEY,
	SESSION_ID_KEY,
	ERR_UPDATE_VERSION,
	RIS_APP_VERSION_KEY
} from '../../env.js';
import http from "@/rokeTools/request/index.js";

/**
 * App版本更新的方法
 */

export function wgtUrlupload() {
	//系统版本升级判断接口（后台获取服务器）
	// #ifdef APP-PLUS
	/** 锁定屏幕方向 */
	plus.screen.lockOrientation('portrait-primary');
	/** 检测升级 */
	// 取得版本号
	plus.runtime.getProperty(plus.runtime.appid, function(info) {
		// 版本号变量持久化存储	
		let platform = '';
		getApp().globalData.editionnum = info.version; //版本号持久化存储做其它备用
		// console.log("当前应用版本：" + info.version + "-2-33d-" + plus.runtime.version);
		// console.log("appid：" + plus.runtime.appid);
		// console.log("appid基座版本号：" + plus.runtime.version);
		platform = uni.getSystemInfoSync().platform;
		//请求版本好信息
		requestAppVersion().then((data) => {
			if (data) {
				checkVersionToLoadUpdate(platform, info.version,
					data);
			}
		})
	})
	// #endif
}

export function checkVersionToLoadUpdate(platform, server_version, data) {
	let baseUrl = uni.getStorageSync(CLIENT_URL_KEY);
	let that = this;
	const {
		ios_lowest_frame_version,
		ios_reject_updates,
		ios_wgt_version,
		android_lowest_frame_version,
		android_reject_updates,
		android_wgt_version
	} = data;
	if (platform == 'android' && android_lowest_frame_version) {
		let appVersion = uni.getSystemInfoSync().appVersion;
		//检测版本是否可以更新
		let rejectUpdate = checkRejectUpdates(appVersion, android_reject_updates);
		if (rejectUpdate) {
			//禁止更新
			return;
		}
		//Android APK 版本判断
		compareVersion(appVersion, android_lowest_frame_version).then((isNeedUpdata) => {
			if (isNeedUpdata) {
				var android_apk_upgradeUrl = baseUrl + '/roke/app_upgrade'
				//测试地址
				// android_apk_upgradeUrl =
				// 	"http://dev-ybx.oss-cn-qingdao.aliyuncs.com/private_packages/pdf/__UNI__273_440.apk";
				getAppInfo(1, android_apk_upgradeUrl, android_lowest_frame_version);
			} else {
				//Android wgt 版本判断
				compareVersion(server_version, android_wgt_version).then((isNeed) => {
					if (!isNeed) {
						return;
					}
					var android_wgt_upgradeUrl = baseUrl + '/roke/app_upgrade_wgt';
					//测试地址
					// android_wgt_upgradeUrl =
					// 	"http://dev-ybx.oss-cn-qingdao.aliyuncs.com/private_packages/pdf/__UNI__51E368D.wgt";
					console.log(android_wgt_version);
					getAppInfo(1, android_wgt_upgradeUrl, android_wgt_version)
				});
			}
		});
	} else if (platform == 'ios' && ios_lowest_frame_version) {
		let appVersion = uni.getSystemInfoSync().appVersion;
		//检测版本是否可以更新
		let rejectUpdate = checkRejectUpdates(appVersion, ios_reject_updates);
		if (rejectUpdate) {
			//禁止更新
			return;
		}
		compareVersion(appVersion, ios_lowest_frame_version).then((isNeedUpdata) => {
			if (isNeedUpdata) {
				uni.showModal({
					title: "更新提示",
					content: "融科睿思有新的框架需要更新，请前往苹果应用商店进行更新",
					showCancel: false,
					confirmText: "立即更新",
					success: (res) => {
						if (res.confirm) {
							//跳转appStore 的方法
							let appleId = 6458679161
							plus.runtime.launchApplication({
								action: `itms-apps://itunes.apple.com/cn/app/id${appleId}?mt=8`
							}, function(e) {});
						}
					}
				})
			} else {
				compareVersion(server_version, ios_wgt_version).then((isNeed) => {
					if (!isNeed) {
						return;
					}
					var ios_upgradeUrl = baseUrl + '/roke/ios_upgrade'
					getAppInfo(1, ios_upgradeUrl, ios_wgt_version);
				});
			}
		});

		// if (compareVersion(appVersion,ios_lowest_frame_version)) {

		// } else {
		// 	// ios下载升级文件的url
		// 	;
		// 	// ios_wgt_version 用于判断 ios wgt包是否需要更新，ios_lowest_frame_version 判断不需要更新后，才进行此版本号判断

		// 	if (info_version < ios_wgt_version) {

		// 	}
		// }
	}
}
/**
 * 进行版本型号的比对 以及下载更新请求
 * @param {Object} data 服务器最新 应用版本号
 * @param {Object} server_version 当前应用版本号
 * //检测当前框架版本是否是禁止更新的版本 true 禁止更新 return false； 可以更新
 */

export function checkRejectUpdates(appVersion, reject_updates) {
	if (!reject_updates) {
		return true;
	} else if (reject_updates.includes(appVersion)) {
		return true;
	}
	return false;
}

/**
 * 请求App版本号
 */

export function requestAppVersion() {
	return new Promise((reolve, reject) => {
		// #ifdef APP-PLUS
		let cacheData = uni.getStorageSync(RIS_APP_VERSION_KEY);
		if (cacheData) {
			http('login.mobile_app_version').then(data => {
				if (data.state == 'success') {
					uni.setStorage({
						key: RIS_APP_VERSION_KEY,
						data: data,
						success: function() {}
					});
				}
			}).catch((err) => {});
			return reolve(cacheData);
		} else {
			http('login.mobile_app_version').then(data => {
				if (data.state == 'success') {
					return reolve(data);
				} else {
					return reject(null);
				}
			}).catch((err) => {
				console.log(err);
				return reject(null);
			});
		}
		// #endif
		// #ifdef H5
		return reject(null);
		// #endif
	})
}


// 调用更新版本方法
export function getAppInfo(type, url, res_version) {
	const platform = uni.getSystemInfoSync().platform; //本机设备操作系统  （android || ios）
	if (platform != 'ios' && platform != 'android') false; //如果不是安卓或ios 返回false
	//这里自行请求API获取版本信息 建议传入操作系统标识，返回本机对应的操作系统最新版本信息，也就是安卓的返回就是安卓的版本信息  ios返回就是ios的版本信息 
	//请求获取最新版本
	//测试用的链接正式版要屏蔽
	// url = "http://dev-ybx.oss-cn-qingdao.aliyuncs.com/private_packages/pdf/__UNI__51E368D.wgt";
	setTimeout(() => {
		let update_info = {
			version: res_version, //线上版本
			now_url: url, //更新链接
			silent: 0, //是否是静默更新 
			force: 1, //是否是强制更新 
			net_check: 1, //非WIfi是否提示
			// note: "", //更新内容
		}
		checkUpdate(update_info, type).then(res => {
			if (res.msg) {
				// plus.nativeUI.toast(res.msg);
			}
		}); ///检查更新
		//checkUpdate 线上版本号 与 本地版本号做对比 ，如果需要更新  根据静默，强制、wifi等信息执行静默更新或跳转到升级页面
		//跳转升级页面的前提是，需要新建并在pages.json中配置升级页面
	}, 200)
}


//对比版本号
export function compareVersion(ov, nv) {
	return new Promise((reolve, reject) => {
		if (!ov || !nv || ov == "" || nv == "") {
			return reolve(false);
		}
		// console.log(ov);
		// console.log(nv);
		let b = false;
		let ova = ov.split(".", 4);
		let nva = nv.split(".", 4);
		for (let i = 0; i < ova.length && i < nva.length; i++) {
			let so = ova[i],
				no = parseInt(so),
				sn = nva[i],
				nn = parseInt(sn);
			if (nn > no || sn.length > so.length) {
				return reolve(true);
			} else if (nn < no) {
				return reolve(false);

			}
		}
		if (nva.length > ova.length && 0 == nv.indexOf(ov)) {
			return reolve(true);
		} else {
			return reolve(false);
		}
	})
}


// type  1手动点击更新  0是自动检查
export function checkUpdate(update_info, type = 0) {

	return new Promise((reolve, reject) => {
		//需要更新，判断是不是静默更新
		if (/\.wgt$/.test(update_info.now_url) && update_info.silent == 1) {
			console.log("静默更新");
			if (type == 1) {
				return reolve({
					msg: "已经是最新版本了"
				})
			}
			startSilentUpdate(update_info.now_url); //开始静默更新
			return reolve({
				msg: ""
			})
		}
		//判断当前版本是不是点击过暂不更新
		let update_ignore_version = uni.getStorageSync("update_ignore") || "0.0.0";
		console.log("强制更新", update_info.force);
		if (type === 0 && update_ignore_version == update_info.version && update_info.force ===
			0) {
			console.log("之前取消过这个版本，就不再提示了");
			return reolve({
				msg: ''
			})
		}
		let err_update_version = uni.getStorageSync(ERR_UPDATE_VERSION) || "0.0.0";
		if (err_update_version == update_info.version) {
			console.log("这个版本之前更新报过错，所以不再进行更新了，再更改其他版本号的时候再进行更新 ");
			return reolve({
				msg: ''
			})
		}
		//弹出更新 
		uni.navigateTo({
			url: "/pages/app-update/app-update?updata_info=" + JSON.stringify(
				update_info),
			animationType: "fade-in"
		})
	})
}


//开始静默更新
function startSilentUpdate(url) {
	let options = {
		method: "get"
	};
	console.log("开始静默更新", url);
	let dtask = plus.downloader.createDownload(url, options);
	dtask.addEventListener("statechanged", function(task, status) {
		if (status === null) {} else if (status == 200) {
			//在这里打印会不停的执行，请注意，正式上线切记不要在这里打印东西///////////////////////////////////////////////////
			switch (task.state) {
				case 4:
					console.log("下载结束", task.filename);
					installWgt(task.filename); // 安装  
					break;
			}
		}
	});
	dtask.start();
}

// 安装文件
function installWgt(path) {
	plus.runtime.install(path);
}