/**
 *  扫码结果处理工具
 */

import http from "@/rokeTools/request/index.js";
// #ifdef H5
import wx from "weixin-js-sdk";
import Qrcode from '@/components/qrcode.js';
import H5_ObjectURL from '@/store/package_method.js'
// #endif
import {
	wx_code_get_openid
} from '../pages/api.js'
//保存首次进入时的url ，在iOS中，获取微信Api权限用的是，第一个进入页面的url，所以在main.js中，调用
export function saveWeixinSdkUrl() {
	// #ifdef H5
	let url = window.location.href.split('#')[0];
	window.sessionStorage.setItem('scanQRCode', 'false');
	if (url) {
		window.sessionStorage.setItem('firstEntryUrl', url);
	}
	console.log('首次获取' + url);
	// #endif
}

//获取微信权限请求后台授权服务所需要的url
export function getCurrentPageUrl() {
	//安卓机型获取当前页面路径
	let url = window.location.href.split('#')[0];
	// url = encodeURIComponent(url)
	//ios机型获取当前页面路径
	let ua = navigator.userAgent.toLowerCase();
	let isWeixin = ua.indexOf('micromessenger') !== -1;
	if (isWeixin) {
		let isiOS = /(iPhone|iPad|iPod|iOS)/i.test(navigator.userAgent); //ios终端
		if (isiOS && window.sessionStorage.getItem('firstEntryUrl')) {
			url = window.sessionStorage.getItem('firstEntryUrl').split('#')[0];
		}
	}
	return url;
}

//如果页面需要用微信扫一扫，一定现在onLoad中调用一下这个方法，申请的微信Api权限
export function setWeixinConfig() {
	// #ifdef H5
	//把之前登录页存的拿出来传给后台当授权回调页
	let ua = navigator.userAgent.toLowerCase();
	let isWeixin = ua.indexOf('micromessenger') !== -1;
	if (isWeixin) {
		let url = getCurrentPageUrl();
		let msg = {
			url: url //这个参数是需要给后台回调的授权页面（就是当前访问的页面，网上很多包括我都是在这里出的问题，下面详细讲解）
		}
		http('wx.wx_information', msg).then(data => {
			if (data?.result?.timestamp) {
				let result = data.result;
				wxConfig(result.appId, result.timestamp, result.nonceStr, result.signature);
			} else if (data?.result?.message) {
				// uni.showToast({
				// 	title: data.result.message,
				// 	icon: 'none',
				// 	duration: 1300
				// })
			}
		}).catch((err) => {})
	}
	// #endif
}



// 配置config 获取微信Api权限需要的配置
export function wxConfig(appId, timestamp, nonceStr, signature) {
	wx.config({
		debug: false, // 开启调试模式,
		// appId:appId,
		appId: 'wxaa6cf2955c720fe6',
		timestamp: timestamp, // 必填，生成签名的时间戳
		nonceStr: nonceStr, // 必填，生成签名的随机串
		signature: signature, // 必填，签名
		jsApiList: ['login','scanQRCode', 'checkJsApi','openLocation','getLocation'],// 必填，需要使用的JS接口列表
		openTagList: ['wx-open-launch-weapp']
	});
	wx.ready((res) => {
		setTimeout(() => {
				window.sessionStorage.setItem('scanQRCode', 'false');
				wx.checkJsApi({
					jsApiList: ['scanQRCode','getLocation'],
					success: function(res) {
						if (res?.checkResult?.scanQRCode) {
							//允许调用扫一扫
							window.sessionStorage.setItem('scanQRCode', 'true');
						}
					},
					fail: function(response) {

					},
				})
			},
			500)
	})
	wx.error(function(res) {});
}


/*
 *  h5 扫码，在微信中用微信扫一扫
 */
// 开始扫码
export function onScanH5Weixin(callback) {
	let ua = navigator.userAgent.toLowerCase();
	let isWeixin = ua.indexOf('micromessenger') !== -1;
	let canScan = window.sessionStorage.getItem('scanQRCode');
	console.log(canScan);
	if (isWeixin && 'true' === canScan) {
		// 可以使用扫码
		wx.scanQRCode({
			needResult: 1, // 默认为0，扫描结果由微信处理，1则直接返回扫描结果，
			scanType: ['qrCode', 'barCode'], // 可以指定扫二维码还是一维码，默认二者都有
			success: function(res) {
				let result = res.resultStr; // 扫码的结果
				//回传扫描结果
				if (result) {
					if (result.includes(',') && (result.includes('UPC_E') || result.includes('UPC_A') ||
							result.includes('CODE_39') || result.includes('CODE_128') || result.includes(
								'EAN_8') || result.includes('EAN_13') ||
							result.includes('CODE_25'))) {
						//条形码返回结果前面会加上条码类型，所以结果要处理一下
						result = result.split(',')[1];
					}
					callback && callback(result);
				} else {
					uni.showToast({
						title: '没有识别到有效内容',
						icon: 'none',
						duration: 2000
					})
				}
			},
			fail: function(response) {
				uni.showToast({
					title: '识别失败',
					icon: 'none',
					duration: 2000
				})
			}
		});
	} else {
		if (isWeixin) {
			//防止没有请求权限，再请求一遍
			setWeixinConfig();
		}
		//只能使用h5扫码
		uni.chooseImage({
			count: 1,
			success: imgRes => {
				Qrcode.qrcode.decode(H5_ObjectURL.getObjectURL(imgRes.tempFiles[0]))
				Qrcode.qrcode.callback = (codeRes) => {
					if (codeRes.indexOf('error') >= 0) {
						// 二维码识别失败
						// this.qrCodeRes = '不合法二维码：' + codeRes
						uni.showToast({
							title: '扫码失败',
							icon: 'error',
							duration: 2000
						})
					} else {
						// 二维码识别成功
						let result = H5_ObjectURL.decodeStr(codeRes)
						callback && callback(result);
					}
				}
			}
		});
	}
}