import http from "@/rokeTools/request/index.js";

const state = {
	isYinLiu: true, //是否是引流版
	isCustomTabBar: false, //是否是自定义tabbar
	messageCount: 0, //消息数量
}

const getters = {
	isYinLiu: state => state.isYinLiu,
	isCustomTabBar: state => state.isCustomTabBar,
	messageCount: state => state.messageCount,
}

const actions = {
	//否是引流版并保存数据
	checkIsYinLiuAction({
		commit,
		dispatch,
		getters,
		state
	}, isYinliu = false) {
		commit('checkIsYinLiu', isYinliu);
		dispatch('setTabBarItem', isYinliu);
	},
	//改变tabBar设置
	setTabBarItem({
		state
	}, isYinliu = false) {
		if (isYinliu) {
			if (state.isCustomTabBar) {
				uni.reLaunch({
					url: '/pages/main/yl-main_home'
				})
				return;
			}
			///引流版初始化tabBar
			uni.setTabBarItem({
				index: 0,
				visible: false,
			})
			uni.setTabBarItem({
				index: 1,
				visible: true,
				success: function(res) {
					uni.switchTab({
						url: '/pages/main/yl-main_home'
					})
				}
			})
			uni.setTabBarItem({
				index: 2,
				visible: false,
			})
		} else {
			if (state.isCustomTabBar) {
				//自定义TabBar 不走下面tabBar
				uni.reLaunch({
					url: '/pages/main/main'
				})
				return;
			}
			// uni.$emit('setTabBarItem');
			//普通版初始化tabBar
			uni.setTabBarItem({
				index: 0,
				visible: true,
				success: function(res) {
					uni.switchTab({
						url: '/pages/main/main'
					})
				}
			})
			uni.setTabBarItem({
				index: 1,
				visible: false,
			})
			uni.setTabBarItem({
				index: 2,
				visible: true,
			})
		}
	},
	initCustomTabBar({
		state
	}) {
		//初始化屏幕数据的时候一块初始化了这个数据
		let isCustomTabBar = true;
		// #ifdef APP-PLUS
		isCustomTabBar = false;
		// #endif
		// #ifdef H5
		isCustomTabBar = true;
		// #endif
		state.isCustomTabBar = isCustomTabBar;
		if (isCustomTabBar) {
			//自定义tabBar需要隐藏原生tabBar
			uni.hideTabBar();
		}
	},

	// 获取消息未读数量
	getcount({
		state
	}) {
		http('roke_pub_get_unread_count').then(res => {
			if (res.error) {} else {
				if (res.result.state === 'success') {
					// that.count = res.result.result
					if (state.isCustomTabBar) {
						if (res.result.result !== 0) {
							uni.setTabBarBadge({
								index: 3,
								text: res.result.result
							})
						} else {
							uni.removeTabBarBadge({
								index: 3
							})
						}
					}
					state.messageCount = res.result.result
				} else {}
			}
		}).catch((err) => {});
	},

	//更改主题时更改tabBar的颜色
	tabBarChangeTheme({
		state
	}, theme = 'light') {
		//原生tabBar才需要在这里切换主题
		if (theme == 'dark') {
			uni.setTabBarStyle({
				color: '#fff',
				selectedColor: "#1ca0c5",
				backgroundColor: '#37393D',
			});
		} else {
			uni.setTabBarStyle({
				color: '#8f8f8f',
				selectedColor: "#1ca0c5",
				backgroundColor: '#ffffff',
			});
		}
	}

}

const mutations = {
	changeRejectUpdateIos(state, iosRejectUpdate) {
		state.iosRejectUpdate = iosRejectUpdate;
	},
	changeRejectUpdateAndroid(state, androidRejectUpdate) {
		state.androidRejectUpdate = androidRejectUpdate;
	},
	checkIsYinLiu(state, isYinliu) {
		state.isYinLiu = isYinliu;
	},
}



export default {
	state,
	mutations,
	actions,
	getters
}