import Bus from '@/rokeTools/bus/bus.js'

const state = {
	textAreaShow: false, //输入框展示
	textAreaTag: '', //
	textAreaValue: '',
	textAreaTitle: '',
}

const getters = {                    
	textAreaShow: state => {
		return state.textAreaShow;
	},
	textAreaTag: state => {
		return state.textAreaTag;
	},
	textAreaValue: state => {
		return state.textAreaValue;
	},
	textAreaTitle: state => {
		return state.textAreaTitle;
	},
}

const actions = {

	//检测是否是引流版并保存数据
	showTextArea({
		commit,
		dispatch,
		getters,
		state
	}, option = null) {
		commit('SHOWTEXTAREA', option)
	},
	confirmTextArea({
		commit,
		dispatch,
		getters,
		state
	}, option = null) {
		commit('COMFIRM', option)
	},
	closeTextArea({
		commit,
		dispatch,
		getters,
		state
	}) {
		commit('CLOSETEXTAREA', false)
	}


}

const mutations = {
	// let option = {
	// 	minDate: this.props.minDate,
	// 	maxDate:this.props.maxDate,
	// 	value: this.props.value,
	// tag:this.props.tag,
	// }
	SHOWTEXTAREA(state, option) {
		state.textAreaTag = ''; //
		state.textAreaValue = '';
		state.textAreaTitle = '';
		if (option) {
			state.textAreaTag = option.textAreaTag;
			state.textAreaValue = option.textAreaValue;
			state.textAreaTitle = option.textAreaTitle;
		}
		state.textAreaShow = true;
	},

	COMFIRM(state, option) {
		if (option) {
			Bus.$emit(state.textAreaTag, option);
		}
		state.textAreaShow = false;
	},

	CLOSETEXTAREA(state, isShow) {
		state.textAreaShow = false;
	}
}



export default {
	state,
	mutations,
	actions,
	getters
}