/* 
  使用参考，可以从 用计算属性直接导出
 import {
 	mapGetters
 } from "vuex";
 export default {
 	components: {
 	
 	},
 	data() {
 		return {
 		};
 	},
 	computed: {
 		...mapGetters(['screenHeightRpx', 'naviStatusHeightRpx']),
 		scrollViewHeight() {
 			return this.screenHeightRpx - this.naviStatusHeightRpx - 192 - 104;
 		}
 	},
 */


const state = {
	//上面试rpx为单位的数据
	statusBarHeightRpx: 0, //电池栏高度
	screenHeightRpx: 0, //屏幕总高度
	windowHeightRpx: 0, //屏幕可用高度(会自动去除系统tabbar的高度)；
	screenWidthRpx: 750, //屏幕宽度
	naviBarHeightRpx: 0, //不含电池栏的高度
	naviStatusHeightRpx: 0, //导航栏加电池栏的高度
	tabBarHeightRpx: 130, //标准自定义tabBar高度，
	customTabBarHeightRpx: 0, //自定义tabBar 高度，
	//下面是px为单位的数据
	customTabBarHeight: 60, //自定义tabBar 高度，
	windowWidth: 0,
	windowHeight: 0,
	screenHeight: 0,
	statusBarHeight: 0,
	naviBarHeight: 0,
	naviStatusHeight: 0,
	//px转rpx的系数
	rpxRatio: 0, //(750 / res.windowWidth)
	isLiuHai: false,
	isIos: false,
	isAndroid: false,
	safeAreaInsets: { //如果需要适配横屏，只能用getters方法动态计算，因为每个页面的安全距离不同
		"top": 20,
		"right": 0,
		"bottom": 10,
		"left": 0
	}
}

const getters = {
	screenHeightRpx: state => state.screenHeightRpx,
	windowHeightRpx: state => state.windowHeightRpx,
	statusBarHeightRpx: state => state.statusBarHeightRpx,
	naviBarHeightRpx: state => state.naviBarHeightRpx,
	naviStatusHeightRpx: state => state.naviStatusHeightRpx,
	screenWidthRpx: state => state.screenWidthRpx,
	tabBarHeightRpx: state => state.tabBarHeightRpx,
	windowWidth: state => state.windowWidth,
	windowHeight: state => state.windowHeight,
	screenHeight: state => state.screenHeight,
	statusBarHeight: state => state.statusBarHeight,
	naviBarHeight: state => state.naviBarHeight,
	naviStatusHeight: state => state.naviStatusHeight,
	rpxRatio: state => state.rpxRatio,
	isLiuHai: state => state.isLiuHai,
	isIos: state => state.isIos,
	isAndroid: state => state.isAndroid,
	customTabBarHeightRpx: state => state.customTabBarHeightRpx,
	//下面是px为单位的数据
	customTabBarHeight: state => state.customTabBarHeight,
	safeAreaInsets: (state) => {

		let res = uni.getSystemInfoSync();
		state.safeAreaInsets = res.safeAreaInsets;
		return res.safeAreaInsets;
	}
}

const actions = {
	// initScreenAdaptation
	initScreenAdaptation({
		commit,
		dispatch,
		getters,
		state
	}) {
		uni.getSystemInfo({
			success: (res) => {
				// 可使用窗口高度，将px转换rpx
				let x = (750 / res.windowWidth);
				let windowHeightRpx = (res.windowHeight * x);
				let screenHeightRpx = (res.screenHeight * x);
				commit('phoneHeight', screenHeightRpx);
				commit('windowHeight', windowHeightRpx);
				let statusBarHeight = res.statusBarHeight || 0;
				let statusBarHeightRpx = res.statusBarHeight * x;
				commit('changeStatusBarHeight', statusBarHeightRpx);
				let naviBarHeight = 44;
				let isLiuHai = false;
				if (res.platform == 'android') {
					naviBarHeight = 48;
				} else if (res.platform == 'ios') {
					if (statusBarHeight > 30) {
						isLiuHai = true;
					}
				}
				let naviBarHeightRpx = naviBarHeight * x;
				commit('changeNavigationBarHeightRpx', naviBarHeightRpx);
				commit('changeNaviStatusHeightRpx', naviBarHeightRpx + statusBarHeightRpx);


				//px为计量单位的数据
				let obj = {
					windowWidth: res.windowWidth,
					windowHeight: res.windowHeight,
					screenHeight: res.screenHeight,
					statusBarHeight: statusBarHeight,
					naviBarHeight: naviBarHeight,
					naviStatusHeight: naviBarHeight + statusBarHeight,
					rpxRatio: x,
					isLiuHai: isLiuHai,
					platform: res.platform,
				}
				commit('pxNumberUpdate', obj);
			}
		});
	},
	getSafeAreaInsets({
		commit,
		dispatch,
		getters,
		state
	}) {

		let safeAreaInsets = { //如果需要适配横屏，只能用getters方法动态计算，因为每个页面的安全距离不同
			"top": 20,
			"right": 0,
			"bottom": 10,
			"left": 0
		};
		let info = uni.getSystemInfoSync();
		//在App中，uni.getSystemInfoSync() 不准
		// #ifdef APP-PLUS  
		safeAreaInsets = plus.navigator.getSafeAreaInsets();
		// #endif  
		// #ifndef APP-PLUS  
		safeAreaInsets = info.safeAreaInsets;
		// #endif

		let x = (750 / info.windowWidth);
		//自定义tabBar 标准高度
		let customTabBarHeight = 65;
		let tabBarHeightRpx = 0;
		//页面刚启动时 bottom 没有值，deviceBottom 有值
		let bottom = safeAreaInsets?.deviceBottom ? safeAreaInsets.deviceBottom : safeAreaInsets.bottom;
		if (bottom > 10) {
			customTabBarHeight = customTabBarHeight + bottom - 10;
		}
		let customTabBarHeightRpx = customTabBarHeight * x;
		let obj = {
			safeAreaInsets: safeAreaInsets ? safeAreaInsets : { //如果需要适配横屏，只能用getters方法动态计算，因为每个页面的安全距离不同
				"top": 20,
				"right": 0,
				"bottom": 10,
				"left": 0
			},
			customTabBarHeight: customTabBarHeight,
			customTabBarHeightRpx: customTabBarHeightRpx,
		}
		commit('changeSafeAreaInsets', obj);
		dispatch('initCustomTabBar'); //初始化是否用自定义Tabar；
	}

}

const mutations = {
	phoneHeight(state, screenHeightRpx) {
		state.screenHeightRpx = screenHeightRpx;
	},
	windowHeight(state, windowHeightRpx) {
		state.windowHeightRpx = windowHeightRpx;
	},
	changeStatusBarHeight(state, statusBarHeight) {
		state.statusBarHeightRpx = statusBarHeight;
	},
	changeNavigationBarHeightRpx(state, naviBarHeightRpx) {
		// console.log(naviBarHeightRpx);
		state.naviBarHeightRpx = naviBarHeightRpx;
	},
	changeNaviStatusHeightRpx(state, naviStatusHeightRpx) {
		state.naviStatusHeightRpx = naviStatusHeightRpx;
	},
	pxNumberUpdate(state, obj) {
		state.windowWidth = obj.windowWidth;
		state.windowHeight = obj.windowHeight;
		state.screenHeight = obj.screenHeight;
		state.statusBarHeight = obj.statusBarHeight;
		state.naviBarHeight = obj.naviBarHeight;
		state.naviStatusHeight = obj.naviStatusHeight;
		state.rpxRatio = obj.rpxRatio;
		state.isLiuHai = obj.isLiuHai;
		state.isIos = obj.platform === 'ios' ? true : false;
		state.isAndroid = obj.platform === 'android' ? true : false;
	},
	changeSafeAreaInsets(state, obj) {
		state.safeAreaInsets = obj.safeAreaInsets;
		state.customTabBarHeight = obj.customTabBarHeight;
		state.customTabBarHeightRpx = obj.customTabBarHeightRpx;
	}
}


export default {
	state,
	mutations,
	actions,
	getters
}