const state = {
	isAux: false,
}

const getters = {
	isAux: state => state.isAux,
}

const actions = {
	// initScreenAdaptation
	showAux({
		commit,
		dispatch,
		getters,
		state
	}) {
		uni.request({
			url: uni.getStorageSync('client_url') + "/roke/get_auxiliary_is_installed",
			method: "post",
			header: {
				'Content-Type': 'application/json',
				'x-session-id': uni.getStorageSync("session_id"),
			},
			data: {},
			success: (res) => {
				console.log(res)
				commit('aux', res.data.result.state);
			},
			fail: (res) => {
				commit('aux',false);
			}
		})
	}
}

const mutations = {
	aux(state, auxshow) {
		state.isAux = auxshow;
	}
}

export default {
	state,
	mutations,
	actions,
	getters
}