import Bus from '@/rokeTools/bus/bus.js'

const state = {
	blockSelectShow: false, //输入框展示
	blockSelectTitle: '', //选择器标题
	orderList: [],
	typeList: [],

}

const getters = {
	blockSelectShow: state => {
		return state.blockSelectShow;
	},
	blockSelectTitle: state => {
		return state.blockSelectTitle;
	},
}

const actions = {

	//检测是否是引流版并保存数据
	showBlockSelectAction({
		commit,
		dispatch,
		getters,
		state
	}, option = null) {
		commit('SHOWBLOCKSELECT', option)
	},
	confirmTextArea({
		commit,
		dispatch,
		getters,
		state
	}, option = null) {
		commit('COMFIRMS', option)
	},
	closeTextArea({
		commit,
		dispatch,
		getters,
		state
	}) {
		commit('CLOSETEXTAREA', false)
	}


}

const mutations = {
	// let option = {
	// 	minDate: this.props.minDate,
	// 	maxDate:this.props.maxDate,
	// 	value: this.props.value,
	// tag:this.props.tag,
	// }
	SHOWBLOCKSELECT(state, option) {
		state.blockSelectTitle = ''; //
		state.textAreaValue = '';
		state.textAreaTitle = '';
		if (option) {
			state.blockSelectTitle = option.blockSelectTitle;
			state.textAreaValue = option.textAreaValue;
			state.textAreaTitle = option.textAreaTitle;
		}
		state.blockSelectShow = true;
	},

	COMFIRMS(state, option) {
		if (option) {
			// Bus.$emit(state.textAreaTag, option);
		}
		state.textAreaShow = false;
	},

	CLOSETEXTAREA(state, isShow) {
		state.textAreaShow = false;
	}
}



export default {
	state,
	mutations,
	actions,
	getters
}