export default {

	redirectTo(url, options) {
		if (options && JSON.stringify(options) !== '{}') {
			let query = this.addQueryString(options);
			url += url.indexOf('?') === -1 ? `?${query}` : `&${query}`
		}
		uni.redirectTo({
			url: url,
		})
	},

	navigateTo(url, options) {
		if (options && JSON.stringify(options) !== '{}') {
			let query = this.addQueryString(options);
			url += url.indexOf('?') === -1 ? `?${query}` : `&${query}`
		}
		uni.navigateTo({
			url: url,
		})
	},

	addQueryString(params) {
		let paramsData = ''
		Object.keys(params).forEach(key => {
			paramsData += key + '=' + encodeURIComponent(params[key]) + '&'
		})
		return paramsData.substring(0, paramsData.length - 1)
	},
	// 判断是否是某个页面
	checkCurrentPages(path, perPage) {
		var pages = getCurrentPages(); //获取所有页面的数组对象
		if (perPage) {
			//判断前一个页面是否是某个页面
			if (pages.length > 1) {
				var currPage = pages[pages.length - 2]; //前一个页面
				let url = currPage.route;
				if (url.indexOf(path) != -1) {
					return true;
				}
			}
		} else {
			//判断当前页面是否是某个页面
			var currPage = pages[pages.length - 1]; //当前页面
			let url = currPage.route;
			if (url.indexOf(path) != -1) {
				return true;
			}
		}
		return false;
	}
}