/**
 * 根据文件名后缀判断文件类型
 * @param {String} fileName 文件名
 * @return {Boolean} false 无后缀
 * @return {String} image 图片文件类型
 * @return {String} txt txt文件类型
 * @return {String} excel 表格文件类型
 * @return {String} word word文件类型
 * @return {String} pdf pdf文件类型
 * @return {String} ppt ppt文件类型
 * @return {String} video 视频文件类型
 * @return {String} radio 音频文件类型
 * @return {String} other 其他文件类型
 * */
import http from "@/rokeTools/request/index.js";
const KJDocument = uni.requireNativePlugin('KJ-Document');
const KJManageExternalStorage = uni.requireNativePlugin('KJ-ManageExternalStorage');
import APP_H5_base64 from '@/components/App_H5_base64.js';
import rokeNavigate from '@/rokeTools/navigateManager';

import {
	SHARE_FILES,
	CLIENT_URL_KEY,
	SESSION_ID_KEY
} from '../../env.js';

export function determineFileType(fileName) {
	// 后缀获取
	var suffix = ''
	// 获取类型结果
	var result = ''
	try {
		var flieArr = fileName.split('.')
		suffix = flieArr[flieArr.length - 1]
	} catch (err) {
		suffix = ''
	}
	// fileName无后缀返回 false
	if (!suffix) {
		result = false
		return result
	}
	// 图片格式
	var imglist = ['png', 'jpg', 'jpeg', 'bmp', 'gif', 'webp', 'jmx', 'JPG']
	// 进行图片匹配
	result = imglist.some(function(item) {
		return item == suffix
	})
	if (result) {
		result = 'image'
		return result
	}
	// 匹配txt
	var txtlist = ['txt']
	result = txtlist.some(function(item) {
		return item == suffix
	})
	if (result) {
		result = 'txt'
		return result
	}
	// 匹配 excel
	var excelist = ['xls', 'xlsx']
	result = excelist.some(function(item) {
		return item == suffix
	})
	if (result) {
		result = 'excel'
		return result
	}
	// 匹配 word
	var wordlist = ['doc', 'docx']
	result = wordlist.some(function(item) {
		return item == suffix
	})
	if (result) {
		result = 'word'
		return result
	}
	// 匹配 pdf
	var pdflist = ['pdf']
	result = pdflist.some(function(item) {
		return item == suffix
	})
	if (result) {
		result = 'pdf'
		return result
	}
	// 匹配 ppt
	var pptlist = ['ppt']
	result = pptlist.some(function(item) {
		return item == suffix
	})
	if (result) {
		result = 'ppt'
		return result
	}
	// 匹配 视频
	var videolist = ['mp4', 'm2v', 'mkv']
	result = videolist.some(function(item) {
		return item == suffix
	})
	if (result) {
		result = 'video'
		return result
	}
	// 匹配 音频
	var radiolist = ['mp3', 'wav', 'wmv']
	result = radiolist.some(function(item) {
		return item == suffix
	})
	if (result) {
		result = 'radio'
		return result
	}
	// 其他 文件类型
	result = 'other'
	return result
}

/** 
 * 调用uniapp的文件预览方法
 * @param {String} url 文件地址
 */
export function uniFilePreview(url) {
	let that = this
	uni.showLoading({
		title: '加载中...'
	});
	// 下载文件
	uni.downloadFile({
		url: url,
		success: (res) => {
			// 使用手机第三方应用打开文件
			uni.openDocument({
				filePath: res.tempFilePath,
				showMenu: false,
				success: (result) => {
					uni.hideLoading();
				},
				fail: (error) => {
					uni.hideLoading();
					uni.showToast({
						title: '暂不支持此类型',
						duration: 2000,
						icon: "none",
					});
				}
			})
		},
		fail: (err) => {
			uni.hideLoading();
		}
	});
}

/** 
 * 添加照片水印
 * @param {Object} file 图片信息
 * 
 */
export function watermarkTool(file, _this) {

	return new Promise((resolve, reject) => {
		let path = file[0].url;
		if (path.indexOf('file:///') !== -1) {
			//如果是相册图片，直接结束
			resolve(file);
		} else {
			const systemInfo = uni.getSystemInfoSync();
			let pixelRatio = systemInfo.devicePixelRatio > 1 && systemInfo.platform == 'ios' ? systemInfo
				.devicePixelRatio : 1; //设备像素比

			uni.getImageInfo({
				src: path,
				success: function(image) {
					if (systemInfo.platform == 'ios') {
						pixelRatio = imageSizeCompressRatio(image.width);
					}
					let _wid = image.width / pixelRatio;
					let _hig = image.height / pixelRatio;
					console.log(image.width);
					console.log(_hig);
					_this.canvasSiz.width = _wid;
					_this.canvasSiz.height = _hig;
					//担心尺寸重置后还没生效，故做延迟
					setTimeout(() => {
						let ctx = uni.createCanvasContext('canvas-clipper', _this)
						ctx.drawImage(
							path,
							0,
							0,
							_wid,
							_hig
						)
						ctx.setFillStyle('white') // 水印文字颜色
						ctx.setFontSize(30) // 水印文字大小
						// ctx.fillText(uni.getStorageSync('company_name'), 30, image.height -
						// 	100) // 水印内容，水印左边距，水印上边距
						ctx.fillText(uni.getStorageSync('company_name'), 30,
							50) // 水印内容，水印左边距，水印上边距
						// 时间水印
						var now = new Date()
						var time = now.getFullYear() + '-' + now.getMonth() + '-' + now
							.getDate() +
							' ' + now.getHours() + ':' + now.getMinutes() + ':' + now
							.getMinutes()
						ctx.setFontSize(30)
						// ctx.fillText(time, 30, image.height - 50)
						ctx.fillText(time, 30, 100)
						ctx.draw(false, () => {
							console.log(_wid);
							console.log(_hig);
							uni.canvasToTempFilePath({
									destWidth: _wid,
									destHeight: _hig,
									canvasId: 'canvas-clipper',
									fileType: 'png',
									success: function(res) {
										let file = [{
											"size": 0,
											"type": "image",
											"url": res
												.tempFilePath,
											"thumb": res
												.tempFilePath
										}]
										uni.getFileInfo({
											filePath: res
												.tempFilePath,
											success: imgInfo => {
												file[0]
													.size =
													imgInfo
													.size
												resolve(
													file
												)
											}
										})
									}
								},
								_this
							)
						})
					}, 500)
				}
			})
		}
	})
}


export function imageSizeCompressRatio(_wid) {
	if (_wid > 4000) {
		return 4;
	} else if (_wid > 3000) {
		return 3;
	} else if (_wid > 2000) {
		return 2;
	} else if (_wid > 1200) {
		return 1.5;
	}
	return 1;
}
/**
 * iOS 设置从其他App打开我们App 的样式
 * */
export function KJDocumentSetIos() {
	// #ifdef APP-PLUS
	if (uni.getSystemInfoSync().platform == 'ios') {
		var dic = {
			"isShowUI": false //默认是true。false 不展示UI
		}
		KJDocument.setting_ios(dic, (res) => {});
	}

	// #endif
}
/**
 * 从App之外分享到App的文件监听方法
 * 从别的app打开我们的App 文件监听方法
 * @param {String} fileName 文件名
 * */
export function KJDocumentListener(that) {



	/**
	 * ios：注意 “用其他应用打开” 在app完全关闭的情况下，从“文件”app里分享的文件，打开app，获取的文件地址没有访问权限，
	 * app在后台的话，就没有问题，可以提示用户再选择一次。在微信，QQ等，打开就没有问题
	 * ios分享没有问题
	 *
	 * andorid：配置了 一个文件 和 多个文件 分享
	 * */
	// #ifdef APP-PLUS
	KJDocument.openURL((res) => {
		//ios：res返回[{"path":""}], 因为系统api原因，“用其他应用打开”只返回一个文件，分享可以返回多个文件
		//android: res返回[{"path":""}] 可以返回多个文件
		let files = [];
		if (uni.getSystemInfoSync().platform == 'ios') {
			/**
			 * 返回的json说明：[{"path":"/var/mobile/Containers/Data/Application/B12C17BB-0A20-4205-BAE1-4CC6110381C0/Documents/Pandora/apps/__UNI__89F76C9/doc/KJ-DocumentV2/IMG_3202.PNG",
			 * "type":"file","textViewContent":""}]
			 * type - file-文件 url-网址 text-文本 other-其它(这个属于不支持该类型，只会返回一个字符串) error-错误
			 * path - type==file则是文件的绝对路径，其它则是文本
			 * textViewContent - 分享扩展的发布UI填写的文本
			 * */
			for (var i = 0; i < res.length; i++) {
				var dic = res[i];
				if (dic.type == "file") {
					// this.path = dic.path
					let file = {
						"path": '',
						'name': '',
						'uri': '',
					}
					file.path = dic.path;
					files.push(file);
				} else {

				}
			}
		} else {
			/**
			 * 返回的json说明： [{"uri":"content://com.miui.gallery.open/raw//storage/emulated/0/Android/data/com.miui.gallery/cache/SecurityShare/1688092107366.jpeg",
			 * "type":"image/*","path":"/storage/emulated/0/Android/data/uni.UNI89F76C9/cache/1688092107610/1688092107366.jpeg"}] 
			 * type - 文件的MIME Type，资源的媒体类型，type如果为空，则是文本
			 * path - type如果为空，则是文本，否则是文件的绝对路径
			 * */
			for (var i = 0; i < res.length; i++) {
				var dic = res[i];
				//注意：“用其他应用打开”，有时候文件名不是分享过来的文件名，比如微信，有时候分享过来的不是文件名，而是一段中文加数字的文字
				if (dic.type) {
					let file = {
						"path": '',
						'name': '',
						'uri': '',
					}
					file.path = dic.path;
					files.push(file);
				}
			}
			isExternalStorageManager();
		}


		//程序有可能刚打开，还没启动好，等待一下
		//判断是否是登录页面，如果是登录页面，提示用户登录
		setTimeout(() => {
			var pages = getCurrentPages(); //获取所有页面的数组对象
			var currPage = pages[pages.length - 1]; //当前页面
			if (!currPage.route) {
				//说明程序还没有启动好
				console.log("files:" + '555555');
				uni.setStorageSync(SHARE_FILES, JSON.stringify(files))
				return;
			}
			let url = currPage.route;
			if (url.indexOf('/login') != -1) {
				//说明是登录页面
				uni.showModal({
					title: "提示",
					content: "请登录后再做附件相关的操作"
				})
				//没有登录的文件先登录，登录后再做附件的操作
				uni.setStorageSync(SHARE_FILES, JSON.stringify(files))
			} else {
				//说明程序已经登录，直接进行附件的上传操作
				fileFormat(files);
			}
		}, 500)

	});
	// #endif
}

//登录成功后检测本地存的有没有附件相关，有的话做上传操作
export function KJDocumentLoginEndFileAction(files) {
	// #ifdef APP-PLUS
	let filesStr = uni.getStorageSync(SHARE_FILES);
	if (filesStr) {
		let files = JSON.parse(filesStr);
		if (files) {
			fileFormat(files);
		}
	}
	// #endif
}
//附件整理并上传
export function fileFormat(files) {
	//清除附件的存储
	uni.setStorageSync(SHARE_FILES, '')
	let count = 0;

	for (var i = 0; i < files.length; i++) {
		let file = files[i];
		var fileName = ''
		try {
			var flieArr = file.path.split('/')
			fileName = flieArr[flieArr.length - 1]
		} catch (err) {

		}

		let baseUrl = uni.getStorageSync(CLIENT_URL_KEY);
		let xSessionId = uni.getStorageSync(SESSION_ID_KEY);
		file['name'] = fileName;
		file['uri'] = file.path;
		delete file.path;
		count++;
		if (files.length === count) {
			uni.showLoading({
				title: '上传中.',
				mask: true,
			})
			uni.uploadFile({
				url: baseUrl + '/roke/mes/api/upload_file',
				files: files,
				header: {
					'content-type': 'multipart/form-data'
				},
				timeout: 120000,
				success: (res) => {
					uni.hideLoading();
					uni.showToast({
						title: '上传成功',
						icon: 'success',
						duration: 1000
					})
					var pages = getCurrentPages(); //获取所有页面的数组对象
					var currPage = pages[pages.length - 1]; //当前页面
					if (!currPage.route) {
						//说明程序还没有启动好
						return;
					}
					let url = currPage.route;
					if (url.indexOf('/wdgl_list') != -1) {
						//当前就在文档管理页面，所以直接刷新此页面
						uni.redirectTo({
							url: '/pages/mobile_order/wdgl/wdgl_list',
						})
					} else {
						uni.navigateTo({
							url: '/pages/mobile_order/wdgl/wdgl_list',
						})
					}
				},
				fail: (err) => {
					uni.hideLoading();
					uni.showModal({
						content: err.errMsg,
						showCancel: false
					});
				},
			});
		}



		// APP_H5_base64(file.path, (data) => {
		// 	// 图片转base64格式
		// 	let base = data.substring(data.indexOf(',') + 1)
		// 	file['name'] = fileName;
		// 	file['datas'] = base;
		// 	count++;
		// 	// 请求附件接口,获取id
		// 	console.log("files2:" + JSON.stringify(files));
		// 	console.log(count);
		// 	if (files.length === count) {
		// 		// console.log(files);
		// 		//图片全部转成base64后再走上传方法
		// 		upDataImage(files).then((file_ids) => {

		// 		}).catch((err) => {

		// 		})
		// 	}

		// })
	}
}




// 上传图片获取返回id
export function upDataImage(files) {
	return new Promise(function(resolve, reject) {
		http('file.save_file', {
			'file_base64_list': files,
			"model_index": this.modelIndex, //这个参数是什么还不知道
			"params": {
				"context": {
					"allowed_company_ids": [uni.getStorageSync('company_id')]
				}
			}
		}).then((data) => {
			if (data.error) {
				uni.showModal({
					content: data.error.message,
					showCancel: false
				})
				reject();
			} else {
				if (data.result.state == 'success') {
					// 获取到上传图片返回的id,传入参数
					// data.result.file_ids[0];
					uni.hideLoading()
					resolve(data.result.file_ids);

				} else {
					uni.showModal({
						content: data.result.msgs,
						showCancel: false
					})
					reject();

				}
			}
		}).catch((err) => {
			reject();
		})
	});
}

//Android 
export function isExternalStorageManager() {
	//是否有“所有文件访问”权限
	KJManageExternalStorage.isExternalStorageManager((res) => {
		console.log("isExternalStorageManager: " + JSON.stringify(res));

		/**
		 * 返回json说明：{"result":false}
		 * result - 是否有这个权限，andorid11以下会返回true，因为这个权限andorid11才有的
		 * */
		/**
		 * 1.andorid11以下，执行这个方法，不会跳转到权限授权页面，因为这个权限andorid11才有的
		 * 2.如果之前勾选过再取消，应用会重启
		 * */
		if (!res.result) {
			//请求“所有文件访问”权限
			KJManageExternalStorage.requestPermission((res) => {
				console.log("requestPermission: " + JSON.stringify(res));
			})
		}
	})
}