export default class amountManager {
	//判断字符是否为空的方法
	static isEmpty(obj) {
		if (typeof obj == "undefined" || obj == null || obj == "" || obj == 'null') {
			return true;
		} else {
			return false;
		}
	}

	// 取出金额取出除金额以外的内容
	static getAmountToDecimal(text) {
		if (typeof(text) == 'string') {
			var value = text.replace(/[^0-9.]/ig, "");
			let result = this.checkAmount_TwoDecimal(value, true);
			if (result && result > 0) {
				return this.toDecimal(value);
			}
			return 0;
		} else {
			var f = Math.round(text * 100) / 100;
			return f;
		}
	}
	static getAmount(text) {
		if (typeof(text) == 'string') {
			var value = text.replace(/[^0-9.]/ig, "");
			let result = this.checkAmount_TwoDecimal(value, true);
			if (result && result > 0) {
				return value;
			}
			return 0;
		} else {
			var f = Math.round(text * 100) / 100;
			return f;
		}
	}

	// 检测金额是否合法,两位小数
	static checkAmount_TwoDecimal(text, multdigit, isInput) {
		var reg = /(^[1-9]([0-9]+)?(\.[0-9]{1,2})?$)|(^(0){1}$)|(^[0-9]\.[0-9]([0-9])?$)/;

		if (multdigit) {
			reg = /(^[1-9]([0-9]+)?(\.[0-9]*)?$)|(^(0){1}$)|(^(0){1}\.[0-9]+$)/;
		}

		if (isInput) {
			reg = /(^[1-9]([0-9]+)?(\.[0-9]{0,2})?$)|(^(0){1}$)|(^[0-9]\.[0-9]([0-9])?$)/;
		}

		if (reg.test(text)) {
			return true;
		} else {
			return false;
		}
	}

	// 计算汇率转换成人民币
	static ComputationExchangeRate(_number, tax) {
		if (this.isEmpty(tax) || tax == 0) {
			return 0;
		}
		let amount = _number / tax;
		amount = AmountManger.toDecimal(amount);
		return AmountManger.keepTwoDecimal(amount);
	}

	// 小数点精度 适用于保留多位小数的情况
	static toDecimalGreaterThanTwo(x) {
		if (typeof(x) == 'string') {
			let f = parseFloat(x);
			if (isNaN(f)) {
				return 0;
			}
			if (this.isEmpty(f)) {
				return 0;
			}
			return f;
		} else {
			if (isNaN(x)) {
				return 0;
			}
			if (this.isEmpty(x)) {
				return 0;
			}
			return x;
		}
	}


	// 小数点精度 只用于保留两位小数的情况
	static toDecimal(x) {
		if (typeof(x) == 'string') {
			let f = parseFloat(x);
			if (isNaN(f)) {
				return 0;
			}
			if (this.isEmpty(f)) {
				return 0;
			}
			f = Math.round(f * 100) / 100;
			return f;
		} else {
			if (isNaN(x)) {
				return 0;
			}
			let f = Math.round(x * 100) / 100;
			return f;
		}
	}


	//输入框金额转字符串可以有小数点
	static amountInputToString(x) {
		if (this.isEmpty(x)) {
			return '';
		} else if (!x) {
			return '444';
		} else if (typeof(x) == 'string') {
			if ('NaN' === x) {
				return '';
			}
			return x;
		} else {
			let f = Math.round(x * 100) / 100;
			return f.toString();
		}
	}

	//输入框金额转字符串可以有小数点
	static rateInputToString(x) {
		if (!x) {
			return '';
		} else if (typeof(x) == 'string') {
			return x;
		} else {
			if (isNaN(x)) {
				return '';
			}
			var f = x.toString();
			return f;
		}
	}


	// 小数点精度 输入框复制用
	static toDecimalString(x, zeroShow) {

		if (typeof(x) == 'string') {
			if (x === '0' && zeroShow) {
				return x;
			}
			let f = parseFloat(x);
			if (isNaN(f)) {
				return '';
			}
			if (this.isEmpty(f)) {
				return '';
			}
			f = Math.round(f * 100) / 100;
			if (f == 0 && !zeroShow) {
				return '';
			}
			return f.toString();
		} else {
			if (isNaN(x)) {
				return '';
			}
			let f = Math.round(x * 100) / 100;
			if (f == 0 && !zeroShow) {
				return '';
			}
			return f.toString();
		}
	}


	// 保留小数
	static keepTwoDecimal(x, y) {
		if (typeof(x) == 'string') {
			let f = parseFloat(x);
			if (isNaN(f)) {
				return 0;
			}
			f = Math.round(f * 100) / 100;
			if (y) {
				f = f.toFixed(y);
			} else {
				f = f.toFixed(2);
			}
			return f;
		} else {
			if (isNaN(x)) {
				return 0;
			}
			let f = Math.round(x * 100) / 100;
			if (y) {
				f = f.toFixed(y);
			} else {
				f = f.toFixed(2);
			}
			return f;
		}

	}

	static toThousands(number, decimals, decPoint, thousandsSep) {
		// number = 100000000;
		/*
		 * 参数说明：
		 * number：要格式化的数字
		 * decimals：保留几位小数
		 * dec_point：小数点符号
		 * thousands_sep：千分位符号
		 * */
		number = (number + '').replace(/[^0-9+-Ee.]/g, '')
		var n = !isFinite(+number) ? 0 : +number
		var prec = !isFinite(+decimals) ? 2 : Math.abs(decimals)
		var sep = (typeof thousandsSep === 'undefined') ? ',' : thousandsSep
		var dec = (typeof decPoint === 'undefined') ? '.' : decPoint
		var s = ''
		var toFixedFix = function(n, prec) {
			var k = Math.pow(10, prec)
			return '' + parseFloat(Math['round'](parseFloat((n * k).toFixed(prec * 2))).toFixed(prec * 2)) / k
		}
		s = (prec ? toFixedFix(n, prec) : '' + Math.round(n)).split('.')
		var re = /(-?\d+)(\d{3})/
		while (re.test(s[0])) {
			s[0] = s[0].replace(re, '$1' + sep + '$2')
		}

		if ((s[1] || '').length < prec) {
			s[1] = s[1] || ''
			s[1] += new Array(prec - s[1].length + 1).join('0')
		}
		return s.join(dec)
	}

	static stringToFloat(x) {
		if (x) {
			if (typeof(x) == 'string') {
				if (x == '') {
					return 0;
				}

				if (x.length > 0) {
					let y = AmountManger.toDecimal(x);
					return parseFloat(y);
				}
			} else {
				return AmountManger.toDecimal(x);
			}
		} else {
			return 0;
		}
	}

	//decimal为 保留多少位小数,不填默认保留2位
	static inputAmountFormat(text, decimal) { //22,111,22.11   判断是否是金额
		let newText = (text != '' && text.substr(0, 1) == '.') ? '' : text;
		newText = newText.replace(/^0+[0-9]+/g, "0"); //不能以0开头输入
		newText = newText.replace(/[^\d.]/g, ""); //清除"数字"和"."以外的字符
		newText = newText.replace(/\.{2,}/g, "."); //只保留第一个, 清除多余的
		newText = newText.replace(".", "$#$").replace(/\./g, "").replace("$#$", ".");
		if (decimal && typeof decimal === 'number' && !isNaN(decimal) && decimal >= 1) {
			if (this.isEmpty(newText)) {
				return '';
			}
			let strArr = newText.split('.');
			if (strArr.length > 1) {
				let resultStr = strArr[strArr.length - 1];
				if (resultStr.length > decimal) {
					let result = resultStr.substr(0, decimal);
					newText = strArr[0] + '.' + result;

				}
			}

		} else {
			newText = newText.replace(/^(\-)*(\d+)\.(\d\d).*$/, '$1$2.$3'); //只能输入两个小数
		}

		return newText;
	}

	static inputNumberFormat(text, min, max) { //22,111,22.11   判断是否是金额
		let newText = (text != '' && text.substr(0, 1) == '.') ? '' : text;
		// newText = newText.replace(/^0+[0-9]+/g, "0"); //不能以0开头输入
		newText = newText.replace(/[^\d]/g, ""); //清除"数字"和"."以外的字符
		newText = newText.replace(/\.{2,}/g, "."); //只保留第一个, 清除多余的
		newText = newText.replace(".", "$#$").replace(/\./g, "").replace("$#$", ".");
		if (min && parseFloat(newText) < min) {
			let message = '输入数字不能小于' + min.toString();
			Tool.Toast_Message(message);
			return min.toString();
		}
		if (max && parseFloat(newText) > max) {
			let message = '输入数字不能大于' + max.toString();
			Tool.Toast_Message(message);
			return max.toString();
		}
		return newText;
	}


	static unit4(arr) {
		var str = "",
			i = 0;
		while (arr.length) {
			var t = arr.pop();
			str = (c[t] + (t == 0 ? "" : e[i])) + str;
			i++;
		}

		str = str.replace(/[零]{2,}/g, "零");
		str = str.replace(/^[零]/, "");
		str = str.replace(/[零]$/, "");
		if (str.indexOf("零") == 0) {
			str = str.substring(1);
		}
		if (str.lastIndexOf("零") == str.length - 1) {
			str = str.substring(0, str.length - 1);
		}

		return str;
	}


	static _formatD(a) {
		// 转化整数部分
		var arr = a.split(""),
			i = 0,
			result = "";
		while (arr.length) {
			var arr1 = arr.splice(-4, 4);

			var dw = d.charAt(i),
				unit = unit4(arr1);

			if (dw == '万' && !unit) {
				dw = "";
			}
			result = unit + dw + result;
			i += 4;
		}
		return result == "元" ? "" : result;
	}

	static _formatF(b) {
		// 转化小数部分
		b = b || "";
		switch (b.length) {
			case 0:
				return "整";
			case 1:
				return c[b] + "角";
			default:
				return c[b.charAt(0)] + "角" + c[b.charAt(1)] + "分";
		}
	}

	static _format(n) {
		var a = ("" + n).split("."),
			a0 = a[0],
			a1 = a[1];
		return _formatD(a0) + _formatF(a1);
	}

	static parse4(u4) {
		var res = 0;
		var t = [];
		while (t = /([零壹贰叁肆伍陆柒捌玖])([拾佰仟]?)/g.exec(u4)) {
			var n = _c[t[1]],
				d = {
					"": 1,
					"拾": 10,
					"佰": 100,
					"仟": 1000
				} [t[2]];
			res += n * d;
			u4 = u4.replace(t[0], "");
		}
		var result = ("0000" + res);
		return result.substring(result.length - 4);
	}

	static _parseD(d) {
		var arr = d.replace(/[零]/g, "").split(/[万亿]/),
			rs = "";
		for (var i = 0; i < arr.length; i++) {
			rs += parse4(arr[i]);
		};
		return rs.replace(/^[0]+/, "");
	};


	static _parseF(f) {
		var res = "",
			t = f.replace(/[^零壹贰叁肆伍陆柒捌玖]+/g, "").split(""); // 去掉单位
		if (t.length) {
			res = ".";
		} else {
			return "";
		};
		for (var i = 0;
			(i < t.length && i < 2); i++) {
			res += _c[t[i]];
		};
		return res;
	};

	static _parse(rmb) {
		var a = rmb.split("元"),
			a1 = a[1],
			a0 = a[0];
		if (a.length == 1) {
			a1 = a0;
			a0 = "";
		}
		return _parseD(a0) + _parseF(a1);

	};

	//小写转大写
	static formatRMB(num) {
		var n = Number(num);
		if (!isNaN(num)) {
			if (num == 0) {
				return "零元整";
			} else {
				return _format(n);
			}
		} else {
			return false;
		}
	}

	//大写转小写
	static parseRMB(rmb) {
		if (/^[零壹贰叁肆伍陆柒捌玖元万亿拾佰仟角分整]{2,}$/.test(rmb)) {
			var result = _parse(rmb);
			return rmb == this.formatRMB(result) ? result : result + "(?)";
		} else {
			return false;
		}
	};

	static parseInt_FG(x, defaultValue) {
		if (typeof(x) == 'string') {
			var value = x.replace(/[^0-9.]/ig, "");
			value = parseFloat(value);
			if (isNaN(value)) {
				if (defaultValue) {
					return defaultValue;
				}
				return 0;
			}
			return Math.floor(value);
		} else {
			return Math.floor(x);
		}
	}
	x
	//汇率转字符串类型
	static parseFloatRate(x, defaultValue) {
		if (typeof(x) == 'string') {
			var value = x.replace(/[^0-9.]/ig, "");
			value = parseFloat(value);
			if (isNaN(value)) {
				if (defaultValue) {
					return defaultValue;
				}
				return 1;
			}
			return value;
		} else {
			return x;
		}
	}
}