import http from "@/rokeTools/request/index.js";
//获取微信openid和token
export function wx_code_get_openid(code) {
	return new Promise((resolve, reject) => {
		uni.showLoading({
			title: '',
			mask: true,
		})
		http('wx.wx_code_get_openid', {
			code: code ? code : ''
		}).then((data) => {
			uni.hideLoading();
			if (data?.result?.state == 'success') {
				resolve(data.result);
			} else {
				uni.showToast({
					title: data?.result?.msgs,
					icon: 'none'
				})
				reject({});
			}

		}).catch((err) => {
			uni.hideLoading();
			uni.showToast({
				title: data?.result?.msgs,
				icon: 'none'
			})
			reject(err);
		})
	});
}
//获取设备信息
export function mix_barcode_get_device(code) {
	return new Promise((resolve, reject) => {
		uni.showLoading({
			title: '',
			mask: true,
		})
		http('sh.mix_barcode_get_device', {
			product_lot: code ? code : ''
		}).then((data) => {
			uni.hideLoading();
			if (data?.result?.state == 'success') {
				resolve(data.result);
			} else {
				uni.showToast({
					title: data?.result?.msgs,
					icon: 'none'
				})
				reject({});
			}

		}).catch((err) => {
			uni.hideLoading();
			uni.showToast({
				title: '请求详情数据失败',
				icon: 'none'
			})
			reject(err);
		})
	});
}
//创建售后工单
export function mix_create_aso(data) {
	return new Promise((resolve, reject) => {
		uni.showLoading({
			title: '',
			mask: true,
		})
		http('sh.mix_create_aso', {
			"wx_open_id": data.wx_open_id ? data.wx_open_id : '',
			"product_lot": data.product_lot ? data.product_lot : '',
			"company_name": data.company_name ? data.company_name : '',
			"contacts": data.contacts ? data.contacts : '',
			"contact_phone": data.contact_phone ? data.contact_phone : '',
			"problem_note": data.problem_note ? data.problem_note : '',
			"problem_images": data.problem_images ? data.problem_images : ''
		}).then((data) => {
			uni.hideLoading();
			if (data?.result?.state == 'success') {
				resolve(data.result);
			} else {
				uni.showToast({
					title: data?.result?.msgs,
					icon: 'none'
				})
				reject({});
			}

		}).catch((err) => {
			uni.hideLoading();
			uni.showToast({
				title: '请求详情数据失败',
				icon: 'none'
			})
			reject(err);
		})
	});
}
//获取售后工单列表
export function mix_get_aso_list(num, size, query) {
	return new Promise((resolve, reject) => {
		uni.showLoading({
			title: '',
			mask: true,
		})
		http('sh.mix_get_aso_list', {
			page_no: num ? num : '',
			page_size: size ? size : '',
			query: query ? query : ''
		}).then((data) => {
			uni.hideLoading();
			if (data?.result?.state == 'success') {
				resolve(data.result);
			} else {
				uni.showToast({
					title: data?.result?.msgs,
					icon: 'none'
				})
				reject({});
			}

		}).catch((err) => {
			uni.hideLoading();
			uni.showToast({
				title: '请求详情数据失败',
				icon: 'none'
			})
			reject(err);
		})
	});
}
//获取售后工单详情
export function mix_get_aso_detail(id) {
	return new Promise((resolve, reject) => {
		uni.showLoading({
			title: '',
			mask: true,
		})
		http('sh.mix_get_aso_detail', {
			aso_id: id ? id : ''
		}).then((data) => {
			uni.hideLoading();
			if (data?.result?.state == 'success') {
				resolve(data.result);
			} else {
				uni.showToast({
					title: data?.result?.msgs,
					icon: 'none'
				})
				reject({});
			}

		}).catch((err) => {
			uni.hideLoading();
			uni.showToast({
				title: '请求详情数据失败',
				icon: 'none'
			})
			reject(err);
		})
	});
}
//提交评价
export function submit_evaluation(id, evaluation, note) {
	return new Promise((resolve, reject) => {
		uni.showLoading({
			title: '',
			mask: true,
		})
		http('sh.submit_evaluation', {
			aso_id: id ? id : '',
			evaluation:evaluation?evaluation:'',
			"evaluation_note":note?note:''
		}).then((data) => {
			uni.hideLoading();
			if (data?.result?.state == 'success') {
				resolve(data.result);
			} else {
				uni.showToast({
					title: data?.result?.msgs,
					icon: 'none'
				})
				reject({});
			}

		}).catch((err) => {
			uni.hideLoading();
			uni.showToast({
				title: '请求详情数据失败',
				icon: 'none'
			})
			reject(err);
		})
	});
}