// 图片转base64
function detailImage(path, callback) {
  // #ifdef APP-PLUS
  plus.io.resolveLocalFileSystemURL(path, function(entry) {
    entry.file(function(file) {
      var fileReader = new plus.io.FileReader();
      fileReader.readAsDataURL(file);
      fileReader.onloadend = function(evt) {
        // 回调函数返回base64的值
        callback(evt.target.result);
      }
    })
  })
  // #endif

  // #ifdef H5
  var img = new Image();
  img.src = path;
  img.onload = function() {
    //默认按比例压缩
    var w = this.width,
      h = this.height;
    var quality = 0.95; // 默认图片质量为0.7
    //生成canvas
    var canvas = document.createElement('canvas');
    var ctx = canvas.getContext('2d');
    // 创建属性节点
    canvas.setAttribute("width", w);
    canvas.setAttribute("height", h);
    ctx.drawImage(this, 0, 0, w, h);
    // quality值越小，所绘制出的图像越模糊
    var base64 = canvas.toDataURL('image/jpeg', quality);
    // 回调函数返回base64的值
    callback(base64);
  };
  // #endif
}
module.exports = detailImage;
