const decodeStr = {
  
  // 获取窗口尺寸
  get_systemInfo(){
    let system_obj = {}
    uni.getSystemInfo({
      success: (res) => {
        // 获取设备系统  安卓、ios、window
        system_obj.platform = res.platform
        // 宽度和高度
        system_obj.winSize = {
          "width": res.windowWidth,
          "height": res.windowHeight
        }
        // 可使用窗口高度，将px转换rpx
        system_obj.phoneHeight = (res.windowHeight * (750 / res.windowWidth))
      }
    })
    return system_obj
  },
 // 获取文件地址函数
 getObjectURL(file) {
   var url = null
   if (window.createObjectURL !== undefined) { // basic
     url = window.createObjectURL(file)
   } else if (window.URL !== undefined) { // mozilla(firefox)
     url = window.URL.createObjectURL(file)
   } else if (window.webkitURL !== undefined) { // webkit or chrome
     url = window.webkitURL.createObjectURL(file)
   }
   return url
 },
 // 解码，输出：中文
 decodeStr(str) {
   var out, i, len, c;
   var char2, char3;
   out = "";
   len = str.length;
   i = 0;
   while (i < len) {
     c = str.charCodeAt(i++);
     switch (c >> 4) {
       case 0:
       case 1:
       case 2:
       case 3:
       case 4:
       case 5:
       case 6:
       case 7:
         // 0xxxxxxx
         out += str.charAt(i - 1);
         break;
       case 12:
       case 13:
         // 110x xxxx 10xx xxxx
         char2 = str.charCodeAt(i++);
         out += String.fromCharCode(((c & 0x1F) << 6) | (char2 & 0x3F));
         break;
       case 14:
         // 1110 xxxx 10xx xxxx 10xx xxxx
         char2 = str.charCodeAt(i++);
         char3 = str.charCodeAt(i++);
         out += String.fromCharCode(((c & 0x0F) << 12) |
           ((char2 & 0x3F) << 6) |
           ((char3 & 0x3F) << 0));
         break;
     }
   }
   return out;
 },
};

export default decodeStr;
