import Bus from '@/rokeTools/bus/bus.js'

const state = {
	titles: '',
	show: false,
	type: false, //有无类别
	list: [],
	sellist:[],
	tags:'tag',
	sel_data:''
}

const getters = {
	show: state => {
		return state.show;
	},
	titles: state => {
		return state.titles;
	},
	type: state => {
		return state.type;
	},
	list: state => {
		return state.list;
	},
	tags: state => {
		return state.tags;
	},
	sel_data: state => {
		return state.sel_data;
	},
	sellist:state => {
		return state.sellist;
	},
}

const actions = {

	//检测是否是引流版并保存数据
	show({
		commit,
		dispatch,
		getters,
		state
	}, option = null) {
		commit('SHOW_', option)
	},
	list({
		commit,
		dispatch,
		getters,
		state
	}, option = null) {
		commit('List', option)
	},
	sellist({
		commit,
		dispatch,
		getters,
		state
	}, option = null) {
		commit('Sel', option)
	},
	type({
		commit,
		dispatch,
		getters,
		state
	}, option = null) {

	},
	titles({
		commit,
		dispatch,
		getters,
		state
	}, option = null) {
		commit('Titles', option)
	},
	tags({
		commit,
		dispatch,
		getters,
		state
	}, option = null) {
		commit('Tag', option)
	},
	sel_data({
		commit,
		dispatch,
		getters,
		state
	}, option = null) {
		commit('Sel', option)
	}
}

const mutations = {
	SHOW_(state, option) {
		state.show = option.flag;
	},
	List(state, option) {
		state.list = option.list
	},
	Sel(state, option){
		state.sellist = option.list
	},
	Titles(state, option){
		state.titles=option.title
	},
	Tag(state, option){
		state.tags=option.tag
	},
	Sel(state, option){
		state.sel_data=option.data
	}
}



export default {
	state,
	mutations,
	actions,
	getters
}