/**
 * Platform v1.0.0
 * @Class Platform
 * @description shopro-platform 1.0.0 全平台兼容
 * @Author lidongtony
 * @Date 2021-04-07
 * @Email lidongtony@qq.com
 */


export default {

	// 获取当前运行平台
	get() {
		let platform = '';
		// #ifdef H5
		platform = 'H5';
		// #endif
		// #ifdef APP-PLUS
		platform = 'App';
		// #endif
		// #ifdef MP-WEIXIN
		platform = 'wxMiniProgram';
		// #endif
		// #ifdef MP-ALIPAY
		platform = 'alipayMiniProgram';
		// #endif
		if (platform !== '') {
			uni.setStorageSync('platform', platform);
		} else {
			uni.showToast({
				title: '暂不支持该平台',
				icon: 'none'
			});
		}
		return platform;
	},
	set(platform) {
		uni.setStorageSync('platform', platform);
		return platform;
	},

	// 检测当前运行机型
	device() {
		// 客户端平台，值域为：ios、android、mac（3.1.10+）、windows（3.1.10+）、linux（3.1.10+）
		return uni.getSystemInfoSync().platform;
	},
	// 检测当前的原生版本号
	getNativeVersion() {
		return uni.getSystemInfoSync().appVersion;
	},

}