
import { RokeProductCategoryPageModel, RokeProductCategoryPageParams, RokeProductCategoryPageResult } from './model/CplbModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/jcsj/cplb/page',
  List = '/jcsj/cplb/list',
  Info = '/jcsj/cplb/info',
  RokeProductCategory = '/jcsj/cplb',
  
  
  
}

/**
 * @description: 查询RokeProductCategory分页列表
 */
export async function getRokeProductCategoryPage(params: RokeProductCategoryPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<RokeProductCategoryPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取RokeProductCategory信息
 */
export async function getRokeProductCategory(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<RokeProductCategoryPageModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增RokeProductCategory
 */
export async function addRokeProductCategory(rokeProductCategory: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.RokeProductCategory,
      params: rokeProductCategory,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新RokeProductCategory
 */
export async function updateRokeProductCategory(rokeProductCategory: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.RokeProductCategory,
      params: rokeProductCategory,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除RokeProductCategory（批量删除）
 */
export async function deleteRokeProductCategory(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.RokeProductCategory,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}




