import { Collection, some } from 'min-dash';

import { is } from './ModelUtil';

export function isAny(element: any, types: Collection<any>) {
  return some(types, function (t: any) {
    return is(element, t);
  });
}

export function getParent(element: { parent: any }, anyType: string[]) {
  if (typeof anyType === 'string') {
    anyType = [anyType];
  }

  while ((element = element.parent)) {
    if (isAny(element, anyType)) {
      return element;
    }
  }

  return null;
}
