import { is, getBusinessObject } from './ModelUtil';

import { forEach } from 'min-dash';

export function isExpanded(element: any) {
  if (is(element, 'bpmn:CallActivity')) {
    return false;
  }

  if (is(element, 'bpmn:SubProcess')) {
    return !!getBusinessObject(element).di.isExpanded;
  }

  if (is(element, 'bpmn:Participant')) {
    return !!getBusinessObject(element).processRef;
  }

  return true;
}

export function isInterrupting(element: any) {
  return element && getBusinessObject(element).isInterrupting !== false;
}

export function isEventSubProcess(element: any) {
  return element && !!getBusinessObject(element).triggeredByEvent;
}

export function hasEventDefinition(element: { businessObject: any }, eventType: string) {
  const bo = getBusinessObject(element);
  let hasEventDefinitionStr = false;

  if (bo.eventDefinitions) {
    forEach(bo.eventDefinitions, function (event: { businessObject: any }) {
      if (is(event, eventType)) {
        hasEventDefinitionStr = true;
      }
    });
  }

  return hasEventDefinitionStr;
}

export function hasErrorEventDefinition(element: any) {
  return hasEventDefinition(element, 'bpmn:ErrorEventDefinition');
}

export function hasEscalationEventDefinition(element: any) {
  return hasEventDefinition(element, 'bpmn:EscalationEventDefinition');
}

export function hasCompensateEventDefinition(element: any) {
  return hasEventDefinition(element, 'bpmn:CompensateEventDefinition');
}
