import { LegendType, LocationType, OrientType, RadarShapeType } from '/@/enums/desktop';

import { ChartLegend } from '/@/model/desktop/designer';
import { useI18n } from '/@/hooks/web/useI18n';
const { t } = useI18n();
export const colors = [
  '#5470c6',
  '#91cc75',
  '#fac858',
  '#ee6666',
  '#73c0de',
  '#3ba272',
  '#fc8452',
  '#9a60b4',
  '#ea7ccc',
];
export const legendProperties: ChartLegend = {
  show: true,
  orient: OrientType.HORIZONTAL,
  left: 'center',
  top: 'bottom',
  right: 'auto',
  bottom: 'bottom',
  padding: 8,
  icon: LegendType.ROUND_RECT,
  itemWidth: 25,
  itemHeight: 14,
  textStyle: {
    color: '#000',
  },
  formatter: '{name}',
};

//  数据视图属性
export const apiConfigInfo = {
  apiData: {},
  apiColumns: [],
  apiConfig: {
    id: '',
    name: '',
    method: '',
    path: '',
    requestParamsConfigs: [], //Query Params
    requestHeaderConfigs: [], //Header
    requestBodyConfigs: [], //Body
  },
  refreshComponent: [],
};
//  数据视图属性
export const dataViewInfo = {
  labelKey: '',
  valueKey: '',
};

//折线/柱状图
export const chartLineIndicatorConfig = {
  title: '',
  type: 'line',
  color: '',
  name: '',
  value: '',
  showAreaStyle: false, //是否显示面积图
  gradualStartColor: '',
  gradualEndColor: '',
};
export const chartLineDataListsConfig = {
  title: '',
  valueKey: '',
  apiColumns: [],
  apiData: [],
  total: 0,
  indicator: [chartLineIndicatorConfig],
  apiConfig: {
    id: '',
    name: '',
    method: '',
    path: '',
    requestParamsConfigs: [], //Query Params
    requestHeaderConfigs: [], //Header
    requestBodyConfigs: [], //Body
  },
};
export const chartLineSeriesConfig = {
  name: '',
  type: 'line',
  stack: '',
  smooth: false,
  label: {
    show: false,
    color: '#000000',
    position: 'outside',
    fontWeight: 'normal',
    fontSize: 12,
    formatter: null,
  },
  data: [] as number[],
  symbol: '',
};
export const chartLineEchartsConfig = {
  color: [] as string[],
  legend: {
    data: [] as string[],
  },
  tooltip: {
    trigger: 'axis',
  },
  grid: {
    left: '3%',
    right: '4%',
    bottom: '3%',
    containLabel: true,
  },
  xAxis: [
    {
      type: 'category',
      data: [] as string[],
      axisLine: {
        show: true,
        lineStyle: {
          color: '',
        },
      },
    },
  ],
  yAxis: [
    {
      type: 'value',
      axisLine: {
        show: true,
        lineStyle: {
          color: '',
        },
      },
    },
  ],
  series: [chartLineSeriesConfig],
};
export const chartLineYAxis = {
  name: '',
  nameLocation: 'end',
  nameTextStyle: {
    color: '',
    fontSize: 12,
    fontWeight: 'normal',
  },
  min: 'dataMin',
  max: 'dataMax',
  interval: null,
  position: 'left',
  type: 'value',
  axisLabel: {
    formatter: '{value}',
    color: '',
  },
  axisLine: {
    show: true,
    lineStyle: {
      color: '',
    },
  },
};
export const chartLineProperties = {
  legend: {
    ...legendProperties,
  },
  dataList: [
    {
      title: '',
      valueKey: 'name',
      apiColumns: [],
      apiData: [],
      total: 0,
      indicator: [
        {
          title: '',
          type: 'line',
          color: '',
          name: '',
          value: 'quantity',
          showAreaStyle: false, //是否显示面积图
          gradualStartColor: '',
          gradualEndColor: '',
        },
      ],
      apiConfig: {
        id: '16da3d4cabcf4bed91ab74b7c12e9414',
        method: 'GET',
        name: '图表数据',
        path: 'DesktopDesign/chart',
        requestParamsConfigs: [], //Query Params
        requestHeaderConfigs: [], //Header
        requestBodyConfigs: [], //Body
      },
    },
  ],
  bar: {
    stack: false, //是否显示堆叠
    label: {
      show: true,
      color: '',
    },
  },
  line: {
    smooth: false,
    stack: false, //是否显示堆叠
    showAreaStyle: false, //是否显示面积图
    gradualStartColor: '',
    gradualEndColor: '',
    showSymbol: true,
  },
  seriesLabel: {
    show: false,
    color: '#000000',
    position: 'outside',
    fontWeight: 'normal',
    fontSize: 12,
    formatter: null,
  },
  yAxis: [chartLineYAxis],
  xAxis: [
    {
      position: 'bottom',
      name: '',
      nameLocation: 'end',
      nameTextStyle: {
        color: '',
        fontSize: 12,
        fontWeight: 'normal',
      },
      type: 'category',
      axisLabel: {
        formatter: '{value}',
        color: '',
      },
      axisLine: {
        show: true,
        lineStyle: {
          color: '',
        },
      },
      data: [],
    },
  ],
  echarts: [chartLineEchartsConfig],
  isCrosswise: false,
  condition: { color: '', selected: '' },
  count: { show: false, unit: '', title: '' },
  refreshComponent: [],
};

//饼图
export const pieProperties = {
  ...apiConfigInfo,
  colors: colors,
  autoWidth: true,
  labelKey: 'name',
  valueKey: 'quantity',
  pieConfig: {
    centerOfCircleSize: 30,
    sizeOfOuterCircle: 60,
    horizontalPosition: 50,
    verticalPosition: 40,
    borderRadius: 0,
    color: [],
    location: LocationType.BOTTOM_CENTER,
  },
  echarts: {
    alignTicks: true,
    legend: {
      ...legendProperties,
      width: 'auto',
    },
    tooltip: {
      trigger: 'item',
    },
    series: [
      {
        type: 'pie',
        roseType: undefined,
        selectedMode: undefined,
        radius: ['0%', '50%'],
        center: ['50%', '50%'],
        label: {
          show: true,
          color: '#000000',
          position: 'outside',
          fontWeight: 'normal',
          fontSize: 12,
          formatter: '{b}: {d}',
        },
        itemStyle: {
          borderRadius: 0,
        },
        data: [],
      },
    ],
  },
  apiConfig: {
    id: '16da3d4cabcf4bed91ab74b7c12e9414',
    method: 'GET',
    name: '图表数据',
    path: 'DesktopDesign/chart',
    requestParamsConfigs: [], //Query Params
    requestHeaderConfigs: [], //Header
    requestBodyConfigs: [], //Body
  },
};

//雷达图
export const radarProperties = {
  ...apiConfigInfo,
  colors: colors,
  labelKey: 'name',
  echarts: {
    alignTicks: true,
    legend: {
      data: [],
      ...legendProperties,
      formatter: '',
    },
    radar: {
      radius: 100,
      shape: RadarShapeType.CIRCLE,
      indicator: [
        { value: 'quantity', name: '指标1' },
        { value: 'price', name: '指标2' },
        { value: 'unitPrice', name: '指标3' },
      ],
    },
    showAreaStyle: true,
    series: [
      {
        type: 'radar',
        itemStyle: {
          borderRadius: 0,
        },
        label: {
          show: false,
          color: '#000000',
          position: 'outside',
          fontWeight: 'normal',
          fontSize: 12,
          formatter: '',
        },
        symbol: LegendType.CIRCLE,
        areaStyle: {},
        data: [
          {
            name: t('指标1'),
            value: [],
          },
          {
            name: t('指标2'),
            value: [],
          },
          {
            name: t('指标3'),
            value: [],
          },
        ],
      },
    ],
  },
  apiConfig: {
    id: '16da3d4cabcf4bed91ab74b7c12e9414',
    method: 'GET',
    name: '图表数据',
    path: 'DesktopDesign/chart',
    requestParamsConfigs: [], //Query Params
    requestHeaderConfigs: [], //Header
    requestBodyConfigs: [], //Body
  },
};

//仪表盘

export const gaugeProperties = {
  ...apiConfigInfo,
  valueKey: 'quantity',
  echarts: {
    tooltip: {
      trigger: 'item',
      formatter: '{b} : {c}',
    },
    series: [
      {
        name: t('仪表盘'),
        type: 'gauge',
        progress: {
          show: true,
        },
        data: [
          {
            name: t('仪表盘'),
            value: 0,
          },
        ],
      },
    ],
  },
  apiConfig: {
    id: '16da3d4cabcf4bed91ab74b7c12e9414',
    method: 'GET',
    name: '图表数据',
    path: 'DesktopDesign/chart',
    requestParamsConfigs: [], //Query Params
    requestHeaderConfigs: [], //Header
    requestBodyConfigs: [], //Body
  },
};

//漏斗图

export const funnelProperties = {
  ...apiConfigInfo,
  labelKey: 'name',
  valueKey: 'price',
  colors: colors,
  autoWidth: true,
  echarts: {
    alignTicks: true,
    legend: {
      ...legendProperties,
      width: 'auto',
    },
    tooltip: {
      trigger: 'item',
      formatter: '{b} : {c}',
    },
    series: [
      {
        name: '',
        type: 'funnel',
        left: '10%',
        top: 10,
        bottom: 60,
        width: '80%',
        min: 0,
        max: 100,
        minSize: '0%',
        maxSize: '100%',
        sort: 'descending',
        gap: 2,
        label: {
          show: true,
          position: 'inside',
        },
        labelLine: {
          length: 10,
          lineStyle: {
            width: 1,
            type: 'solid',
          },
        },
        itemStyle: {
          borderColor: '#fff',
          borderWidth: 1,
        },
        emphasis: {
          label: {
            fontSize: 20,
          },
        },
        data: [],
      },
    ],
  },
  apiConfig: {
    id: '16da3d4cabcf4bed91ab74b7c12e9414',
    method: 'GET',
    name: '图表数据',
    path: 'DesktopDesign/chart',
    requestParamsConfigs: [], //Query Params
    requestHeaderConfigs: [], //Header
    requestBodyConfigs: [], //Body
  },
};

//柱状百分比

export const chartBarProperties = {
  ...apiConfigInfo,
  labelKey: 'name',
  valueKey: 'unitPrice',
  targetKey: 'price', //目标值
  unit: t('万元'),
  apiConfig: {
    id: '16da3d4cabcf4bed91ab74b7c12e9414',
    method: 'GET',
    name: '图表数据',
    path: 'DesktopDesign/chart',
    requestParamsConfigs: [], //Query Params
    requestHeaderConfigs: [], //Header
    requestBodyConfigs: [], //Body
  },
};
// 甘特图
export const categoryStackProperties = {
  ...apiConfigInfo,
  labelKey: 'name',
  valueKey: 'unitPrice',
  targetKey: 'price', //目标值
  echarts: {
    tooltip: {
      trigger: 'axis',
      axisPointer: {
        type: 'shadow', // 'shadow' as default; can also be 'line' or 'shadow'
      },
    },
    legend: {},
    grid: {
      left: '3%',
      right: '4%',
      bottom: '3%',
      containLabel: true,
    },
    xAxis: {
      type: 'value',
    },
    yAxis: {
      type: 'category',
      data: [],
    },
    series: [],
  },
  apiConfig: {
    id: '16da3d4cabcf4bed91ab74b7c12e9414',
    method: 'GET',
    name: '图表数据',
    path: 'DesktopDesign/chart',
    requestParamsConfigs: [], //Query Params
    requestHeaderConfigs: [], //Header
    requestBodyConfigs: [], //Body
  },
};
