import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'dataDate',
    label: '日期',
    component: 'RangePicker',
    componentProps: {
      format: 'YYYY-MM-DD',
      style: { width: '100%' },
      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },

  {
    field: 'keyword',
    label: '',
    component: 'Input',
    componentProps: {
      pplaceholder: '请输入产品编码或名称',
    },
    colProps: { span: 8 },
  },
];

export const columns: BasicColumn[] = [
  {
    dataIndex: 'realEndDate',
    title: '生产日期',
    componentType: 'auto-code',

    sorter: true,
  },

  {
    dataIndex: 'materialNo',
    title: '产品编码',
    componentType: 'date',

    sorter: true,
  },

  {
    dataIndex: 'materialName',
    title: '产品名称',
    componentType: 'input',

    sorter: true,
  },
  {
    dataIndex: 'model',
    title: '产品型号',
    componentType: 'input',

    sorter: true,
  },
  {
    dataIndex: 'planNum',
    title: '计划产量',
    componentType: 'select',

    sorter: true,
  },
  {
    dataIndex: 'realNum',
    title: '生产数量',
    componentType: 'select',

    sorter: true,
  },
  {
    dataIndex: 'samplingNum',
    title: '抽样数',
    componentType: 'input',
    sorter: true,
    align: 'right',
  },
  {
    dataIndex: 'errorNum',
    title: '不良数',
    componentType: 'user',

    sorter: true,
  },

  {
    dataIndex: 'errorRate',
    title: '合格率',
    componentType: 'textarea',

    sorter: true,
  },
];
