import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';
import { uploadApi } from '/@/api/sys/upload';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'code',
    label: '检验报告编号',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'name',
    label: '报告名称',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'reportType',
    label: '报告类型',
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'staticData',
      staticOptions: [
        { label: '按单', value: '1', key: 1 },
        { label: '按物料', value: '2', key: 2 },
      ],
      labelField: 'label',
      valueField: 'value',

      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },
  {
    field: 'supplierName',
    label: '供应商名称',
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'api',
      apiConfig: {
        method: 'GET',
        script:
          'var condition="";\r\n// if(data_type!=null&&data_type!=""){ \r\n//     condition+=" and data_type=#{data_type}";\r\n// }\r\n// if(warehouse_id!=null&&warehouse_id!=""){ \r\n//     condition+=" and warehouse_id=#{warehouse_id}";\r\n// }\r\n// if(area_id!=null&&area_id!=""){ \r\n//     condition+=" and area_id=#{area_id}";\r\n// }\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(type_code,\'-\',type_name) AS label FROM mes_dev_type where state=1 "+condition)',
        apiParams: [
          { tableInfo: [], title: 'Query Params', key: '1' },
          { tableInfo: [], title: 'Header', key: '2' },
          { title: 'Body', key: '3' },
        ],
        path: '/mes/getSupplierList',
        apiId: 'copy1690511531075d26035',
      },
      labelField: 'label',
      valueField: 'value',

      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },
  {
    field: 'checkDate',
    label: '检验日期',
    component: 'RangePicker',
    componentProps: {
      format: 'YYYY-MM-DD',
      style: { width: '100%' },
      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },

  {
    field: 'judgeResult',
    label: '整体判定',
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'staticData',
      staticOptions: [
        { label: '合格', value: '1', key: 1 },
        { label: '不合格', value: '2', key: 2 },
      ],
      labelField: 'label',
      valueField: 'value',

      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },
  {
    field: 'checkUser',
    label: '检验员',
    component: 'User',
    componentProps: {
      suffix: 'ant-design:setting-outlined',
      placeholder: '请选择',
    },
    colProps: { span: 8 },
  },

  {
    field: 'buyOrderno',
    label: '采购订单号',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'sendNo',
    label: '送货单号',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'sampCount',
    label: '抽样数',
    component: 'InputNumber',
    componentProps: {
      style: { width: '100%' },
    },
    colProps: { span: 8 },
  },
];

export const columns: BasicColumn[] = [
  {
    dataIndex: 'code',
    title: '检验报告编号',
    componentType: 'auto-code',

    sorter: true,
  },

  {
    dataIndex: 'name',
    title: '报告名称',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'judgeResult',
    title: '整体判定',
    componentType: 'radio',

    customRender: ({ record }) => {
      const staticOptions = [
        { label: '合格', value: '1', key: 1 },
        { label: '不合格', value: '2', key: 2 },
      ];
      return staticOptions.filter((x) => x.value === record.judgeResult)[0]?.label;
    },
    sorter: true,
  },

  {
    dataIndex: 'reportType',
    title: '报告类型',
    componentType: 'select',

    customRender: ({ record }) => {
      const staticOptions = [
        { label: '按单', value: '1', key: 1 },
        { label: '按物料', value: '2', key: 2 },
      ];
      return staticOptions.filter((x) => x.value === record.reportType)[0]?.label;
    },
    sorter: true,
  },

  {
    dataIndex: 'supplierName',
    title: '供应商名称',
    componentType: 'select',

    sorter: true,
  },

  {
    dataIndex: 'checkDate',
    title: '检验日期',
    componentType: 'date',

    sorter: true,
  },

  {
    dataIndex: 'checkUser',
    title: '检验员',
    componentType: 'info',

    sorter: true,
  },

  {
    dataIndex: 'createDate',
    title: '报告生成日期',
    componentType: 'info',

    sorter: true,
  },

  {
    dataIndex: 'remark',
    title: '备注',
    componentType: 'textarea',

    sorter: true,
  },
];

export const formProps: FormProps = {
  labelWidth: '120px',
  labelAlign: 'right',
  layout: 'horizontal',
  size: 'default',
  schemas: [
    {
      key: 'c6a4b79c05bc4e488a6605ec02a2ed20',
      field: '',
      label: '标题',
      type: 'title',
      component: 'Title',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '基础信息',
      componentProps: {
        color: '',
        defaultValue: '基础信息',
        align: 'left',
        fontSize: 15,
        style: {},
      },
    },
    {
      key: '9b416ca82c774e40bfbc78426c0df44f',
      field: 'code',
      label: '检验报告编号',
      type: 'auto-code',
      component: 'AutoCodeRule',
      colProps: { span: 8 },
      ifShow: true,
      componentProps: {
        col: 8,
        prefix: '',
        suffix: '',
        addonAfter: '',
        showLabel: true,
        required: true,
        readonly: true,
        width: '100%',
        placeholder: '请输入检验报告编号',
        addonBefore: '',
        autoCodeRule: 'mesinchcekNo',
        style: { width: '100%' },
      },
    },
    {
      key: '6cb7245519ad4c528774a387224f57ae',
      field: 'isSysNum',
      label: '多选组件',
      type: 'checkbox',
      component: 'ApiCheckboxGroup',
      colProps: { span: 4 },
      ifShow: true,
      componentProps: {
        col: 4,
        defaultSelect: '1',
        rules: [],
        valueField: 'value',
        showLabel: false,
        required: false,
        labelField: 'label',
        datasourceType: 'staticData',
        dicOptions: [],
        apiConfig: {},
        disabled: false,
        staticOptions: [{ label: '用系统编号', value: '1', key: 1 }],
        events: {
          change:
            "const code='code';//编码字段名\nif(formModel.isSysNum==1){\n\tformModel[code]=formModel.codeTemp; formActionType.updateSchema({field:code,componentProps: {readonly:true}});\n}else{\n  formModel.codeTemp=formModel[code];\n  formModel[code]='';\nformActionType.updateSchema({field:code,componentProps: {readonly:false}});\n}",
        },
        style: {},
      },
    },
    {
      key: '5e872d8d13a84b7c965275e705233133',
      field: 'name',
      label: '报告名称',
      type: 'input',
      component: 'Input',
      colProps: { span: 12 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        col: 12,
        defaultValue: '',
        prefix: '',
        rules: [],
        suffix: '',
        addonAfter: '',
        showLabel: true,
        required: true,
        width: '100%',
        disabled: false,
        placeholder: '请输入报告名称',
        allowClear: false,
        addonBefore: '',
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: '067a4e63479d454f8f3371187ad1d53d',
      field: 'sendDate',
      label: '送货日期',
      type: 'date',
      component: 'DatePicker',
      colProps: { span: 12 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        col: 12,
        defaultValue: '',
        format: 'YYYY-MM-DD',
        rules: [],
        showLabel: true,
        required: true,
        width: '100%',
        disabled: false,
        placeholder: '请选择送货日期',
        allowClear: true,
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: '1decf8cad9d244898045f1e143b540e4',
      field: 'checkDate',
      label: '检验日期',
      type: 'date',
      component: 'DatePicker',
      colProps: { span: 12 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        col: 12,
        defaultValue: '',
        format: 'YYYY-MM-DD',
        rules: [],
        showLabel: true,
        required: true,
        width: '100%',
        disabled: false,
        placeholder: '请选择检验日期',
        allowClear: true,
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: 'd90d9074dc5c42e5a6e18a5b61644f4f',
      field: 'checkUser',
      label: '检验员',
      type: 'info',
      component: 'Info',
      colProps: { span: 12 },
      ifShow: true,
      componentProps: {
        col: 12,
        showLabel: true,
        infoType: 0,
        width: '100%',
        disabled: true,
        placeholder: '',
        loadAgain: false,
        style: { width: '100%' },
      },
    },
    {
      key: '277bbb8b3a444b529a1e4ec6ce45a853',
      field: 'supplierName',
      label: '供应商名称',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 12 },
      ifShow: true,
      componentProps: {
        col: 12,
        clearable: false,
        defaultSelect: '',
        rules: [],
        valueField: 'value',
        showLabel: true,
        required: true,
        labelField: 'label',
        datasourceType: 'api',
        dicOptions: [],
        showSearch: false,
        width: '100%',
        apiConfig: {
          method: 'GET',
          script:
            'var condition="";\r\n// if(data_type!=null&&data_type!=""){ \r\n//     condition+=" and data_type=#{data_type}";\r\n// }\r\n// if(warehouse_id!=null&&warehouse_id!=""){ \r\n//     condition+=" and warehouse_id=#{warehouse_id}";\r\n// }\r\n// if(area_id!=null&&area_id!=""){ \r\n//     condition+=" and area_id=#{area_id}";\r\n// }\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(type_code,\'-\',type_name) AS label FROM mes_dev_type where state=1 "+condition)',
          apiParams: [
            { tableInfo: [], title: 'Query Params', key: '1' },
            { tableInfo: [], title: 'Header', key: '2' },
            { title: 'Body', key: '3' },
          ],
          path: '/mes/getSupplierList',
          apiId: 'copy1690511531075d26035',
        },
        disabled: false,
        placeholder: '请选择供应商名称',
        staticOptions: [
          { label: 'Option 1', value: 'Option 1', key: 1 },
          { label: 'Option 2', value: 'Option 2', key: 2 },
          { label: 'Option 3', value: 'Option 3', key: 3 },
        ],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: '704b021a7171422da7b43ff15bb59fa1',
      field: 'buyOrderno',
      label: '采购订单号',
      type: 'input',
      component: 'Input',
      colProps: { span: 12 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        col: 12,
        defaultValue: '',
        prefix: '',
        rules: [],
        suffix: '',
        addonAfter: '',
        showLabel: true,
        required: false,
        width: '100%',
        disabled: false,
        placeholder: '请输入采购订单号',
        allowClear: false,
        addonBefore: '',
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: '53f055dd4a3246e7a2959e8d9a5cc9a1',
      field: 'sendNo',
      label: '送货单号',
      type: 'input',
      component: 'Input',
      colProps: { span: 12 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        col: 12,
        defaultValue: '',
        prefix: '',
        rules: [],
        suffix: '',
        addonAfter: '',
        showLabel: true,
        required: false,
        width: '100%',
        disabled: false,
        placeholder: '请输入送货单号',
        allowClear: false,
        addonBefore: '',
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: '8d216fdfc0b14b39adfac6cd4b130942',
      field: 'reportType',
      label: '报告类型',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 24 },
      ifShow: true,
      componentProps: {
        clearable: false,
        defaultSelect: '',
        rules: [],
        valueField: 'value',
        showLabel: true,
        required: true,
        labelField: 'label',
        datasourceType: 'staticData',
        dicOptions: [],
        showSearch: false,
        width: '100%',
        apiConfig: {},
        disabled: false,
        placeholder: '请选择报告类型',
        staticOptions: [
          { label: '按单', value: '1', key: 1 },
          { label: '按物料', value: '2', key: 2 },
        ],
        events: {
          change:
            // "if(formModel.reportType=='1'){//1按单2-按物料                           \n" +
            // "formActionType.updateSchema({field:'mesQlIncheckdataList',ifShow:true});         \n" +
            // "formActionType.updateSchema({field:'mesQlIncheckdata2List',ifShow:false});      \n" +
            // '}                                                                       \n' +
            // "if(formModel.reportType=='2'){                                          \n" +
            // "formActionType.updateSchema({field:'mesQlIncheckdataList',ifShow:false});         \n" +
            // "formActionType.updateSchema({field:'mesQlIncheckdata2List',ifShow:true});      \n" +
            // '}                                                                       \n',
            "if(formModel.reportType=='1'){//1按单2-按物料                           \n" +
            "formActionType.updateSchema({field:'mesQlIncheckdataList',column:{dataIndex:'checkType',show:true}});         \n" +
            "formActionType.updateSchema({field:'mesQlIncheckdataList',column:{dataIndex:'checkProduct',show:true}});      \n" +
            "formActionType.updateSchema({field:'mesQlIncheckdataList',column:{dataIndex:'checkStandard',show:true}});     \n" +
            "formActionType.updateSchema({field:'mesQlIncheckdataList',column:{dataIndex:'checkMethod',show:true}});       \n" +
            "formActionType.updateSchema({field:'mesQlIncheckdataList',column:{dataIndex:'materialId',show:false}});        \n" +
            "formActionType.updateSchema({field:'mesQlIncheckdataList',column:{dataIndex:'materialName',show:false}});      \n" +
            '}                                                                       \n' +
            "if(formModel.reportType=='2'){                                          \n" +
            "formActionType.updateSchema({field:'mesQlIncheckdataList',column:{dataIndex:'checkType',show:false}});         \n" +
            "formActionType.updateSchema({field:'mesQlIncheckdataList',column:{dataIndex:'checkProduct',show:false}});      \n" +
            "formActionType.updateSchema({field:'mesQlIncheckdataList',column:{dataIndex:'checkStandard',show:false}});     \n" +
            "formActionType.updateSchema({field:'mesQlIncheckdataList',column:{dataIndex:'checkMethod',show:false}});       \n" +
            "formActionType.updateSchema({field:'mesQlIncheckdataList',column:{dataIndex:'materialId',show:true}});        \n" +
            "formActionType.updateSchema({field:'mesQlIncheckdataList',column:{dataIndex:'materialName',show:true}});      \n" +
            '}                                                                       \n',
        },
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: 'e3034eec7fec40f48967f8459b45fb02',
      field: 'createUserId',
      label: '创建人',
      type: 'info',
      component: 'Info',
      colProps: { span: 12 },
      ifShow: false,
      componentProps: {
        col: 12,
        showLabel: true,
        infoType: 0,
        width: '100%',
        disabled: true,
        placeholder: '',
        loadAgain: false,
        style: { width: '100%' },
      },
    },
    {
      key: 'be92f7030f214b66aea1e7616dd52790',
      field: 'createDate',
      label: '报告生成日期',
      type: 'info',
      component: 'Info',
      colProps: { span: 12 },
      ifShow: false,
      componentProps: {
        col: 12,
        showLabel: true,
        infoType: 2,
        width: '100%',
        disabled: true,
        placeholder: '',
        loadAgain: false,
        style: { width: '100%' },
      },
    },
    {
      key: '6670d4f80efb4c37ac4b76bccea3fb5b',
      field: '',
      label: '标题',
      type: 'title',
      component: 'Title',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '检测数据',
      componentProps: {
        color: '',
        defaultValue: '检测数据',
        align: 'left',
        fontSize: 15,
        style: {},
      },
    },
    {
      key: 'f159683530b94b0da526da91fc8fa3e7',
      field: 'samplingStandard',
      label: '抽样标准',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 24 },
      ifShow: true,
      componentProps: {
        clearable: false,
        defaultSelect: '',
        rules: [],
        valueField: 'value',
        showLabel: true,
        required: false,
        labelField: 'label',
        datasourceType: 'api',
        itemId: '1687016394928754690',
        dicOptions: [],
        showSearch: false,
        width: '100%',
        apiConfig: {
          method: 'GET',
          script:
            'var condition="";\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(name) AS label FROM mes_qb_checkstandard where state=1 "+condition)',
          apiParams: [
            { tableInfo: [], title: 'Query Params', key: '1' },
            { tableInfo: [], title: 'Header', key: '2' },
            { title: 'Body', key: '3' },
          ],
          path: '/mes/getCheckStandard',
          apiId: '6967f0799cec4087bbfacae79faa0606',
        },
        disabled: false,
        placeholder: '请选择抽样标准',
        staticOptions: [
          { label: 'Option 1', value: 'Option 1', key: 1 },
          { label: 'Option 2', value: 'Option 2', key: 2 },
          { label: 'Option 3', value: 'Option 3', key: 3 },
        ],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: 'b0c95cc497ce47a4bc867e74d79e871b',
      field: 'sendCount',
      label: '送货数',
      type: 'number',
      component: 'InputNumber',
      colProps: { span: 12 },
      ifShow: true,
      componentProps: {
        col: 12,
        controls: true,
        //max: 100,
        rules: [],
        subTotal: false,
        showLabel: true,
        required: false,
        min: 0,
        width: '100%',
        step: 1,
        disabled: false,
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: '754f0b70872a4bba8affab1e76ba4490',
      field: 'sampCount',
      label: '抽样数',
      type: 'number',
      component: 'InputNumber',
      colProps: { span: 12 },
      ifShow: true,
      componentProps: {
        col: 12,
        controls: true,
        //max: 100
        rules: [],
        subTotal: false,
        showLabel: true,
        required: false,
        min: 0,
        width: '100%',
        step: 1,
        disabled: false,
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: '1e7776fb21dd4253a1ceffd9f2e41495',
      label: '',
      field: 'mesQlIncheckdataList',
      type: 'form',
      component: 'SubForm',
      required: true,
      ifShow: true,
      colProps: { span: 24 },
      componentProps: {
        mainKey: 'mesQlIncheckdataList',
        columns: [
          {
            key: 'd611f5267c4d4914ad4af9426bca4068',
            title: '检测类别',
            dataIndex: 'checkType',
            componentType: 'XjrSelect',
            componentProps: {
              mode: 'multiple', //多选
              clearable: false,
              defaultSelect: '',
              rules: [],
              valueField: 'value',
              showLabel: true,
              required: false,
              labelField: 'label',
              datasourceType: 'api',
              dicOptions: [],
              showSearch: false,
              width: '100%',
              apiConfig: {
                method: 'GET',
                script:
                  'var condition="";\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(code,\'-\',name) AS label FROM mes_qb_checktype where state=1 "+condition)',
                apiParams: [
                  { tableInfo: [], title: 'Query Params', key: '1' },
                  { tableInfo: [], title: 'Header', key: '2' },
                  { title: 'Body', key: '3' },
                ],
                path: '/mes/getCheckType',
                apiId: '7142de95ccfe43cb8beffe37a62474d2',
              },
              disabled: false,
              placeholder: '请选择检测类别',
              staticOptions: [
                { label: 'Option 1', value: 'Option 1', key: 1 },
                { label: 'Option 2', value: 'Option 2', key: 2 },
                { label: 'Option 3', value: 'Option 3', key: 3 },
              ],
              events: {},
              span: '',
            },
          },
          {
            key: 'dc29488a10d649cca821ce6626628fb3',
            title: '检测项目',
            dataIndex: 'checkProduct',
            componentType: 'XjrSelect',
            componentProps: {
              mode: 'multiple', //多选
              clearable: false,
              defaultSelect: '',
              rules: [],
              valueField: 'value',
              showLabel: true,
              required: false,
              labelField: 'label',
              datasourceType: 'api',
              dicOptions: [],
              showSearch: false,
              width: '100%',
              apiConfig: {
                method: 'GET',
                script:
                  'var condition="";\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(code,\'-\',name) AS label FROM mes_qb_checkproduct where state=1 "+condition)',
                apiParams: [
                  { tableInfo: [], title: 'Query Params', key: '1' },
                  { tableInfo: [], title: 'Header', key: '2' },
                  { title: 'Body', key: '3' },
                ],
                path: '/mes/getCheckProduct',
                apiId: '662ac83978054327a0947126993b1175',
              },
              disabled: false,
              placeholder: '请选择',
              staticOptions: [
                { label: 'Option 1', value: 'Option 1', key: 1 },
                { label: 'Option 2', value: 'Option 2', key: 2 },
                { label: 'Option 3', value: 'Option 3', key: 3 },
              ],
              events: {},
              span: '',
            },
          },
          {
            key: '78141813d32a4e88b685a1d9fa4478ab',
            title: '检验标准',
            dataIndex: 'checkStandard',
            componentType: 'XjrSelect',
            componentProps: {
              mode: 'multiple', //多选
              clearable: false,
              defaultSelect: '',
              rules: [],
              valueField: 'value',
              showLabel: true,
              required: false,
              labelField: 'label',
              datasourceType: 'api',
              dicOptions: [],
              showSearch: false,
              width: '100%',
              apiConfig: {
                method: 'GET',
                script:
                  'var condition="";\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(code,\'-\',name) AS label FROM mes_qb_checkstandard where state=1 "+condition)',
                apiParams: [
                  { tableInfo: [], title: 'Query Params', key: '1' },
                  { tableInfo: [], title: 'Header', key: '2' },
                  { title: 'Body', key: '3' },
                ],
                path: '/mes/getCheckStandard',
                apiId: '6967f0799cec4087bbfacae79faa0606',
              },
              disabled: false,
              placeholder: '请选择检验标准',
              staticOptions: [
                { label: 'Option 1', value: 'Option 1', key: 1 },
                { label: 'Option 2', value: 'Option 2', key: 2 },
                { label: 'Option 3', value: 'Option 3', key: 3 },
              ],
              events: {},
              span: '',
            },
          },
          {
            key: '01f60f941b424b5ba89962f5789b6777',
            title: '检验方法',
            dataIndex: 'checkMethod',
            componentType: 'XjrSelect',
            componentProps: {
              mode: 'multiple', //多选
              clearable: false,
              defaultSelect: '',
              rules: [],
              valueField: 'value',
              showLabel: true,
              required: false,
              labelField: 'label',
              datasourceType: 'api',
              dicOptions: [],
              showSearch: false,
              width: '100%',
              apiConfig: {
                method: 'GET',
                script:
                  'var condition="";\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(code,\'-\',name) AS label FROM mes_qb_checkmethod where state=1 "+condition)',
                apiParams: [
                  { tableInfo: [], title: 'Query Params', key: '1' },
                  { tableInfo: [], title: 'Header', key: '2' },
                  { title: 'Body', key: '3' },
                ],
                path: '/mes/getCheckmethod',
                apiId: 'c84aa22dc1f946c284b716bdfaf0b6f1',
              },
              disabled: false,
              placeholder: '请选择检验方法',
              staticOptions: [
                { label: 'Option 1', value: 'Option 1', key: 1 },
                { label: 'Option 2', value: 'Option 2', key: 2 },
                { label: 'Option 3', value: 'Option 3', key: 3 },
              ],
              events: {},
              span: '',
            },
          },
          {
            key: 'e3d352f6f9ad47bb9f4b7462a4c708b8',
            title: '物料编号',
            dataIndex: 'materialId',
            componentType: 'MultiplePopup',
            show: false,
            componentProps: {
              popupType: 'associate',
              rules: [],
              valueField: 'value',
              showLabel: true,
              required: false,
              labelField: 'label',
              datasourceType: 'api',
              dicOptions: [],
              width: '100%',
              apiConfig: {
                method: 'GET',
                script:
                  'var condition="";\r\nif(showLabel!=null&&showLabel=="code"){ \r\n    return db.select(\r\n    "SELECT t.id AS `key` ,t.id AS `value`,t.code AS label,t.*,c.type_name,p.property_name FROM case_erp_material t"\r\n    +"  LEFT JOIN case_erp_material_classes c ON c.id=t.classes_id "\r\n    +"LEFT JOIN case_erp_material_property p ON p.id=t.property_id "\r\n    +" WHERE t.state=1  "+condition)\r\n}else{\r\n    return db.select(\r\n    "SELECT t.id AS `key` ,t.id AS `value`,t.NAME AS label,t.*,c.type_name,p.property_name FROM case_erp_material t"\r\n    +"  LEFT JOIN case_erp_material_classes c ON c.id=t.classes_id "\r\n    +"LEFT JOIN case_erp_material_property p ON p.id=t.property_id "\r\n    +" WHERE t.state=1  "+condition)\r\n}\r\n',
                apiParams: [
                  {
                    tableInfo: [
                      { dataType: 'String', bindType: '', required: false, name: 'keyword' },
                      {
                        defaultValue: 'name',
                        bindType: 'value',
                        description: '回显字段：code/name',
                        required: false,
                        name: 'showLabel',
                        value: 'code',
                      },
                    ],
                    title: 'Query Params',
                    key: '1',
                  },
                  { tableInfo: [], title: 'Header', key: '2' },
                  { title: 'Body', key: '3' },
                ],
                path: '/mes/getMaterialList',
                outputParams: [
                  {
                    show: true,
                    bindField: 'material_no',
                    name: 'code',
                    width: 150,
                    tableTitle: '物料编码',
                  },
                  {
                    show: true,
                    bindField: 'material_name',
                    name: 'name',
                    width: 150,
                    tableTitle: '物料名称',
                  },
                  {
                    show: true,
                    bindField: '',
                    name: 'property_name',
                    width: 150,
                    tableTitle: '物料属性',
                  },
                  {
                    show: true,
                    bindField: '',
                    name: 'type_name',
                    width: 150,
                    tableTitle: '物料类别',
                  },
                ],
                apiId: '87c017a4baba48909380e9ca3e38359d',
              },
              disabled: false,
              placeholder: '请选择物料编号',
              events: {},
              span: '',
            },
          },
          {
            key: 'cfb0a63929614b21b390d4af63b79365',
            title: '物料编号-隐藏',
            dataIndex: 'materialNo',
            componentType: 'Input',
            defaultValue: '',
            show: false,
            componentProps: {
              defaultValue: '',
              prefix: '',
              rules: [],
              suffix: '',
              addonAfter: '',
              showLabel: true,
              required: false,
              width: '100%',
              disabled: false,
              placeholder: '请输入物料编号',
              allowClear: false,
              addonBefore: '',
              events: {},
              span: '',
            },
          },
          {
            key: '3178e0e138214161991a0f0878f0883d',
            title: '物料名称',
            dataIndex: 'materialName',
            componentType: 'Input',
            defaultValue: '',
            show: false,
            componentProps: {
              defaultValue: '',
              prefix: '',
              rules: [],
              suffix: '',
              addonAfter: '',
              showLabel: true,
              required: false,
              width: '100%',
              disabled: false,
              placeholder: '请输入物料名称',
              allowClear: false,
              addonBefore: '',
              events: {},
              span: '',
            },
          },
          {
            key: 'a47c7099c06a45b5a9ac903d181235b7',
            title: '送货数',
            dataIndex: 'sendGoodNum',
            componentType: 'InputNumber',
            componentProps: {
              placeholder: '请输入',
              controls: true,
              //max: 100,
              rules: [],
              subTotal: false,
              showLabel: true,
              required: false,
              min: 0,
              width: '100%',
              step: 1,
              disabled: false,
              events: {},
              span: '',
            },
          },
          {
            key: '8e4d7ce05b124be1a44133e02bb2d17d',
            title: '抽样数',
            dataIndex: 'samplingNum',
            componentType: 'InputNumber',
            componentProps: {
              placeholder: '请输入',
              controls: true,
              //max: 100
              rules: [],
              subTotal: false,
              showLabel: true,
              required: false,
              min: 0,
              width: '100%',
              step: 1,
              disabled: false,
              events: {},
              span: '',
            },
          },
          {
            key: '30a628cffbaa44129de72c6fb39f2658',
            title: '基准值',
            dataIndex: 'referenceValue',
            componentType: 'InputNumber',
            componentProps: {
              placeholder: '请输入',
              controls: true,
              //max: 100,
              rules: [],
              subTotal: false,
              showLabel: true,
              required: false,
              min: 0,
              width: '100%',
              step: 1,
              disabled: false,
              events: {},
              span: '',
            },
          },
          {
            key: '044b7fcda71740e4b43e4d0dd93f6cbb',
            title: '上公差',
            dataIndex: 'upTolerance',
            componentType: 'InputNumber',
            componentProps: {
              placeholder: '请输入',
              controls: true,
              //max: 100,
              rules: [],
              subTotal: false,
              showLabel: true,
              required: false,
              min: 0,
              width: '100%',
              step: 1,
              disabled: false,
              events: {},
              span: '',
            },
          },
          {
            key: 'e624df8ee19d401581dc790092707995',
            title: '下公差',
            dataIndex: 'downTolerance',
            componentType: 'InputNumber',
            componentProps: {
              placeholder: '请输入',
              controls: true,
              //max: 100,
              rules: [],
              subTotal: false,
              showLabel: true,
              required: false,
              min: 0,
              width: '100%',
              step: 1,
              disabled: false,
              events: {},
              span: '',
            },
          },
          {
            key: 'f348d3a418994ab8982af2e0a7179b0c',
            title: '测量值',
            dataIndex: 'measuredValue',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              defaultValue: '',
              prefix: '',
              rules: [],
              suffix: '',
              addonAfter: '',
              showLabel: true,
              required: false,
              width: '100%',
              disabled: false,
              placeholder: '多个测量值用,隔开',
              allowClear: false,
              addonBefore: '',
              events: {},
              span: '',
            },
          },
          {
            key: '38f395e2ce2a4080b45eae56ad42490f',
            title: '备注',
            dataIndex: 'remark',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              defaultValue: '',
              prefix: '',
              rules: [],
              suffix: '',
              addonAfter: '',
              showLabel: true,
              required: false,
              width: '100%',
              disabled: false,
              placeholder: '请输入备注',
              allowClear: false,
              addonBefore: '',
              events: {},
              span: '',
            },
          },
          {
            key: '0e4359fe0e094955b9b05648bfbc8699',
            title: '判定',
            dataIndex: 'judgeResult',
            componentType: 'ApiRadioGroup',
            componentProps: {
              defaultSelect: '1',
              rules: [],
              valueField: 'value',
              showLabel: true,
              required: false,
              labelField: 'label',
              optionType: 'default',
              datasourceType: 'staticData',
              dicOptions: [],
              apiConfig: {},
              disabled: false,
              staticOptions: [
                { label: '合格', value: '1', key: 1 },
                { label: '不合格', value: '2', key: 2 },
              ],
              events: {},
              span: '',
            },
          },
          {
            key: '1395b1af977a4b3ba1f2dca17c13ddc6',
            dataIndex: 'imgFile',
            title: '上传',
            componentType: 'Upload',
            componentProps: {
              api: uploadApi,
              defaultValue: [],
              multiple: false,
              maxSize: 5,
              showLabel: true,
              required: false,
              accept: '',
              maxNumber: 5,
              disabled: false,
              events: {},
              span: '',
            },
          },
          { title: '操作', key: 'action', fixed: 'right', width: '50px' },
        ],
        buttonName: '选择数据',
        showIndex: true,
        useSelectButton: false,
        useCopyButton: true,
        useResetButton: true,
        preloadType: 'api',
        showLabel: true,
        itemId: '',
        multipleHeads: [],
        dicOptions: [],
        showComponentBorder: true,
        apiConfig: {},
        showFormBorder: true,
        span: '24',
      },
    },

    {
      key: '1e7776fb21dd4253a1ceffd9f2e414951',
      label: '',
      field: 'mesQlIncheckdata2List',
      type: 'form',
      component: 'SubForm',
      required: true,
      ifShow: false,
      colProps: { span: 24 },
      componentProps: {
        mainKey: 'mesQlIncheckdataList2',
        columns: [
          {
            key: 'e3d352f6f9ad47bb9f4b7462a4c708b8',
            title: '物料编号',
            dataIndex: 'materialId',
            componentType: 'MultiplePopup',
            componentProps: {
              popupType: 'associate',
              rules: [],
              valueField: 'value',
              showLabel: true,
              required: false,
              labelField: 'label',
              datasourceType: 'api',
              dicOptions: [],
              width: '100%',
              apiConfig: {
                method: 'GET',
                script:
                  'var condition="";\r\nif(showLabel!=null&&showLabel=="code"){ \r\n    return db.select(\r\n    "SELECT t.id AS `key` ,t.id AS `value`,t.code AS label,t.*,c.type_name,p.property_name FROM case_erp_material t"\r\n    +"  LEFT JOIN case_erp_material_classes c ON c.id=t.classes_id "\r\n    +"LEFT JOIN case_erp_material_property p ON p.id=t.property_id "\r\n    +" WHERE t.state=1  "+condition)\r\n}else{\r\n    return db.select(\r\n    "SELECT t.id AS `key` ,t.id AS `value`,t.NAME AS label,t.*,c.type_name,p.property_name FROM case_erp_material t"\r\n    +"  LEFT JOIN case_erp_material_classes c ON c.id=t.classes_id "\r\n    +"LEFT JOIN case_erp_material_property p ON p.id=t.property_id "\r\n    +" WHERE t.state=1  "+condition)\r\n}\r\n',
                apiParams: [
                  {
                    tableInfo: [
                      { dataType: 'String', bindType: '', required: false, name: 'keyword' },
                      {
                        defaultValue: 'name',
                        bindType: 'value',
                        description: '回显字段：code/name',
                        required: false,
                        name: 'showLabel',
                        value: 'code',
                      },
                    ],
                    title: 'Query Params',
                    key: '1',
                  },
                  { tableInfo: [], title: 'Header', key: '2' },
                  { title: 'Body', key: '3' },
                ],
                path: '/mes/getMaterialList',
                outputParams: [
                  {
                    show: true,
                    bindField: 'material_no',
                    name: 'code',
                    width: 150,
                    tableTitle: '物料编码',
                  },
                  {
                    show: true,
                    bindField: 'material_name',
                    name: 'name',
                    width: 150,
                    tableTitle: '物料名称',
                  },
                  {
                    show: true,
                    bindField: '',
                    name: 'property_name',
                    width: 150,
                    tableTitle: '物料属性',
                  },
                  {
                    show: true,
                    bindField: '',
                    name: 'type_name',
                    width: 150,
                    tableTitle: '物料类别',
                  },
                ],
                apiId: '87c017a4baba48909380e9ca3e38359d',
              },
              disabled: false,
              placeholder: '请选择物料编号',
              events: {},
              span: '',
            },
          },
          {
            key: 'cfb0a63929614b21b390d4af63b79365',
            title: '物料编号-隐藏',
            dataIndex: 'materialNo',
            componentType: 'Input',
            defaultValue: '',
            show: false,
            componentProps: {
              defaultValue: '',
              prefix: '',
              rules: [],
              suffix: '',
              addonAfter: '',
              showLabel: true,
              required: false,
              width: '100%',
              disabled: false,
              placeholder: '请输入物料编号',
              allowClear: false,
              addonBefore: '',
              events: {},
              span: '',
            },
          },
          {
            key: '3178e0e138214161991a0f0878f0883d',
            title: '物料名称',
            dataIndex: 'materialName',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              defaultValue: '',
              prefix: '',
              rules: [],
              suffix: '',
              addonAfter: '',
              showLabel: true,
              required: false,
              width: '100%',
              disabled: false,
              placeholder: '请输入物料名称',
              allowClear: false,
              addonBefore: '',
              events: {},
              span: '',
            },
          },
          {
            key: 'a47c7099c06a45b5a9ac903d181235b7',
            title: '送货数',
            dataIndex: 'sendGoodNum',
            componentType: 'InputNumber',
            componentProps: {
              controls: true,
              //max: 100,
              rules: [],
              subTotal: false,
              showLabel: true,
              required: false,
              min: 0,
              width: '100%',
              step: 1,
              disabled: false,
              events: {},
              span: '',
            },
          },
          {
            key: '8e4d7ce05b124be1a44133e02bb2d17d',
            title: '抽样数',
            dataIndex: 'samplingNum',
            componentType: 'InputNumber',
            componentProps: {
              controls: true,
              //max: 100
              rules: [],
              subTotal: false,
              showLabel: true,
              required: false,
              min: 0,
              width: '100%',
              step: 1,
              disabled: false,
              events: {},
              span: '',
            },
          },
          {
            key: '30a628cffbaa44129de72c6fb39f2658',
            title: '基准值',
            dataIndex: 'referenceValue',
            componentType: 'InputNumber',
            componentProps: {
              controls: true,
              //max: 100,
              rules: [],
              subTotal: false,
              showLabel: true,
              required: false,
              min: 0,
              width: '100%',
              step: 1,
              disabled: false,
              events: {},
              span: '',
            },
          },
          {
            key: '044b7fcda71740e4b43e4d0dd93f6cbb',
            title: '上公差',
            dataIndex: 'upTolerance',
            componentType: 'InputNumber',
            componentProps: {
              controls: true,
              //max: 100,
              rules: [],
              subTotal: false,
              showLabel: true,
              required: false,
              min: 0,
              width: '100%',
              step: 1,
              disabled: false,
              events: {},
              span: '',
            },
          },
          {
            key: 'e624df8ee19d401581dc790092707995',
            title: '下公差',
            dataIndex: 'downTolerance',
            componentType: 'InputNumber',
            componentProps: {
              controls: true,
              //max: 100,
              rules: [],
              subTotal: false,
              showLabel: true,
              required: false,
              min: 0,
              width: '100%',
              step: 1,
              disabled: false,
              events: {},
              span: '',
            },
          },
          {
            key: 'f348d3a418994ab8982af2e0a7179b0c',
            title: '测量值',
            dataIndex: 'measuredValue',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              defaultValue: '',
              prefix: '',
              rules: [],
              suffix: '',
              addonAfter: '',
              showLabel: true,
              required: false,
              width: '100%',
              disabled: false,
              placeholder: '请输入测量值',
              allowClear: false,
              addonBefore: '',
              events: {},
              span: '',
            },
          },
          {
            key: '38f395e2ce2a4080b45eae56ad42490f',
            title: '备注',
            dataIndex: 'remark',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              defaultValue: '',
              prefix: '',
              rules: [],
              suffix: '',
              addonAfter: '',
              showLabel: true,
              required: false,
              width: '100%',
              disabled: false,
              placeholder: '请输入备注',
              allowClear: false,
              addonBefore: '',
              events: {},
              span: '',
            },
          },
          {
            key: '0e4359fe0e094955b9b05648bfbc8699',
            title: '判定',
            dataIndex: 'judgeResult',
            componentType: 'ApiRadioGroup',
            componentProps: {
              defaultSelect: '1',
              rules: [],
              valueField: 'value',
              showLabel: true,
              required: false,
              labelField: 'label',
              optionType: 'default',
              datasourceType: 'staticData',
              dicOptions: [],
              apiConfig: {},
              disabled: false,
              staticOptions: [
                { label: '合格', value: '1', key: 1 },
                { label: '不合格', value: '2', key: 2 },
              ],
              events: {},
              span: '',
            },
          },
          {
            key: '1395b1af977a4b3ba1f2dca17c13ddc6',
            dataIndex: 'imgFile',
            title: '上传',
            componentType: 'Upload',
            componentProps: {
              api: uploadApi,
              defaultValue: [],
              multiple: false,
              maxSize: 5,
              showLabel: true,
              required: false,
              accept: '',
              maxNumber: 5,
              disabled: false,
              events: {},
              span: '',
            },
          },
          { title: '操作', key: 'action', fixed: 'right', width: '50px' },
        ],
        buttonName: '选择数据',
        showIndex: true,
        useSelectButton: false,
        preloadType: 'api',
        showLabel: true,
        itemId: '',
        multipleHeads: [],
        dicOptions: [],
        showComponentBorder: true,
        apiConfig: {},
        showFormBorder: true,
        span: '24',
      },
    },
    {
      key: '5e1afb160a374e5a8a391b0c0d055914',
      field: 'checkreportNo',
      label: '检测报告编号',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        defaultValue: '',
        prefix: '',
        rules: [],
        suffix: '',
        addonAfter: '',
        showLabel: true,
        required: false,
        width: '100%',
        disabled: false,
        placeholder: '检测报告编号请输入',
        allowClear: false,
        addonBefore: '',
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '17dc8a1665944b92aeec505dff9234a4',
      field: '',
      label: '标题',
      type: 'title',
      component: 'Title',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '检测结果',
      componentProps: {
        color: '',
        defaultValue: '检测结果',
        align: 'left',
        fontSize: 15,
        style: {},
      },
    },
    {
      key: '0ea4188a4e3d4d1c95e6498ae1d10127',
      field: 'judgeResult',
      label: '整体判定',
      type: 'radio',
      component: 'ApiRadioGroup',
      colProps: { span: 22 },
      ifShow: true,
      componentProps: {
        defaultSelect: '',
        rules: [],
        valueField: 'value',
        showLabel: true,
        required: false,
        labelField: 'label',
        optionType: 'default',
        datasourceType: 'staticData',
        dicOptions: [],
        apiConfig: {},
        disabled: false,
        staticOptions: [
          { label: '合格', value: '1', key: 1 },
          { label: '不合格', value: '2', key: 2 },
        ],
        events: {},
        span: '',
        style: {},
      },
    },
    {
      key: 'resetBtn1',
      field: '',
      label: '按钮组件',
      type: 'button',
      component: 'Button',
      colProps: { span: 2 },
      componentProps: {
        name: '重置',
        buttonWidth: '',
        buttonHeight: '',
        prefix: '',
        suffix: '',
        disabled: false,
        events: { click: "formModel.judgeResult='';" },
        width: '',
        height: '',
      },
    },
    {
      key: '61fa93f650bd41af9ad1c0da1fa5c2dd',
      field: 'goodDisMethod',
      label: '货物处置方式',
      type: 'checkbox',
      component: 'ApiCheckboxGroup',
      colProps: { span: 22 },
      ifShow: true,
      componentProps: {
        defaultSelect: '',
        rules: [],
        valueField: 'value',
        showLabel: true,
        required: false,
        labelField: 'label',
        datasourceType: 'staticData',
        dicOptions: [],
        apiConfig: {},
        disabled: false,
        staticOptions: [
          { label: '接收', value: '1', key: 1 },
          { label: '采纳', value: '3', key: 3 },
          { label: '不良退货', value: '4', key: 4 },
          { label: '换货', value: '5', key: 5 },
          { label: '其他', value: '0', key: 6 },
        ],
        events: {},
        span: '',
        style: {},
      },
    },
    {
      key: 'resetBtn1',
      field: '',
      label: '按钮组件',
      type: 'button',
      component: 'Button',
      colProps: { span: 2 },
      componentProps: {
        name: '重置',
        buttonWidth: '',
        buttonHeight: '',
        prefix: '',
        suffix: '',
        disabled: false,
        events: { click: "formModel.goodDisMethod='';" },
        width: '',
        height: '',
      },
    },
    {
      key: '5e8cbb4d3b76447a9df98987ada7cdf1',
      field: 'remark',
      label: '备注',
      type: 'textarea',
      component: 'InputTextArea',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        defaultValue: '',
        rules: [],
        rows: 4,
        showLabel: true,
        required: false,
        autoSize: false,
        showCount: false,
        width: '100%',
        disabled: false,
        placeholder: '请输入备注',
        allowClear: false,
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};
