import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';
import { uploadApi } from '/@/api/sys/upload';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'code',
    label: '标准编码',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'name',
    label: '标准名称',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'templateState',
    label: '标准状态',
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'dic',
      params: { itemId: '1685894306067148802' },
      labelField: 'name',
      valueField: 'value',

      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },
  {
    field: 'publishDate',
    label: '发布日期',
    component: 'RangePicker',
    componentProps: {
      format: 'YYYY-MM-DD',
      style: { width: '100%' },
      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },

  {
    field: 'executeDate',
    label: '实施日期',
    component: 'RangePicker',
    componentProps: {
      format: 'YYYY-MM-DD',
      style: { width: '100%' },
      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },

  {
    field: 'state',
    label: '是否启用',
    component: 'Select',
    componentProps: {
      getPopupContainer: () => document.body,
      options: [
        {
          label: '开',
          value: 1,
        },
        {
          label: '关',
          value: 0,
        },
      ],
    },
    colProps: { span: 8 },
  },
];

export const columns: BasicColumn[] = [
  {
    dataIndex: 'code',
    title: '标准编码',
    componentType: 'auto-code',

    sorter: true,
  },

  {
    dataIndex: 'name',
    title: '标准名称',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'templateState',
    title: '标准状态',
    componentType: 'select',

    sorter: true,
  },

  {
    dataIndex: 'publishDate',
    title: '发布日期',
    componentType: 'date',

    sorter: true,
  },

  {
    dataIndex: 'executeDate',
    title: '实施日期',
    componentType: 'date',

    sorter: true,
  },

  {
    dataIndex: 'state',
    title: '是否启用',
    componentType: 'switch',

    sorter: true,
  },

  {
    dataIndex: 'createUserId',
    title: '创建人',
    componentType: 'info',

    sorter: true,
  },

  {
    dataIndex: 'createDate',
    title: '创建时间',
    componentType: 'info',

    sorter: true,
  },

  {
    dataIndex: 'remark',
    title: '备注',
    componentType: 'textarea',

    sorter: true,
  },
];

export const formProps: FormProps = {
  labelWidth: '100px',
  labelAlign: 'right',
  layout: 'horizontal',
  size: 'default',
  schemas: [
    {
      key: 'd0e73e8d41314909b569b3d2d4856f96',
      field: 'code',
      label: '标准编码',
      type: 'auto-code',
      component: 'AutoCodeRule',
      colProps: { span: 20 },
      ifShow: true,
      componentProps: {
        col: 20,
        prefix: '',
        suffix: '',
        addonAfter: '',
        showLabel: true,
        required: true,
        width: '100%',
        placeholder: '请输入标准编码',
        addonBefore: '',
        autoCodeRule: 'mescheckstandardNo',
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '6e8b5ad87e0c41b39a112b888f947826',
      field: 'isSysNum',
      label: '',
      type: 'checkbox',
      component: 'ApiCheckboxGroup',
      colProps: { span: 4 },
      ifShow: true,
      componentProps: {
        col: 4,
        defaultSelect: '1',
        rules: [],
        valueField: 'value',
        showLabel: false,
        required: false,
        labelField: 'label',
        datasourceType: 'staticData',
        dicOptions: [],
        apiConfig: {},
        disabled: false,
        staticOptions: [{ label: '用系统编码', value: '1', key: 1 }],
        events: {
          change:
            "const code='code';//编码字段名\nif(formModel.isSysNum==1){\n\tformModel[code]=formModel.codeTemp; formActionType.updateSchema({field:code,componentProps: {readonly:true}});\n}else{\n  formModel.codeTemp=formModel[code];\n  formModel[code]='';\nformActionType.updateSchema({field:code,componentProps: {readonly:false}});\n}",
        },
        span: '',
        style: {},
      },
    },
    {
      key: '75412322ac864c3c833a03cdb42372e7',
      field: 'name',
      label: '标准名称',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        defaultValue: '',
        prefix: '',
        rules: [],
        suffix: '',
        addonAfter: '',
        showLabel: true,
        required: true,
        width: '100%',
        disabled: false,
        placeholder: '请输入标准名称',
        allowClear: false,
        addonBefore: '',
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: '4eade8313ba64df697bed70206698bef',
      field: 'templateState',
      label: '标准状态',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 24 },
      ifShow: true,
      componentProps: {
        clearable: false,
        defaultSelect: '',
        rules: [],
        params: { itemId: '1685894306067148802' },
        valueField: 'value',
        showLabel: true,
        required: false,
        labelField: 'name',
        datasourceType: 'dic',
        itemId: '1685894306067148802',
        dicOptions: [],
        showSearch: false,
        width: '100%',
        apiConfig: {},
        disabled: false,
        placeholder: '请选择标准状态',
        staticOptions: [
          { label: 'Option 1', value: 'Option 1', key: 1 },
          { label: 'Option 2', value: 'Option 2', key: 2 },
          { label: 'Option 3', value: 'Option 3', key: 3 },
        ],
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '30d69e8667244815a2afeed6d16908cb',
      field: 'publishDate',
      label: '发布日期',
      type: 'date',
      component: 'DatePicker',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        defaultValue: '',
        format: 'YYYY-MM-DD',
        rules: [],
        showLabel: true,
        required: false,
        width: '100%',
        disabled: false,
        placeholder: '请选择发布日期',
        allowClear: true,
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '8b30277b5f454053b78db1e3f449ba96',
      field: 'executeDate',
      label: '实施日期',
      type: 'date',
      component: 'DatePicker',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        defaultValue: '',
        format: 'YYYY-MM-DD',
        rules: [],
        showLabel: true,
        required: false,
        width: '100%',
        disabled: false,
        placeholder: '请选择实施日期',
        allowClear: true,
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: 'a6a28c51c94849b8b1937450838b44a1',
      field: 'state',
      label: '是否启用',
      type: 'switch',
      component: 'Switch',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: 1,
      componentProps: {
        defaultValue: 1,
        unCheckedChildren: '',
        unCheckedColor: '#bbbdbf',
        checkedChildren: '',
        showLabel: true,
        checkedColor: '#5e95ff',
        disabled: false,
        events: {},
        span: '',
        style: {},
      },
    },
    {
      key: '8c115c45ee8e40afad7f17f0b7e2b89a',
      field: 'remark',
      label: '备注',
      type: 'textarea',
      component: 'InputTextArea',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        defaultValue: '',
        rules: [],
        rows: 4,
        showLabel: true,
        required: false,
        autoSize: false,
        showCount: false,
        width: '100%',
        disabled: false,
        placeholder: '请输入备注',
        allowClear: false,
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: 'a0650101dc6e4a7cb9676256279e8f8d',
      field: 'imgFiles',
      label: '图纸/附件',
      type: 'upload',
      component: 'Upload',
      colProps: { span: 24 },
      componentProps: {
        api: uploadApi,
        defaultValue: [],
        multiple: true,
        maxSize: 5,
        showLabel: true,
        required: false,
        accept: '',
        maxNumber: 5,
        disabled: false,
        events: {},
        span: '',
      },
    },
    {
      key: '30bbb3817803411b999ca1cfbf30f36d',
      field: 'createUserId',
      label: '创建人',
      type: 'info',
      component: 'Info',
      colProps: { span: 24 },
      ifShow: true,
      componentProps: {
        showLabel: true,
        infoType: 0,
        width: '100%',
        disabled: true,
        placeholder: '',
        loadAgain: false,
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '79a0f32bb7d140fda5bb2a7e2447adab',
      field: 'createDate',
      label: '创建时间',
      type: 'info',
      component: 'Info',
      colProps: { span: 24 },
      ifShow: true,
      componentProps: {
        showLabel: true,
        infoType: 2,
        width: '100%',
        disabled: true,
        placeholder: '',
        loadAgain: false,
        span: '',
        style: { width: '100%' },
      },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};
