import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';
import { uploadApi } from '/@/api/sys/upload';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'devCode',
    label: '设备编码',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'devName',
    label: '设备名称',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'devType',
    label: '设备类型',
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'api',
      apiConfig: {
        path: '/mes/getDevtypeList',
        method: 'GET',
        apiId: 'copy1690511011986d22891',
        apiParams: [
          { key: '1', title: 'Query Params', tableInfo: [] },
          { key: '2', title: 'Header', tableInfo: [] },
          { key: '3', title: 'Body' },
        ],
        script:
          'var condition="";\r\n// if(data_type!=null&&data_type!=""){ \r\n//     condition+=" and data_type=#{data_type}";\r\n// }\r\n// if(warehouse_id!=null&&warehouse_id!=""){ \r\n//     condition+=" and warehouse_id=#{warehouse_id}";\r\n// }\r\n// if(area_id!=null&&area_id!=""){ \r\n//     condition+=" and area_id=#{area_id}";\r\n// }\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(type_code,\'-\',type_name) AS label FROM mes_dev_type where state=1 "+condition)',
      },
      labelField: 'label',
      valueField: 'value',

      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },
  {
    field: 'lineId',
    label: '所属生产线',
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'api',
      apiConfig: {
        path: '/mes/mesFactory',
        method: 'GET',
        apiId: '6b4b40b3db664831b709f56bc98a7f04',
        apiParams: [
          {
            key: '1',
            title: 'Query Params',
            tableInfo: [
              {
                name: 'factory_type',
                value: '2',
                description: null,
                required: false,
                dataType: 'String',
                type: null,
                defaultValue: null,
                validateType: null,
                error: null,
                expression: null,
                children: null,
                bindType: 'value',
              },
              {
                name: 'factory_id',
                value: '',
                description: null,
                required: false,
                dataType: 'String',
                type: null,
                defaultValue: null,
                validateType: null,
                error: null,
                expression: null,
                children: null,
                bindType: 'value',
              },
              {
                name: 'car_id',
                value: '',
                description: null,
                required: false,
                dataType: 'String',
                type: null,
                defaultValue: null,
                validateType: null,
                error: null,
                expression: null,
                children: null,
                bindType: 'value',
              },
            ],
          },
          { key: '2', title: 'Header', tableInfo: [] },
          { key: '3', title: 'Body' },
        ],
        script:
          'var condition="";\r\nif(factory_type!=null&&factory_type!=""){ \r\n    condition+=" and factory_type=#{factory_type}";\r\n}\r\nif(factory_id!=null&&factory_id!=""){ \r\n    condition+=" and factory_id=#{factory_id}";\r\n}\r\nif(car_id!=null&&car_id!=""){ \r\n    condition+=" and car_id=#{car_id}";\r\n}\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(factory_code,\'-\',factory_name) AS label FROM mes_base_factory where 1=1 "+condition)',
      },
      labelField: 'label',
      valueField: 'value',

      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },
  {
    field: 'stationId',
    label: '所属工位',
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'api',
      apiConfig: {
        path: '/mes/mesFactory',
        method: 'GET',
        apiId: '6b4b40b3db664831b709f56bc98a7f04',
        apiParams: [
          {
            key: '1',
            title: 'Query Params',
            tableInfo: [
              {
                name: 'factory_type',
                value: '3',
                description: null,
                required: false,
                dataType: 'String',
                type: null,
                defaultValue: null,
                validateType: null,
                error: null,
                expression: null,
                children: null,
                bindType: 'value',
              },
              {
                name: 'factory_id',
                value: '',
                description: null,
                required: false,
                dataType: 'String',
                type: null,
                defaultValue: null,
                validateType: null,
                error: null,
                expression: null,
                children: null,
                bindType: 'value',
              },
              {
                name: 'car_id',
                value: '',
                description: null,
                required: false,
                dataType: 'String',
                type: null,
                defaultValue: null,
                validateType: null,
                error: null,
                expression: null,
                children: null,
                bindType: 'value',
              },
              {
                name: 'parent_id',
                value: '',
                description: null,
                required: false,
                dataType: null,
                type: null,
                defaultValue: null,
                validateType: null,
                error: null,
                expression: null,
                children: null,
                bindType: 'value',
              },
            ],
          },
          { key: '2', title: 'Header', tableInfo: [] },
          { key: '3', title: 'Body' },
        ],
        script:
          'var condition="";\r\nif(factory_type!=null&&factory_type!=""){ \r\n    condition+=" and factory_type=#{factory_type}";\r\n}\r\nif(factory_id!=null&&factory_id!=""){ \r\n    condition+=" and factory_id=#{factory_id}";\r\n}\r\nif(car_id!=null&&car_id!=""){ \r\n    condition+=" and car_id=#{car_id}";\r\n}\r\nif(parent_id!=null&&parent_id!=""){ \r\n    condition+=" and parent_id=#{parent_id}";\r\n}\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(factory_code,\'-\',factory_name) AS label FROM mes_base_factory where 1=1 "+condition)',
      },
      labelField: 'label',
      valueField: 'value',

      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },
  {
    field: 'devBrand',
    label: '设备品牌',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'devSupplier',
    label: '供应商',
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'api',
      apiConfig: {
        path: '/mes/getSupplierList',
        method: 'GET',
        apiId: 'copy1690511531075d26035',
        apiParams: [
          { key: '1', title: 'Query Params', tableInfo: [] },
          { key: '2', title: 'Header', tableInfo: [] },
          { key: '3', title: 'Body' },
        ],
        script:
          'var condition="";\r\n// if(data_type!=null&&data_type!=""){ \r\n//     condition+=" and data_type=#{data_type}";\r\n// }\r\n// if(warehouse_id!=null&&warehouse_id!=""){ \r\n//     condition+=" and warehouse_id=#{warehouse_id}";\r\n// }\r\n// if(area_id!=null&&area_id!=""){ \r\n//     condition+=" and area_id=#{area_id}";\r\n// }\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(type_code,\'-\',type_name) AS label FROM mes_dev_type where state=1 "+condition)',
      },
      labelField: 'label',
      valueField: 'value',

      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },
  {
    field: 'devModel',
    label: '设备型号',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'buyDate',
    label: '采购日期',
    component: 'RangePicker',
    componentProps: {
      format: 'YYYY-MM-DD',
      style: { width: '100%' },
      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },

  {
    field: 'maintenanceDate',
    label: '维保到期',
    component: 'RangePicker',
    componentProps: {
      format: 'YYYY-MM-DD',
      style: { width: '100%' },
      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },

  {
    field: 'scrapDate',
    label: '报废日期',
    component: 'RangePicker',
    componentProps: {
      format: 'YYYY-MM-DD',
      style: { width: '100%' },
      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },

  {
    field: 'devManage',
    label: '负责人',
    component: 'User',
    componentProps: {
      suffix: 'ant-design:setting-outlined',
      placeholder: '请选择',
    },
    colProps: { span: 8 },
  },

  {
    field: 'devPhone',
    label: '联系方式',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'remark',
    label: '备注',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'createUserId',
    label: '创建人',
    component: 'User',
    componentProps: {
      suffix: 'ant-design:setting-outlined',
      placeholder: '请选择',
    },
    colProps: { span: 8 },
  },

  {
    field: 'createDate',
    label: '创建时间',
    component: 'User',
    componentProps: {
      suffix: 'ant-design:setting-outlined',
      placeholder: '请选择',
    },
    colProps: { span: 8 },
  },
];

export const columns: BasicColumn[] = [
  {
    dataIndex: 'devCode',
    title: '设备编码',
    componentType: 'auto-code',

    sorter: true,
  },

  {
    dataIndex: 'devName',
    title: '设备名称',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'devFile',
    title: '设备图片',
    slots: { customRender: 'devFile' },
  },

  {
    dataIndex: 'factoryId',
    title: '设备类型',
    componentType: 'select',

    sorter: true,
  },

  {
    dataIndex: 'lineId',
    title: '所属生产线',
    componentType: 'select',

    sorter: true,
  },

  {
    dataIndex: 'stationId',
    title: '所属工位',
    componentType: 'select',

    sorter: true,
  },

  {
    dataIndex: 'devBrand',
    title: '设备品牌',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'devSupplier',
    title: '供应商',
    componentType: 'select',

    sorter: true,
  },

  {
    dataIndex: 'devModel',
    title: '设备型号',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'buyDate',
    title: '采购日期',
    componentType: 'date',

    sorter: true,
  },

  {
    dataIndex: 'maintenanceDate',
    title: '维保到期',
    componentType: 'date',

    sorter: true,
  },

  {
    dataIndex: 'scrapDate',
    title: '报废日期',
    componentType: 'date',

    sorter: true,
  },

  {
    dataIndex: 'devManage',
    title: '负责人',
    componentType: 'user',

    sorter: true,
  },

  {
    dataIndex: 'devPhone',
    title: '联系方式',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'remark',
    title: '备注',
    componentType: 'textarea',

    sorter: true,
  },

  {
    dataIndex: 'createUserId',
    title: '创建人',
    componentType: 'info',

    sorter: true,
  },

  {
    dataIndex: 'createDate',
    title: '创建时间',
    componentType: 'info',

    sorter: true,
  },
];

export const formProps: FormProps = {
  // labelCol: { span: 3, offset: 0 },
  labelWidth: 120,
  labelAlign: 'right',
  layout: 'horizontal',
  size: 'default',
  schemas: [
    {
      key: '02011d440c3d4e409a5041a272abd09e',
      field: '',
      label: '标题',
      type: 'title',
      component: 'Title',
      colProps: { span: 24 },
      defaultValue: '基础信息',
      componentProps: {
        defaultValue: '基础信息',
        color: '',
        align: 'left',
        fontSize: 16,
        style: {},
      },
    },
    {
      key: 'b2ca8251082e4428b30b6c0a340f10cb',
      field: 'devCode',
      label: '设备编码',
      type: 'auto-code',
      component: 'AutoCodeRule',
      colProps: { span: 12 },
      componentProps: {
        width: '100%',
        span: '',
        placeholder: '请输入设备编码',
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        showLabel: true,
        autoCodeRule: 'mesdevCode',
        required: true,
        style: { width: '100%' },
      },
    },
    {
      key: '6cb7245519ad4c528774a387224f57ae',
      field: 'isSysNum',
      label: '多选组件',
      type: 'checkbox',
      component: 'ApiCheckboxGroup',
      colProps: { span: 4 },
      ifShow: true,
      componentProps: {
        col: 4,
        defaultSelect: '1',
        rules: [],
        valueField: 'value',
        showLabel: false,
        required: false,
        labelField: 'label',
        datasourceType: 'staticData',
        dicOptions: [],
        apiConfig: {},
        disabled: false,
        staticOptions: [{ label: '用系统编号', value: '1', key: 1 }],
        events: {
          change:
            "const code='devCode';//编码字段名\nif(formModel.isSysNum==1){\n\tformModel[code]=formModel.codeTemp; formActionType.updateSchema({field:code,componentProps: {readonly:true}});\n}else{\n  formModel.codeTemp=formModel[code];\n  formModel[code]='';\nformActionType.updateSchema({field:code,componentProps: {readonly:false}});\n}",
        },
        style: {},
      },
    },
    {
      key: 'be08e04b5a1a4451868d0da2c38e7373',
      field: 'devName',
      label: '设备名称',
      type: 'input',
      component: 'Input',
      colProps: { span: 12 },
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入设备名称',
        maxlength: 200,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: true,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: 'e9f5cedfbbe94994936946bac1056078',
      field: 'devType',
      label: '设备类型',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 12 },
      componentProps: {
        width: '100%',
        span: '',
        placeholder: '请选择',
        showLabel: true,
        showSearch: false,
        clearable: false,
        disabled: false,
        staticOptions: [
          { key: 1, label: 'Option 1', value: 'Option 1' },
          { key: 2, label: 'Option 2', value: 'Option 2' },
          { key: 3, label: 'Option 3', value: 'Option 3' },
        ],
        defaultSelect: '',
        datasourceType: 'api',
        params: null,
        labelField: 'label',
        valueField: 'value',
        apiConfig: {
          path: '/mes/getDevtypeList',
          method: 'GET',
          apiId: 'copy1690511011986d22891',
          apiParams: [
            { key: '1', title: 'Query Params', tableInfo: [] },
            { key: '2', title: 'Header', tableInfo: [] },
            { key: '3', title: 'Body' },
          ],
          script:
            'var condition="";\r\n// if(data_type!=null&&data_type!=""){ \r\n//     condition+=" and data_type=#{data_type}";\r\n// }\r\n// if(warehouse_id!=null&&warehouse_id!=""){ \r\n//     condition+=" and warehouse_id=#{warehouse_id}";\r\n// }\r\n// if(area_id!=null&&area_id!=""){ \r\n//     condition+=" and area_id=#{area_id}";\r\n// }\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(type_code,\'-\',type_name) AS label FROM mes_dev_type where state=1 "+condition)',
        },
        dicOptions: [],
        required: true,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: '92f5a7df4ddd446d83899e0fbb6805ad',
      field: 'lineId',
      label: '所属生产线',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 12 },
      componentProps: {
        width: '100%',
        span: '',
        placeholder: '请选择',
        showLabel: true,
        showSearch: false,
        clearable: false,
        disabled: true,
        staticOptions: [
          { key: 1, label: 'Option 1', value: 'Option 1' },
          { key: 2, label: 'Option 2', value: 'Option 2' },
          { key: 3, label: 'Option 3', value: 'Option 3' },
        ],
        defaultSelect: '',
        datasourceType: 'api',
        params: null,
        labelField: 'label',
        valueField: 'value',
        apiConfig: {
          path: '/mes/mesFactory',
          method: 'GET',
          apiId: '6b4b40b3db664831b709f56bc98a7f04',
          apiParams: [
            {
              key: '1',
              title: 'Query Params',
              tableInfo: [
                {
                  name: 'factory_type',
                  value: '2',
                  description: null,
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: 'value',
                },
                {
                  name: 'factory_id',
                  value: '',
                  description: null,
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: 'value',
                },
                {
                  name: 'car_id',
                  value: '',
                  description: null,
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: 'value',
                },
              ],
            },
            { key: '2', title: 'Header', tableInfo: [] },
            { key: '3', title: 'Body' },
          ],
          script:
            'var condition="";\r\nif(factory_type!=null&&factory_type!=""){ \r\n    condition+=" and factory_type=#{factory_type}";\r\n}\r\nif(factory_id!=null&&factory_id!=""){ \r\n    condition+=" and factory_id=#{factory_id}";\r\n}\r\nif(car_id!=null&&car_id!=""){ \r\n    condition+=" and car_id=#{car_id}";\r\n}\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(factory_code,\'-\',factory_name) AS label FROM mes_base_factory where 1=1 "+condition)',
        },
        dicOptions: [],
        required: false,
        rules: [],
        events: {},
        style: { width: '100%' },
        onChange: (e: any) => {
          console.log(e, '啊啊啊啊啊啊啊啊啊啊啊啊');
        },
      },
    },
    {
      key: '0b3733b7570f4d2494b47263f4cb82ec',
      field: 'stationId',
      label: '所属工位',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 12 },
      componentProps: {
        width: '100%',
        span: '',
        placeholder: '请选择',
        showLabel: true,
        showSearch: false,
        clearable: false,
        disabled: false,
        staticOptions: [
          { key: 1, label: 'Option 1', value: 'Option 1' },
          { key: 2, label: 'Option 2', value: 'Option 2' },
          { key: 3, label: 'Option 3', value: 'Option 3' },
        ],
        defaultSelect: '',
        datasourceType: 'api',
        params: null,
        labelField: 'label',
        valueField: 'value',
        apiConfig: {
          path: '/mes/mesFactory',
          method: 'GET',
          apiId: '6b4b40b3db664831b709f56bc98a7f04',
          apiParams: [
            {
              key: '1',
              title: 'Query Params',
              tableInfo: [
                {
                  name: 'factory_type',
                  value: '3',
                  description: null,
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: 'value',
                },
                {
                  name: 'factory_id',
                  value: '',
                  description: null,
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: 'value',
                },
                {
                  name: 'car_id',
                  value: '',
                  description: null,
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: 'value',
                },
                {
                  name: 'parent_id',
                  value: '',
                  description: null,
                  required: false,
                  dataType: null,
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: 'value',
                },
              ],
            },
            { key: '2', title: 'Header', tableInfo: [] },
            { key: '3', title: 'Body' },
          ],
          script:
            'var condition="";\r\nif(factory_type!=null&&factory_type!=""){ \r\n    condition+=" and factory_type=#{factory_type}";\r\n}\r\nif(factory_id!=null&&factory_id!=""){ \r\n    condition+=" and factory_id=#{factory_id}";\r\n}\r\nif(car_id!=null&&car_id!=""){ \r\n    condition+=" and car_id=#{car_id}";\r\n}\r\nif(parent_id!=null&&parent_id!=""){ \r\n    condition+=" and parent_id=#{parent_id}";\r\n}\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(factory_code,\'-\',factory_name) AS label FROM mes_base_factory where 1=1 "+condition)',
        },
        dicOptions: [],
        required: true,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: '417e3757d04e46268e8ab5cfd9418d05',
      field: 'devBrand',
      label: '设备品牌',
      type: 'input',
      component: 'Input',
      colProps: { span: 12 },
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入设备品牌',
        maxlength: 200,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: false,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: '0291f57aedef4fc58d54c9f6de750c39',
      field: 'devSupplier',
      label: '供应商',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 12 },
      componentProps: {
        width: '100%',
        span: '',
        placeholder: '请选择',
        showLabel: true,
        showSearch: false,
        clearable: false,
        disabled: false,
        staticOptions: [
          { key: 1, label: 'Option 1', value: 'Option 1' },
          { key: 2, label: 'Option 2', value: 'Option 2' },
          { key: 3, label: 'Option 3', value: 'Option 3' },
        ],
        defaultSelect: '',
        datasourceType: 'api',
        params: null,
        labelField: 'label',
        valueField: 'value',
        apiConfig: {
          path: '/mes/getSupplierList',
          method: 'GET',
          apiId: 'copy1690511531075d26035',
          apiParams: [
            { key: '1', title: 'Query Params', tableInfo: [] },
            { key: '2', title: 'Header', tableInfo: [] },
            { key: '3', title: 'Body' },
          ],
          script:
            'var condition="";\r\n// if(data_type!=null&&data_type!=""){ \r\n//     condition+=" and data_type=#{data_type}";\r\n// }\r\n// if(warehouse_id!=null&&warehouse_id!=""){ \r\n//     condition+=" and warehouse_id=#{warehouse_id}";\r\n// }\r\n// if(area_id!=null&&area_id!=""){ \r\n//     condition+=" and area_id=#{area_id}";\r\n// }\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(type_code,\'-\',type_name) AS label FROM mes_dev_type where state=1 "+condition)',
        },
        dicOptions: [],
        required: false,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: 'd9eb0a0d2da9408c99cee9041fe428a9',
      field: 'devModel',
      label: '设备型号',
      type: 'input',
      component: 'Input',
      colProps: { span: 12 },
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入设备型号',
        maxlength: 200,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: false,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: '7b562603dc8b4fa2a317a2ad7d158e61',
      field: 'buyDate',
      label: '采购日期',
      type: 'date',
      component: 'DatePicker',
      colProps: { span: 12 },
      defaultValue: '',
      componentProps: {
        span: '',
        defaultValue: '',
        width: '100%',
        placeholder: '请选择采购日期',
        format: 'YYYY-MM-DD',
        showLabel: true,
        allowClear: true,
        disabled: false,
        required: false,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: 'caf3796ebc454063822c331b9695529e',
      field: 'maintenanceDate',
      label: '维保到期',
      type: 'date',
      component: 'DatePicker',
      colProps: { span: 12 },
      defaultValue: '',
      componentProps: {
        span: '',
        defaultValue: '',
        width: '100%',
        placeholder: '请选择维保到期',
        format: 'YYYY-MM-DD',
        showLabel: true,
        allowClear: true,
        disabled: false,
        required: false,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: '458bd10d3e4945d88e2d46e8145cef93',
      field: 'scrapDate',
      label: '报废日期',
      type: 'date',
      component: 'DatePicker',
      colProps: { span: 12 },
      defaultValue: '',
      componentProps: {
        span: '',
        defaultValue: '',
        width: '100%',
        placeholder: '请选择报废日期',
        format: 'YYYY-MM-DD',
        showLabel: true,
        allowClear: true,
        disabled: false,
        required: false,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: '0b6af406dfab4fcf9f69c5a59a07d07e',
      field: 'devManage',
      label: '负责人',
      type: 'user',
      component: 'User',
      colProps: { span: 12 },
      defaultValue: '',
      componentProps: {
        span: '',
        width: '100%',
        defaultValue: '',
        placeholder: '请选择人员',
        userType: 0,
        prefix: '',
        suffix: 'ant-design:setting-outlined',
        showLabel: true,
        disabled: false,
        required: true,
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: 'a1e02f4471274d87b5b2c56ae705dda3',
      field: 'devPhone',
      label: '联系方式',
      type: 'input',
      component: 'Input',
      colProps: { span: 12 },
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入联系方式',
        maxlength: 100,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: true,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: 'c05dae6089dc434ca2ae3aa82198347a',
      field: 'devFile',
      label: '设备图片',
      type: 'upload',
      component: 'Upload',
      colProps: { span: 24 },
      componentProps: {
        api: uploadApi,
        span: '',
        defaultValue: [],
        accept: '',
        maxNumber: 5,
        maxSize: 5,
        showLabel: true,
        multiple: false,
        disabled: false,
        required: false,
        events: {},
        listType: 'picture-card',
      },
    },
    {
      key: '7db64fc5b91a4a6fbbcdf7252e3384a8',
      field: 'remark',
      label: '备注',
      type: 'textarea',
      component: 'InputTextArea',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入备注',
        maxlength: 200,
        rows: 4,
        autoSize: false,
        showCount: false,
        disabled: false,
        showLabel: true,
        allowClear: false,
        required: false,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    // {
    //   key: 'f4c40d8a7b3e47288ea60103cd8a4635',
    //   field: 'createUserId',
    //   label: '创建人',
    //   type: 'info',
    //   component: 'Info',
    //   colProps: { span: 24 },
    //   componentProps: {
    //     span: '',
    //     width: '100%',
    //     placeholder: '',
    //     infoType: 0,
    //     loadAgain: false,
    //     showLabel: true,
    //     disabled: true,
    //     style: { width: '100%' },
    //   },
    // },
    // {
    //   key: '0041df445c0a4df59a7884d44ddd4d19',
    //   field: 'createDate',
    //   label: '创建时间',
    //   type: 'info',
    //   component: 'Info',
    //   colProps: { span: 24 },
    //   componentProps: {
    //     span: '',
    //     width: '100%',
    //     placeholder: '',
    //     infoType: 0,
    //     loadAgain: false,
    //     showLabel: true,
    //     disabled: true,
    //     style: { width: '100%' },
    //   },
    // },
    {
      key: '97ca40c496c44149abd0f739467b1d42',
      field: '',
      label: '标题',
      type: 'title',
      component: 'Title',
      colProps: { span: 24 },
      defaultValue: '附件',
      componentProps: {
        defaultValue: '附件',
        color: '',
        align: 'left',
        fontSize: 16,
        style: {},
      },
    },
    {
      key: '102375f2d9844ee8997ba0360951bab6',
      field: 'devFile2',
      label: '附件',
      type: 'upload',
      component: 'Upload',
      colProps: { span: 24 },
      componentProps: {
        api: '#{upload}#',
        span: '',
        defaultValue: [],
        accept: '',
        maxNumber: 5,
        maxSize: 5,
        showLabel: false,
        multiple: false,
        disabled: false,
        required: false,
        events: {},
        listType: 'picture-card',
      },
    },
    {
      key: 'hiddenComponent1690511781767',
      field: 'state',
      label: '设备状态',
      type: 'hiddenComponent',
      component: 'Input',
      colProps: { span: 24 },
      defaultValue: '1',
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [
    {
      key: 'hiddenComponent1690511781767',
      type: 'hiddenComponent',
      code: 'state',
      label: '设备状态',
      value: '1',
      bindTable: 'mes_dev',
      bindField: 'state',
    },
  ],
};
