import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'factoryCode',
    label: '编号',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'factoryName',
    label: '名称',
    component: 'Input',
    colProps: { span: 8 },
  },
  // {
  //   field: 'factoryManage',
  //   label: '工厂负责人',
  //   component: 'User',
  //   componentProps: {
  //     suffix: 'ant-design:setting-outlined',
  //     placeholder: '请选择',
  //   },
  //   colProps: { span: 8 },
  // },

  // {
  //   field: 'factoryAddress',
  //   label: '工厂地址',
  //   component: 'Input',
  //   colProps: { span: 8 },
  // },
  // {
  //   field: 'factoryId',
  //   label: '所属工厂',
  //   component: 'XjrSelect',
  //   componentProps: {
  //     datasourceType: 'api',
  //     apiConfig: {
  //       path: '/mes/mesFactory',
  //       method: 'GET',
  //       apiId: '6b4b40b3db664831b709f56bc98a7f04',
  //       apiParams: [
  //         {
  //           key: '1',
  //           title: 'Query Params',
  //           tableInfo: [
  //             {
  //               name: 'factory_type',
  //               value: '0',
  //               description: null,
  //               required: false,
  //               dataType: 'String',
  //               type: null,
  //               defaultValue: null,
  //               validateType: null,
  //               error: null,
  //               expression: null,
  //               children: null,
  //               bindType: 'value',
  //             },
  //             {
  //               name: 'factory_id',
  //               value: '',
  //               description: null,
  //               required: false,
  //               dataType: 'String',
  //               type: null,
  //               defaultValue: null,
  //               validateType: null,
  //               error: null,
  //               expression: null,
  //               children: null,
  //               bindType: 'value',
  //             },
  //             {
  //               name: 'car_id',
  //               value: '',
  //               description: null,
  //               required: false,
  //               dataType: 'String',
  //               type: null,
  //               defaultValue: null,
  //               validateType: null,
  //               error: null,
  //               expression: null,
  //               children: null,
  //               bindType: 'value',
  //             },
  //           ],
  //         },
  //         { key: '2', title: 'Header', tableInfo: [] },
  //         { key: '3', title: 'Body' },
  //       ],
  //       script:
  //         'var condition="";\r\nif(factory_type!=null&&factory_type!=""){ \r\n    condition+=" and factory_type=#{factory_type}";\r\n}\r\nif(factory_id!=null&&factory_id!=""){ \r\n    condition+=" and factory_id=#{factory_id}";\r\n}\r\nif(car_id!=null&&car_id!=""){ \r\n    condition+=" and car_id=#{car_id}";\r\n}\r\n\r\nreturn db.select("SELECT id AS VALUE,CONCAT(factory_code,\'-\',factory_name) AS label FROM mes_base_factory where 1=1 "+condition)',
  //     },
  //     labelField: 'label',
  //     valueField: 'value',

  //     getPopupContainer: () => document.body,
  //   },
  //   colProps: { span: 8 },
  // },
  // {
  //   field: 'carId',
  //   label: '所属车间',
  //   component: 'XjrSelect',
  //   componentProps: {
  //     datasourceType: 'api',
  //     apiConfig: {
  //       path: '/mes/mesFactory',
  //       method: 'GET',
  //       apiId: '6b4b40b3db664831b709f56bc98a7f04',
  //       apiParams: [
  //         {
  //           key: '1',
  //           title: 'Query Params',
  //           tableInfo: [
  //             {
  //               name: 'factory_type',
  //               value: '1',
  //               description: null,
  //               required: false,
  //               dataType: 'String',
  //               type: null,
  //               defaultValue: null,
  //               validateType: null,
  //               error: null,
  //               expression: null,
  //               children: null,
  //               bindType: 'value',
  //             },
  //             {
  //               name: 'factory_id',
  //               value: '',
  //               description: null,
  //               required: false,
  //               dataType: 'String',
  //               type: null,
  //               defaultValue: null,
  //               validateType: null,
  //               error: null,
  //               expression: null,
  //               children: null,
  //               bindType: 'value',
  //             },
  //             {
  //               name: 'car_id',
  //               value: '',
  //               description: null,
  //               required: false,
  //               dataType: 'String',
  //               type: null,
  //               defaultValue: null,
  //               validateType: null,
  //               error: null,
  //               expression: null,
  //               children: null,
  //               bindType: 'value',
  //             },
  //           ],
  //         },
  //         { key: '2', title: 'Header', tableInfo: [] },
  //         { key: '3', title: 'Body' },
  //       ],
  //       script:
  //         'var condition="";\r\nif(factory_type!=null&&factory_type!=""){ \r\n    condition+=" and factory_type=#{factory_type}";\r\n}\r\nif(factory_id!=null&&factory_id!=""){ \r\n    condition+=" and factory_id=#{factory_id}";\r\n}\r\nif(car_id!=null&&car_id!=""){ \r\n    condition+=" and car_id=#{car_id}";\r\n}\r\n\r\nreturn db.select("SELECT id AS VALUE,CONCAT(factory_code,\'-\',factory_name) AS label FROM mes_base_factory where 1=1 "+condition)',
  //     },
  //     labelField: 'label',
  //     valueField: 'value',

  //     getPopupContainer: () => document.body,
  //   },
  //   colProps: { span: 8 },
  // },
  // {
  //   field: 'remark',
  //   label: '备注',
  //   component: 'Input',
  //   colProps: { span: 8 },
  // },
  // {
  //   field: 'createUserId',
  //   label: '创建人',
  //   component: 'User',
  //   componentProps: {
  //     suffix: 'ant-design:setting-outlined',
  //     placeholder: '请选择',
  //   },
  //   colProps: { span: 8 },
  // },

  // {
  //   field: 'createDate',
  //   label: '创建时间',
  //   component: 'RangePicker',
  //   componentProps: {
  //     showTime: true,
  //     style: { width: '100%' },
  //     getPopupContainer: () => document.body,
  //   },
  //   colProps: { span: 8 },
  // },
];

export const columns: BasicColumn[] = [
  {
    dataIndex: 'factoryCode',
    title: '工厂编号',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'factoryName',
    title: '工厂名称',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'factoryManage',
    title: '工厂负责人',
    componentType: 'user',

    sorter: true,
  },

  {
    dataIndex: 'factoryAddress',
    title: '工厂地址',
    componentType: 'input',

    sorter: true,
  },

  // {
  //   dataIndex: 'factoryId',
  //   title: '所属工厂',
  //   componentType: 'select',

  //   sorter: true,
  // },

  // {
  //   dataIndex: 'carId',
  //   title: '所属车间',
  //   componentType: 'select',

  //   sorter: true,
  // },

  {
    dataIndex: 'remark',
    title: '备注',
    componentType: 'textarea',

    sorter: true,
  },

  {
    dataIndex: 'createUserId',
    title: '创建人',
    componentType: 'info',

    sorter: true,
  },

  {
    dataIndex: 'createDate',
    title: '创建时间',
    componentType: 'info',

    sorter: true,
  },
];

export const formProps: FormProps = {
  // labelCol: { offset: 0, span: 3 },
  labelWidth: 120,
  labelAlign: 'right',
  layout: 'horizontal',
  size: 'default',
  schemas: [
    {
      key: 'fde0188c88d2446d9bfe6067b359dbf0',
      field: 'factoryCode',
      label: '工厂编号',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        maxlength: 200,
        defaultValue: '',
        prefix: '',
        rules: [],
        suffix: '',
        addonAfter: '',
        showLabel: true,
        required: true,
        width: '100%',
        disabled: false,
        placeholder: '请输入工厂编号',
        allowClear: false,
        addonBefore: '',
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '97e2263e951f44d2bccc93101bb7bce6',
      field: 'factoryName',
      label: '工厂名称',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        maxlength: 200,
        defaultValue: '',
        prefix: '',
        rules: [],
        suffix: '',
        addonAfter: '',
        showLabel: true,
        required: true,
        width: '100%',
        disabled: false,
        placeholder: '请输入工厂名称',
        allowClear: false,
        addonBefore: '',
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: 'e2bca928fc5e4d6792421811ff90df44',
      field: 'factoryManage',
      label: '工厂负责人',
      type: 'user',
      component: 'User',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        defaultValue: '',
        prefix: '',
        suffix: 'ant-design:setting-outlined',
        showLabel: true,
        required: true,
        width: '100%',
        disabled: false,
        placeholder: '工厂负责人请选择人员',
        userType: 0,
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: 'd877e047c646490b96c23c3cffbad14d',
      field: 'factoryAddress',
      label: '工厂地址',
      type: 'map',
      component: 'SelectMap',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        span: '',
        width: '100%',
        defaultValue: '',
        placeholder: '请选择地址',
        prefix: '',
        suffix: 'mdi:map-marker-radius-outline',
        showLabel: true,
        disabled: false,
        required: false,
        address: null,
        latiAndLong: null,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    // {
    //   key: '3d6d816de7a748ecae054c9f66691616',
    //   field: 'factoryId',
    //   label: '所属工厂',
    //   type: 'select',
    //   component: 'XjrSelect',
    //   colProps: { span: 24 },
    //   componentProps: {
    //     clearable: false,
    //     defaultSelect: '',
    //     rules: [],
    //     valueField: 'value',
    //     showLabel: true,
    //     required: false,
    //     labelField: 'label',
    //     datasourceType: 'api',
    //     dicOptions: [],
    //     showSearch: false,
    //     width: '100%',
    //     apiConfig: {
    //       path: '/mes/mesFactory',
    //       method: 'GET',
    //       apiId: '6b4b40b3db664831b709f56bc98a7f04',
    //       apiParams: [
    //         {
    //           key: '1',
    //           title: 'Query Params',
    //           tableInfo: [
    //             {
    //               name: 'factory_type',
    //               value: '0',
    //               description: null,
    //               required: false,
    //               dataType: 'String',
    //               type: null,
    //               defaultValue: null,
    //               validateType: null,
    //               error: null,
    //               expression: null,
    //               children: null,
    //               bindType: 'value',
    //             },
    //             {
    //               name: 'factory_id',
    //               value: '',
    //               description: null,
    //               required: false,
    //               dataType: 'String',
    //               type: null,
    //               defaultValue: null,
    //               validateType: null,
    //               error: null,
    //               expression: null,
    //               children: null,
    //               bindType: 'value',
    //             },
    //             {
    //               name: 'car_id',
    //               value: '',
    //               description: null,
    //               required: false,
    //               dataType: 'String',
    //               type: null,
    //               defaultValue: null,
    //               validateType: null,
    //               error: null,
    //               expression: null,
    //               children: null,
    //               bindType: 'value',
    //             },
    //           ],
    //         },
    //         { key: '2', title: 'Header', tableInfo: [] },
    //         { key: '3', title: 'Body' },
    //       ],
    //       script:
    //         'var condition="";\r\nif(factory_type!=null&&factory_type!=""){ \r\n    condition+=" and factory_type=#{factory_type}";\r\n}\r\nif(factory_id!=null&&factory_id!=""){ \r\n    condition+=" and factory_id=#{factory_id}";\r\n}\r\nif(car_id!=null&&car_id!=""){ \r\n    condition+=" and car_id=#{car_id}";\r\n}\r\n\r\nreturn db.select("SELECT id AS VALUE,CONCAT(factory_code,\'-\',factory_name) AS label FROM mes_base_factory where 1=1 "+condition)',
    //     },
    //     disabled: false,
    //     placeholder: '请选择',
    //     staticOptions: [
    //       { label: 'Option 1', value: 'Option 1', key: 1 },
    //       { label: 'Option 2', value: 'Option 2', key: 2 },
    //       { label: 'Option 3', value: 'Option 3', key: 3 },
    //     ],
    //     events: {},
    //     span: '',
    //     style: { width: '100%' },
    //   },
    // },
    // {
    //   key: '154a1eb8ddfb47c0beb0988f6952195c',
    //   field: 'carId',
    //   label: '所属车间',
    //   type: 'select',
    //   component: 'XjrSelect',
    //   colProps: { span: 24 },
    //   componentProps: {
    //     clearable: false,
    //     defaultSelect: '',
    //     rules: [],
    //     valueField: 'value',
    //     showLabel: true,
    //     required: false,
    //     labelField: 'label',
    //     datasourceType: 'api',
    //     dicOptions: [],
    //     showSearch: false,
    //     width: '100%',
    //     apiConfig: {
    //       path: '/mes/mesFactory',
    //       method: 'GET',
    //       apiId: '6b4b40b3db664831b709f56bc98a7f04',
    //       apiParams: [
    //         {
    //           key: '1',
    //           title: 'Query Params',
    //           tableInfo: [
    //             {
    //               name: 'factory_type',
    //               value: '1',
    //               description: null,
    //               required: false,
    //               dataType: 'String',
    //               type: null,
    //               defaultValue: null,
    //               validateType: null,
    //               error: null,
    //               expression: null,
    //               children: null,
    //               bindType: 'value',
    //             },
    //             {
    //               name: 'factory_id',
    //               value: '',
    //               description: null,
    //               required: false,
    //               dataType: 'String',
    //               type: null,
    //               defaultValue: null,
    //               validateType: null,
    //               error: null,
    //               expression: null,
    //               children: null,
    //               bindType: 'value',
    //             },
    //             {
    //               name: 'car_id',
    //               value: '',
    //               description: null,
    //               required: false,
    //               dataType: 'String',
    //               type: null,
    //               defaultValue: null,
    //               validateType: null,
    //               error: null,
    //               expression: null,
    //               children: null,
    //               bindType: 'value',
    //             },
    //           ],
    //         },
    //         { key: '2', title: 'Header', tableInfo: [] },
    //         { key: '3', title: 'Body' },
    //       ],
    //       script:
    //         'var condition="";\r\nif(factory_type!=null&&factory_type!=""){ \r\n    condition+=" and factory_type=#{factory_type}";\r\n}\r\nif(factory_id!=null&&factory_id!=""){ \r\n    condition+=" and factory_id=#{factory_id}";\r\n}\r\nif(car_id!=null&&car_id!=""){ \r\n    condition+=" and car_id=#{car_id}";\r\n}\r\n\r\nreturn db.select("SELECT id AS VALUE,CONCAT(factory_code,\'-\',factory_name) AS label FROM mes_base_factory where 1=1 "+condition)',
    //     },
    //     disabled: false,
    //     placeholder: '请选择',
    //     staticOptions: [
    //       { label: 'Option 1', value: 'Option 1', key: 1 },
    //       { label: 'Option 2', value: 'Option 2', key: 2 },
    //       { label: 'Option 3', value: 'Option 3', key: 3 },
    //     ],
    //     events: {},
    //     span: '',
    //     style: { width: '100%' },
    //   },
    // },
    {
      key: 'ca233109618d46179ad3e3bf8525c131',
      field: 'remark',
      label: '备注',
      type: 'textarea',
      component: 'InputTextArea',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        maxlength: 255,
        defaultValue: '',
        rules: [],
        rows: 4,
        showLabel: true,
        required: false,
        autoSize: false,
        showCount: false,
        width: '100%',
        disabled: false,
        placeholder: '请输入备注',
        allowClear: false,
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '69d76fe5c7a14140b0e2f5a5cb6511a9',
      field: 'createUserId',
      label: '创建人',
      type: 'info',
      component: 'Info',
      colProps: { span: 24 },
      componentProps: {
        showLabel: true,
        infoType: 0,
        width: '100%',
        disabled: true,
        placeholder: '',
        loadAgain: false,
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: 'd935579cbca54308a9212deb59c692cf',
      field: 'createDate',
      label: '创建时间',
      type: 'info',
      component: 'Info',
      colProps: { span: 24 },
      componentProps: {
        showLabel: true,
        infoType: 2,
        width: '100%',
        disabled: true,
        placeholder: '',
        loadAgain: false,
        span: '',
        style: { width: '100%' },
      },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};

export const columns1: BasicColumn[] = [
  {
    dataIndex: 'factoryCode',
    title: '车间编号',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'factoryName',
    title: '车间名称',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'factoryManage',
    title: '车间负责人',
    componentType: 'user',

    sorter: true,
  },

  // {
  //   dataIndex: 'factoryAddress',
  //   title: '车间地址',
  //   componentType: 'input',

  //   sorter: true,
  // },

  {
    dataIndex: 'factoryId',
    title: '所属工厂',
    componentType: 'select',

    sorter: true,
  },

  // {
  //   dataIndex: 'carId',
  //   title: '所属车间',
  //   componentType: 'select',

  //   sorter: true,
  // },

  {
    dataIndex: 'remark',
    title: '备注',
    componentType: 'textarea',

    sorter: true,
  },

  {
    dataIndex: 'createUserId',
    title: '创建人',
    componentType: 'info',

    sorter: true,
  },

  {
    dataIndex: 'createDate',
    title: '创建时间',
    componentType: 'info',

    sorter: true,
  },
];

export const formProps1: FormProps = {
  // labelCol: { offset: 0, span: 3 },
  labelWidth: 120,
  labelAlign: 'right',
  layout: 'horizontal',
  size: 'default',
  schemas: [
    {
      key: 'fde0188c88d2446d9bfe6067b359dbf0',
      field: 'factoryCode',
      label: '车间编号',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        maxlength: 200,
        defaultValue: '',
        prefix: '',
        rules: [],
        suffix: '',
        addonAfter: '',
        showLabel: true,
        required: true,
        width: '100%',
        disabled: false,
        placeholder: '请输入车间编号',
        allowClear: false,
        addonBefore: '',
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '97e2263e951f44d2bccc93101bb7bce6',
      field: 'factoryName',
      label: '车间名称',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        maxlength: 200,
        defaultValue: '',
        prefix: '',
        rules: [],
        suffix: '',
        addonAfter: '',
        showLabel: true,
        required: true,
        width: '100%',
        disabled: false,
        placeholder: '请输入车间名称',
        allowClear: false,
        addonBefore: '',
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: 'e2bca928fc5e4d6792421811ff90df44',
      field: 'factoryManage',
      label: '车间负责人',
      type: 'user',
      component: 'User',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        defaultValue: '',
        prefix: '',
        suffix: 'ant-design:setting-outlined',
        showLabel: true,
        required: true,
        width: '100%',
        disabled: false,
        placeholder: '车间负责人请选择人员',
        userType: 0,
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    // {
    //   key: 'd877e047c646490b96c23c3cffbad14d',
    //   field: 'factoryAddress',
    //   label: '车间地址',
    //   type: 'input',
    //   component: 'Input',
    //   colProps: { span: 24 },
    //   defaultValue: '',
    //   componentProps: {
    //     maxlength: 200,
    //     defaultValue: '',
    //     prefix: '',
    //     rules: [],
    //     suffix: '',
    //     addonAfter: '',
    //     showLabel: true,
    //     required: false,
    //     width: '100%',
    //     disabled: false,
    //     placeholder: '请输入车间地址',
    //     allowClear: false,
    //     addonBefore: '',
    //     events: {},
    //     span: '',
    //     style: { width: '100%' },
    //   },
    // },
    {
      key: '3d6d816de7a748ecae054c9f66691616',
      field: 'factoryId',
      label: '所属工厂',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 24 },
      componentProps: {
        clearable: false,
        defaultSelect: '',
        rules: [],
        valueField: 'value',
        showLabel: true,
        required: false,
        labelField: 'label',
        datasourceType: 'api',
        dicOptions: [],
        showSearch: false,
        width: '100%',
        apiConfig: {
          path: '/mes/mesFactory',
          method: 'GET',
          apiId: '6b4b40b3db664831b709f56bc98a7f04',
          apiParams: [
            {
              key: '1',
              title: 'Query Params',
              tableInfo: [
                {
                  name: 'factory_type',
                  value: '0',
                  description: null,
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: 'value',
                },
                {
                  name: 'factory_id',
                  value: '',
                  description: null,
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: 'value',
                },
                {
                  name: 'car_id',
                  value: '',
                  description: null,
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: 'value',
                },
              ],
            },
            { key: '2', title: 'Header', tableInfo: [] },
            { key: '3', title: 'Body' },
          ],
          script:
            'var condition="";\r\nif(factory_type!=null&&factory_type!=""){ \r\n    condition+=" and factory_type=#{factory_type}";\r\n}\r\nif(factory_id!=null&&factory_id!=""){ \r\n    condition+=" and factory_id=#{factory_id}";\r\n}\r\nif(car_id!=null&&car_id!=""){ \r\n    condition+=" and car_id=#{car_id}";\r\n}\r\n\r\nreturn db.select("SELECT id AS VALUE,CONCAT(factory_code,\'-\',factory_name) AS label FROM mes_base_factory where 1=1 "+condition)',
        },
        disabled: true,
        placeholder: '请选择',
        staticOptions: [
          { label: 'Option 1', value: 'Option 1', key: 1 },
          { label: 'Option 2', value: 'Option 2', key: 2 },
          { label: 'Option 3', value: 'Option 3', key: 3 },
        ],
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    // {
    //   key: '154a1eb8ddfb47c0beb0988f6952195c',
    //   field: 'carId',
    //   label: '所属车间',
    //   type: 'select',
    //   component: 'XjrSelect',
    //   colProps: { span: 24 },
    //   componentProps: {
    //     clearable: false,
    //     defaultSelect: '',
    //     rules: [],
    //     valueField: 'value',
    //     showLabel: true,
    //     required: false,
    //     labelField: 'label',
    //     datasourceType: 'api',
    //     dicOptions: [],
    //     showSearch: false,
    //     width: '100%',
    //     apiConfig: {
    //       path: '/mes/mesFactory',
    //       method: 'GET',
    //       apiId: '6b4b40b3db664831b709f56bc98a7f04',
    //       apiParams: [
    //         {
    //           key: '1',
    //           title: 'Query Params',
    //           tableInfo: [
    //             {
    //               name: 'factory_type',
    //               value: '1',
    //               description: null,
    //               required: false,
    //               dataType: 'String',
    //               type: null,
    //               defaultValue: null,
    //               validateType: null,
    //               error: null,
    //               expression: null,
    //               children: null,
    //               bindType: 'value',
    //             },
    //             {
    //               name: 'factory_id',
    //               value: '',
    //               description: null,
    //               required: false,
    //               dataType: 'String',
    //               type: null,
    //               defaultValue: null,
    //               validateType: null,
    //               error: null,
    //               expression: null,
    //               children: null,
    //               bindType: 'value',
    //             },
    //             {
    //               name: 'car_id',
    //               value: '',
    //               description: null,
    //               required: false,
    //               dataType: 'String',
    //               type: null,
    //               defaultValue: null,
    //               validateType: null,
    //               error: null,
    //               expression: null,
    //               children: null,
    //               bindType: 'value',
    //             },
    //           ],
    //         },
    //         { key: '2', title: 'Header', tableInfo: [] },
    //         { key: '3', title: 'Body' },
    //       ],
    //       script:
    //         'var condition="";\r\nif(factory_type!=null&&factory_type!=""){ \r\n    condition+=" and factory_type=#{factory_type}";\r\n}\r\nif(factory_id!=null&&factory_id!=""){ \r\n    condition+=" and factory_id=#{factory_id}";\r\n}\r\nif(car_id!=null&&car_id!=""){ \r\n    condition+=" and car_id=#{car_id}";\r\n}\r\n\r\nreturn db.select("SELECT id AS VALUE,CONCAT(factory_code,\'-\',factory_name) AS label FROM mes_base_factory where 1=1 "+condition)',
    //     },
    //     disabled: false,
    //     placeholder: '请选择',
    //     staticOptions: [
    //       { label: 'Option 1', value: 'Option 1', key: 1 },
    //       { label: 'Option 2', value: 'Option 2', key: 2 },
    //       { label: 'Option 3', value: 'Option 3', key: 3 },
    //     ],
    //     events: {},
    //     span: '',
    //     style: { width: '100%' },
    //   },
    // },
    {
      key: 'ca233109618d46179ad3e3bf8525c131',
      field: 'remark',
      label: '备注',
      type: 'textarea',
      component: 'InputTextArea',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        maxlength: 255,
        defaultValue: '',
        rules: [],
        rows: 4,
        showLabel: true,
        required: false,
        autoSize: false,
        showCount: false,
        width: '100%',
        disabled: false,
        placeholder: '请输入备注',
        allowClear: false,
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '69d76fe5c7a14140b0e2f5a5cb6511a9',
      field: 'createUserId',
      label: '创建人',
      type: 'info',
      component: 'Info',
      colProps: { span: 24 },
      componentProps: {
        showLabel: true,
        infoType: 0,
        width: '100%',
        disabled: true,
        placeholder: '',
        loadAgain: false,
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: 'd935579cbca54308a9212deb59c692cf',
      field: 'createDate',
      label: '创建时间',
      type: 'info',
      component: 'Info',
      colProps: { span: 24 },
      componentProps: {
        showLabel: true,
        infoType: 2,
        width: '100%',
        disabled: true,
        placeholder: '',
        loadAgain: false,
        span: '',
        style: { width: '100%' },
      },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};

export const columns2: BasicColumn[] = [
  {
    dataIndex: 'factoryCode',
    title: '产线编号',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'factoryName',
    title: '产线名称',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'factoryManage',
    title: '产线负责人',
    componentType: 'user',

    sorter: true,
  },

  // {
  //   dataIndex: 'factoryAddress',
  //   title: '产线地址',
  //   componentType: 'input',

  //   sorter: true,
  // },

  {
    dataIndex: 'factoryId',
    title: '所属工厂',
    componentType: 'select',

    sorter: true,
  },

  {
    dataIndex: 'carId',
    title: '所属车间',
    componentType: 'select',

    sorter: true,
  },

  {
    dataIndex: 'remark',
    title: '备注',
    componentType: 'textarea',

    sorter: true,
  },

  {
    dataIndex: 'createUserId',
    title: '创建人',
    componentType: 'info',

    sorter: true,
  },

  {
    dataIndex: 'createDate',
    title: '创建时间',
    componentType: 'info',

    sorter: true,
  },
];

export const formProps2: FormProps = {
  // labelCol: { offset: 0, span: 3 },
  labelWidth: 120,
  labelAlign: 'right',
  layout: 'horizontal',
  size: 'default',
  schemas: [
    {
      key: 'fde0188c88d2446d9bfe6067b359dbf0',
      field: 'factoryCode',
      label: '产线编号',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        maxlength: 200,
        defaultValue: '',
        prefix: '',
        rules: [],
        suffix: '',
        addonAfter: '',
        showLabel: true,
        required: true,
        width: '100%',
        disabled: false,
        placeholder: '请输入产线编号',
        allowClear: false,
        addonBefore: '',
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '97e2263e951f44d2bccc93101bb7bce6',
      field: 'factoryName',
      label: '产线名称',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        maxlength: 200,
        defaultValue: '',
        prefix: '',
        rules: [],
        suffix: '',
        addonAfter: '',
        showLabel: true,
        required: true,
        width: '100%',
        disabled: false,
        placeholder: '请输入产线名称',
        allowClear: false,
        addonBefore: '',
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: 'e2bca928fc5e4d6792421811ff90df44',
      field: 'factoryManage',
      label: '产线负责人',
      type: 'user',
      component: 'User',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        defaultValue: '',
        prefix: '',
        suffix: 'ant-design:setting-outlined',
        showLabel: true,
        required: true,
        width: '100%',
        disabled: false,
        placeholder: '产线负责人请选择人员',
        userType: 0,
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    // {
    //   key: 'd877e047c646490b96c23c3cffbad14d',
    //   field: 'factoryAddress',
    //   label: '产线地址',
    //   type: 'input',
    //   component: 'Input',
    //   colProps: { span: 24 },
    //   defaultValue: '',
    //   componentProps: {
    //     maxlength: 200,
    //     defaultValue: '',
    //     prefix: '',
    //     rules: [],
    //     suffix: '',
    //     addonAfter: '',
    //     showLabel: true,
    //     required: false,
    //     width: '100%',
    //     disabled: false,
    //     placeholder: '请输入产线地址',
    //     allowClear: false,
    //     addonBefore: '',
    //     events: {},
    //     span: '',
    //     style: { width: '100%' },
    //   },
    // },
    {
      key: '3d6d816de7a748ecae054c9f66691616',
      field: 'factoryId',
      label: '所属工厂',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 24 },
      componentProps: {
        clearable: false,
        defaultSelect: '',
        rules: [],
        valueField: 'value',
        showLabel: true,
        required: false,
        labelField: 'label',
        datasourceType: 'api',
        dicOptions: [],
        showSearch: false,
        width: '100%',
        apiConfig: {
          path: '/mes/mesFactory',
          method: 'GET',
          apiId: '6b4b40b3db664831b709f56bc98a7f04',
          apiParams: [
            {
              key: '1',
              title: 'Query Params',
              tableInfo: [
                {
                  name: 'factory_type',
                  value: '0',
                  description: null,
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: 'value',
                },
                {
                  name: 'factory_id',
                  value: '',
                  description: null,
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: 'value',
                },
                {
                  name: 'car_id',
                  value: '',
                  description: null,
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: 'value',
                },
              ],
            },
            { key: '2', title: 'Header', tableInfo: [] },
            { key: '3', title: 'Body' },
          ],
          script:
            'var condition="";\r\nif(factory_type!=null&&factory_type!=""){ \r\n    condition+=" and factory_type=#{factory_type}";\r\n}\r\nif(factory_id!=null&&factory_id!=""){ \r\n    condition+=" and factory_id=#{factory_id}";\r\n}\r\nif(car_id!=null&&car_id!=""){ \r\n    condition+=" and car_id=#{car_id}";\r\n}\r\n\r\nreturn db.select("SELECT id AS VALUE,CONCAT(factory_code,\'-\',factory_name) AS label FROM mes_base_factory where 1=1 "+condition)',
        },
        disabled: true,
        placeholder: '请选择',
        staticOptions: [
          { label: 'Option 1', value: 'Option 1', key: 1 },
          { label: 'Option 2', value: 'Option 2', key: 2 },
          { label: 'Option 3', value: 'Option 3', key: 3 },
        ],
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '154a1eb8ddfb47c0beb0988f6952195c',
      field: 'carId',
      label: '所属车间',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 24 },
      componentProps: {
        clearable: false,
        defaultSelect: '',
        rules: [],
        valueField: 'value',
        showLabel: true,
        required: false,
        labelField: 'label',
        datasourceType: 'api',
        dicOptions: [],
        showSearch: false,
        width: '100%',
        apiConfig: {
          path: '/mes/mesFactory',
          method: 'GET',
          apiId: '6b4b40b3db664831b709f56bc98a7f04',
          apiParams: [
            {
              key: '1',
              title: 'Query Params',
              tableInfo: [
                {
                  name: 'factory_type',
                  value: '1',
                  description: null,
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: 'value',
                },
                {
                  name: 'factory_id',
                  value: '',
                  description: null,
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: 'value',
                },
                {
                  name: 'car_id',
                  value: '',
                  description: null,
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: 'value',
                },
              ],
            },
            { key: '2', title: 'Header', tableInfo: [] },
            { key: '3', title: 'Body' },
          ],
          script:
            'var condition="";\r\nif(factory_type!=null&&factory_type!=""){ \r\n    condition+=" and factory_type=#{factory_type}";\r\n}\r\nif(factory_id!=null&&factory_id!=""){ \r\n    condition+=" and factory_id=#{factory_id}";\r\n}\r\nif(car_id!=null&&car_id!=""){ \r\n    condition+=" and car_id=#{car_id}";\r\n}\r\n\r\nreturn db.select("SELECT id AS VALUE,CONCAT(factory_code,\'-\',factory_name) AS label FROM mes_base_factory where 1=1 "+condition)',
        },
        disabled: true,
        placeholder: '请选择',
        staticOptions: [
          { label: 'Option 1', value: 'Option 1', key: 1 },
          { label: 'Option 2', value: 'Option 2', key: 2 },
          { label: 'Option 3', value: 'Option 3', key: 3 },
        ],
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: 'ca233109618d46179ad3e3bf8525c131',
      field: 'remark',
      label: '备注',
      type: 'textarea',
      component: 'InputTextArea',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        maxlength: 255,
        defaultValue: '',
        rules: [],
        rows: 4,
        showLabel: true,
        required: false,
        autoSize: false,
        showCount: false,
        width: '100%',
        disabled: false,
        placeholder: '请输入备注',
        allowClear: false,
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '69d76fe5c7a14140b0e2f5a5cb6511a9',
      field: 'createUserId',
      label: '创建人',
      type: 'info',
      component: 'Info',
      colProps: { span: 24 },
      componentProps: {
        showLabel: true,
        infoType: 0,
        width: '100%',
        disabled: true,
        placeholder: '',
        loadAgain: false,
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: 'd935579cbca54308a9212deb59c692cf',
      field: 'createDate',
      label: '创建时间',
      type: 'info',
      component: 'Info',
      colProps: { span: 24 },
      componentProps: {
        showLabel: true,
        infoType: 2,
        width: '100%',
        disabled: true,
        placeholder: '',
        loadAgain: false,
        span: '',
        style: { width: '100%' },
      },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};

export const columns3: BasicColumn[] = [
  {
    dataIndex: 'factoryCode',
    title: '工位编号',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'factoryName',
    title: '工位名称',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'factoryManage',
    title: '工位负责人',
    componentType: 'user',

    sorter: true,
  },

  // {
  //   dataIndex: 'factoryAddress',
  //   title: '工位地址',
  //   componentType: 'input',

  //   sorter: true,
  // },

  {
    dataIndex: 'factoryId',
    title: '所属工厂',
    componentType: 'select',

    sorter: true,
  },

  {
    dataIndex: 'carId',
    title: '所属车间',
    componentType: 'select',

    sorter: true,
  },
  {
    dataIndex: 'lineId',
    title: '所属产线',
    componentType: 'select',

    sorter: true,
  },
  {
    dataIndex: 'remark',
    title: '备注',
    componentType: 'textarea',

    sorter: true,
  },

  {
    dataIndex: 'createUserId',
    title: '创建人',
    componentType: 'info',

    sorter: true,
  },

  {
    dataIndex: 'createDate',
    title: '创建时间',
    componentType: 'info',

    sorter: true,
  },
];

export const formProps3: FormProps = {
  // labelCol: { offset: 0, span: 3 },
  labelWidth: 120,
  labelAlign: 'right',
  layout: 'horizontal',
  size: 'default',
  schemas: [
    {
      key: 'fde0188c88d2446d9bfe6067b359dbf0',
      field: 'factoryCode',
      label: '工位编号',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        maxlength: 200,
        defaultValue: '',
        prefix: '',
        rules: [],
        suffix: '',
        addonAfter: '',
        showLabel: true,
        required: true,
        width: '100%',
        disabled: false,
        placeholder: '请输入工位编号',
        allowClear: false,
        addonBefore: '',
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '97e2263e951f44d2bccc93101bb7bce6',
      field: 'factoryName',
      label: '工位名称',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        maxlength: 200,
        defaultValue: '',
        prefix: '',
        rules: [],
        suffix: '',
        addonAfter: '',
        showLabel: true,
        required: true,
        width: '100%',
        disabled: false,
        placeholder: '请输入工位名称',
        allowClear: false,
        addonBefore: '',
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    // {
    //   key: 'e2bca928fc5e4d6792421811ff90df44',
    //   field: 'factoryManage',
    //   label: '工位负责人',
    //   type: 'user',
    //   component: 'User',
    //   colProps: { span: 24 },
    //   defaultValue: '',
    //   componentProps: {
    //     defaultValue: '',
    //     prefix: '',
    //     suffix: 'ant-design:setting-outlined',
    //     showLabel: true,
    //     required: true,
    //     width: '100%',
    //     disabled: false,
    //     placeholder: '工位负责人请选择人员',
    //     userType: 0,
    //     events: {},
    //     span: '',
    //     style: { width: '100%' },
    //   },
    // },
    // {
    //   key: 'd877e047c646490b96c23c3cffbad14d',
    //   field: 'factoryAddress',
    //   label: '工位地址',
    //   type: 'input',
    //   component: 'Input',
    //   colProps: { span: 24 },
    //   defaultValue: '',
    //   componentProps: {
    //     maxlength: 200,
    //     defaultValue: '',
    //     prefix: '',
    //     rules: [],
    //     suffix: '',
    //     addonAfter: '',
    //     showLabel: true,
    //     required: false,
    //     width: '100%',
    //     disabled: false,
    //     placeholder: '请输入工位地址',
    //     allowClear: false,
    //     addonBefore: '',
    //     events: {},
    //     span: '',
    //     style: { width: '100%' },
    //   },
    // },
    {
      key: '3d6d816de7a748ecae054c9f66691616',
      field: 'factoryId',
      label: '所属工厂',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 24 },
      componentProps: {
        clearable: false,
        defaultSelect: '',
        rules: [],
        valueField: 'value',
        showLabel: true,
        required: false,
        labelField: 'label',
        datasourceType: 'api',
        dicOptions: [],
        showSearch: false,
        width: '100%',
        apiConfig: {
          path: '/mes/mesFactory',
          method: 'GET',
          apiId: '6b4b40b3db664831b709f56bc98a7f04',
          apiParams: [
            {
              key: '1',
              title: 'Query Params',
              tableInfo: [
                {
                  name: 'factory_type',
                  value: '0',
                  description: null,
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: 'value',
                },
                {
                  name: 'factory_id',
                  value: '',
                  description: null,
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: 'value',
                },
                {
                  name: 'car_id',
                  value: '',
                  description: null,
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: 'value',
                },
              ],
            },
            { key: '2', title: 'Header', tableInfo: [] },
            { key: '3', title: 'Body' },
          ],
          script:
            'var condition="";\r\nif(factory_type!=null&&factory_type!=""){ \r\n    condition+=" and factory_type=#{factory_type}";\r\n}\r\nif(factory_id!=null&&factory_id!=""){ \r\n    condition+=" and factory_id=#{factory_id}";\r\n}\r\nif(car_id!=null&&car_id!=""){ \r\n    condition+=" and car_id=#{car_id}";\r\n}\r\n\r\nreturn db.select("SELECT id AS VALUE,CONCAT(factory_code,\'-\',factory_name) AS label FROM mes_base_factory where 1=1 "+condition)',
        },
        disabled: true,
        placeholder: '请选择',
        staticOptions: [
          { label: 'Option 1', value: 'Option 1', key: 1 },
          { label: 'Option 2', value: 'Option 2', key: 2 },
          { label: 'Option 3', value: 'Option 3', key: 3 },
        ],
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '154a1eb8ddfb47c0beb0988f6952195c',
      field: 'carId',
      label: '所属车间',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 24 },
      componentProps: {
        clearable: false,
        defaultSelect: '',
        rules: [],
        valueField: 'value',
        showLabel: true,
        required: false,
        labelField: 'label',
        datasourceType: 'api',
        dicOptions: [],
        showSearch: false,
        width: '100%',
        apiConfig: {
          path: '/mes/mesFactory',
          method: 'GET',
          apiId: '6b4b40b3db664831b709f56bc98a7f04',
          apiParams: [
            {
              key: '1',
              title: 'Query Params',
              tableInfo: [
                {
                  name: 'factory_type',
                  value: '1',
                  description: null,
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: 'value',
                },
                {
                  name: 'factory_id',
                  value: '',
                  description: null,
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: 'value',
                },
                {
                  name: 'car_id',
                  value: '',
                  description: null,
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: 'value',
                },
              ],
            },
            { key: '2', title: 'Header', tableInfo: [] },
            { key: '3', title: 'Body' },
          ],
          script:
            'var condition="";\r\nif(factory_type!=null&&factory_type!=""){ \r\n    condition+=" and factory_type=#{factory_type}";\r\n}\r\nif(factory_id!=null&&factory_id!=""){ \r\n    condition+=" and factory_id=#{factory_id}";\r\n}\r\nif(car_id!=null&&car_id!=""){ \r\n    condition+=" and car_id=#{car_id}";\r\n}\r\n\r\nreturn db.select("SELECT id AS VALUE,CONCAT(factory_code,\'-\',factory_name) AS label FROM mes_base_factory where 1=1 "+condition)',
        },
        disabled: true,
        placeholder: '请选择',
        staticOptions: [
          { label: 'Option 1', value: 'Option 1', key: 1 },
          { label: 'Option 2', value: 'Option 2', key: 2 },
          { label: 'Option 3', value: 'Option 3', key: 3 },
        ],
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '154a1eb8ddfb47c0beb0988f6952195c',
      field: 'lineId',
      label: '所属产线',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 24 },
      componentProps: {
        clearable: false,
        defaultSelect: '',
        rules: [],
        valueField: 'value',
        showLabel: true,
        required: false,
        labelField: 'label',
        datasourceType: 'api',
        dicOptions: [],
        showSearch: false,
        width: '100%',
        apiConfig: {
          path: '/mes/mesFactory',
          method: 'GET',
          apiId: '6b4b40b3db664831b709f56bc98a7f04',
          apiParams: [
            {
              key: '1',
              title: 'Query Params',
              tableInfo: [
                {
                  name: 'factory_type',
                  value: '2',
                  description: null,
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: 'value',
                },
                {
                  name: 'factory_id',
                  value: '',
                  description: null,
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: 'value',
                },
                {
                  name: 'car_id',
                  value: '',
                  description: null,
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: 'value',
                },
              ],
            },
            { key: '2', title: 'Header', tableInfo: [] },
            { key: '3', title: 'Body' },
          ],
          script:
            'var condition="";\r\nif(factory_type!=null&&factory_type!=""){ \r\n    condition+=" and factory_type=#{factory_type}";\r\n}\r\nif(factory_id!=null&&factory_id!=""){ \r\n    condition+=" and factory_id=#{factory_id}";\r\n}\r\nif(car_id!=null&&car_id!=""){ \r\n    condition+=" and car_id=#{car_id}";\r\n}\r\n\r\nreturn db.select("SELECT id AS VALUE,CONCAT(factory_code,\'-\',factory_name) AS label FROM mes_base_factory where 1=1 "+condition)',
        },
        disabled: true,
        placeholder: '请选择',
        staticOptions: [
          { label: 'Option 1', value: 'Option 1', key: 1 },
          { label: 'Option 2', value: 'Option 2', key: 2 },
          { label: 'Option 3', value: 'Option 3', key: 3 },
        ],
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: 'ca233109618d46179ad3e3bf8525c131',
      field: 'remark',
      label: '备注',
      type: 'textarea',
      component: 'InputTextArea',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        maxlength: 255,
        defaultValue: '',
        rules: [],
        rows: 4,
        showLabel: true,
        required: false,
        autoSize: false,
        showCount: false,
        width: '100%',
        disabled: false,
        placeholder: '请输入备注',
        allowClear: false,
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '69d76fe5c7a14140b0e2f5a5cb6511a9',
      field: 'createUserId',
      label: '创建人',
      type: 'info',
      component: 'Info',
      colProps: { span: 24 },
      componentProps: {
        showLabel: true,
        infoType: 0,
        width: '100%',
        disabled: true,
        placeholder: '',
        loadAgain: false,
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: 'd935579cbca54308a9212deb59c692cf',
      field: 'createDate',
      label: '创建时间',
      type: 'info',
      component: 'Info',
      colProps: { span: 24 },
      componentProps: {
        showLabel: true,
        infoType: 2,
        width: '100%',
        disabled: true,
        placeholder: '',
        loadAgain: false,
        span: '',
        style: { width: '100%' },
      },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};
