import { reactive } from 'vue';
import { setExclusiveApprovalProcess } from '/@/api/workflow/process';

// 流程审批独占模式
export function useExclusiveApprovalProcess() {
  const exclusiveApprovalProcessData: {
    taskId: string;
  } = reactive({
    taskId: '',
  });
  function setData(taskId) {
    window.localStorage.setItem('exclusiveApprovalProcessTaskId', taskId);
  }
  function resetData() {
    setData('');
  }
  // 开启
  async function handleOpenExclusiveApprovalProcess(taskId) {
    setData(taskId);
  }
  // 关闭
  async function handleCLoseExclusiveApprovalProcess() {
    try {
      const val = window.localStorage.getItem('exclusiveApprovalProcessTaskId');
      if (val) {
        resetData();
        await setExclusiveApprovalProcess(val);
      }
    } catch (error) {}
  }

  return {
    exclusiveApprovalProcessData,
    handleOpenExclusiveApprovalProcess,
    handleCLoseExclusiveApprovalProcess,
  };
}
