import {
  MesProSchetoolModel,
  MesProSchetoolPageParams,
  MesProSchetoolPageResult,
} from './model/ScheToolModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/mes/schetool/page',
  List = '/mes/schetool/list',
  Info = '/mes/schetool/info',
  MesProSchetool = '/mes/schetool',

  MessaveBatch = '/mes/schetool/saveBatch',
}

/**
 * @description: 新增排期工具
 */
export async function addMessaveBatch(params: any, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MessaveBatch,
      params: params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 查询MesProSchetool分页列表
 */
export async function getMesProSchetoolPage(
  params: MesProSchetoolPageParams,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.get<MesProSchetoolPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesProSchetool信息
 */
export async function getMesProSchetool(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesProSchetoolModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesProSchetool
 */
export async function addMesProSchetool(
  mesProSchetool: Recordable,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.post<boolean>(
    {
      url: Api.MesProSchetool,
      params: mesProSchetool,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesProSchetool
 */
export async function updateMesProSchetool(
  mesProSchetool: Recordable,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.put<boolean>(
    {
      url: Api.MesProSchetool,
      params: mesProSchetool,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesProSchetool（批量删除）
 */
export async function deleteMesProSchetool(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesProSchetool,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}
export async function exportInfo(scheId: string, mode: ErrorMessageMode = 'modal') {
  return defHttp.download(
    {
      url: '/mes/schetool/export/' + scheId,
      method: 'POST',
      // params: scheId,
      responseType: 'blob',
    },
    {
      errorMessageMode: mode,
    },
  );
}

export async function getMesProSchetoolList(
  params: MesProSchetoolPageParams,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.get(
    {
      url: Api.List,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}
