import { BasicPageParams, BasicFetchResult } from '/@/api/model/baseModel';

/**
 * @description: MesProOrderworkReportwork分页参数 模型
 */
export interface MesProOrderworkReportworkPageParams extends BasicPageParams {
  workId: string;
  materialId: string;

  materialNo: string;

  materialName: string;

  model: string;

  unity: string;

  workNum: string;

  workDev: string;

  userStation: string;
}

/**
 * @description: MesProOrderworkReportwork分页返回值模型
 */
export interface MesProOrderworkReportworkPageModel {
  id: string;

  materialId: string;

  materialNo: string;

  materialName: string;

  model: string;

  unity: string;

  workNum: string;

  workDev: string;

  userStation: string;
}

/**
 * @description: MesProOrderworkReportwork表类型
 */
export interface MesProOrderworkReportworkModel {
  id: number;

  workId: string;

  materialId: string;

  materialNo: string;

  materialName: string;

  model: string;

  unity: string;

  workNum: string;

  workDev: string;

  userStation: string;

  groupId: string;

  remark: string;

  state: number;

  sort: number;

  createUserId: number;

  createDate: string;

  modifyUserId: number;

  modifyDate: string;

  deleteMark: number;

  enabledMark: number;
}

/**
 * @description: MesProOrderworkReportwork分页返回值结构
 */
export type MesProOrderworkReportworkPageResult =
  BasicFetchResult<MesProOrderworkReportworkPageModel>;
