import {
  MesProOrderworkStepModel,
  MesProOrderworkStepPageParams,
  MesProOrderworkStepPageResult,
} from './model/ProOrderWorkStepModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/mes/proorderworkstep/page',
  List = '/mes/proorderworkstep/list',
  Info = '/mes/proorderworkstep/info',
  MesProOrderworkStep = '/mes/proorderworkstep',
}

/**
 * @description: 查询MesProOrderworkStep分页列表
 */
export async function getMesProOrderworkStepPage(
  params: MesProOrderworkStepPageParams,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.get<MesProOrderworkStepPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesProOrderworkStep信息
 */
export async function getMesProOrderworkStep(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesProOrderworkStepModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesProOrderworkStep
 */
export async function addMesProOrderworkStep(
  mesProOrderworkStep: Recordable,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.post<boolean>(
    {
      url: Api.MesProOrderworkStep,
      params: mesProOrderworkStep,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesProOrderworkStep
 */
export async function updateMesProOrderworkStep(
  mesProOrderworkStep: Recordable,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.put<boolean>(
    {
      url: Api.MesProOrderworkStep,
      params: mesProOrderworkStep,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesProOrderworkStep（批量删除）
 */
export async function deleteMesProOrderworkStep(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesProOrderworkStep,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}

export async function updateMesProOrderworkStepBatch(
  mesProOrderworkStep: Recordable,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.post<boolean>(
    {
      url: '/mes/proorderworkstep/batchSave',
      params: mesProOrderworkStep,
    },
    {
      errorMessageMode: mode,
    },
  );
}

export async function updateMesProOrderworkStepMergeBatchUser(
  mesProOrderworkStep: Recordable,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.post<boolean>(
    {
      url: '/mes/proorderworkstep/mergeBatchUser',
      params: mesProOrderworkStep,
    },
    {
      errorMessageMode: mode,
    },
  );
}
