import { MesQlIncheckerrorModel, MesQlIncheckerrorPageParams, MesQlIncheckerrorPageResult } from './model/MesqlincheckerrorModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/mes/mesqlincheckerror/page',
  List = '/mes/mesqlincheckerror/list',
  Info = '/mes/mesqlincheckerror/info',
  MesQlIncheckerror = '/mes/mesqlincheckerror',
  
  
}

/**
 * @description: 查询MesQlIncheckerror分页列表
 */
export async function getMesQlIncheckerrorPage(params: MesQlIncheckerrorPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesQlIncheckerrorPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesQlIncheckerror信息
 */
export async function getMesQlIncheckerror(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesQlIncheckerrorModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesQlIncheckerror
 */
export async function addMesQlIncheckerror(mesQlIncheckerror: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesQlIncheckerror,
      params: mesQlIncheckerror,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesQlIncheckerror
 */
export async function updateMesQlIncheckerror(mesQlIncheckerror: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.MesQlIncheckerror,
      params: mesQlIncheckerror,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesQlIncheckerror（批量删除）
 */
export async function deleteMesQlIncheckerror(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesQlIncheckerror,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}